/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau.papiselect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.tau.papiselect.PapiSelect;
import org.eclipse.ptp.etfw.tau.papiselect.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class PapiListSelectionDialog
extends SelectionDialog {
    private final Object inputElement;
    private final ILabelProvider labelProvider;
    private final IStructuredContentProvider contentProvider;
    CheckboxTableViewer listViewer;
    private final PapiSelect papiCon;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    public static final int PRESET = 0;
    public static final int NATIVE = 1;

    public PapiListSelectionDialog(Shell parentShell, IFileStore papiloc, IBuildLaunchUtils blt, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message, int papiCountType) {
        super(parentShell);
        this.setTitle(Messages.PapiListSelectionDialog_PapiCounters);
        this.papiCon = new PapiSelect(papiloc, blt, papiCountType);
        this.inputElement = this.papiCon.getAvail().toArray();
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(Messages.PapiListSelectionDialog_SelectPapiCounters);
        }
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button selectButton = this.createButton(buttonComposite, 18, Messages.PapiListSelectionDialog_SelectAll, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] masterlist;
                Object[] objectArray = masterlist = PapiListSelectionDialog.this.contentProvider.getElements(PapiListSelectionDialog.this.inputElement);
                int n = masterlist.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    PapiListSelectionDialog.this.listViewer.setChecked(element, true);
                    PapiListSelectionDialog.this.updateGrey(element);
                    ++n2;
                }
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, Messages.PapiListSelectionDialog_DeselectAll, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PapiListSelectionDialog.this.listViewer.setAllChecked(false);
                PapiListSelectionDialog.this.listViewer.setAllGrayed(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        Button helpButton = this.createButton(buttonComposite, 17, Messages.PapiListSelectionDialog_CounterDescs, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PapiListSelectionDialog.this.displayPapiDescs();
            }
        };
        helpButton.addSelectionListener((SelectionListener)listener);
    }

    private void checkInitialSelections() {
        for (Object nextcheck : this.getInitialElementSelections()) {
            this.listViewer.setChecked(nextcheck, true);
            this.updateGrey(nextcheck);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.list_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        class PapiCheckListener
        implements ICheckStateListener {
            PapiCheckListener() {
            }

            public void checkStateChanged(CheckStateChangedEvent event) {
                PapiListSelectionDialog.this.updateGrey(event.getElement());
            }
        }
        this.listViewer.addCheckStateListener((ICheckStateListener)new PapiCheckListener());
        this.addSelectionButtons(composite);
        this.initializeViewer();
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void displayPapiDescs() {
        Display thisDisplay = PlatformUI.getWorkbench().getDisplay();
        Shell eDefShell = new Shell(thisDisplay.getActiveShell(), 16);
        eDefShell.setText(Messages.PapiListSelectionDialog_CounterDescs);
        eDefShell.setMinimumSize(200, 100);
        eDefShell.setSize(400, 300);
        eDefShell.setLayout((Layout)new FillLayout());
        Table table = new Table((Composite)eDefShell, 2048);
        table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.PapiListSelectionDialog_Counter);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.PapiListSelectionDialog_Definition);
        Vector<String> cNames = this.papiCon.getCounterNames();
        Vector<String> cDefs = this.papiCon.getCounterDefs();
        int i = 0;
        while (i < cNames.size()) {
            TableItem item = new TableItem(table, 0);
            item.setText(new String[]{cNames.get(i), cDefs.get(i)});
            ++i;
        }
        column1.pack();
        column2.pack();
        eDefShell.open();
    }

    protected CheckboxTableViewer getViewer() {
        return this.listViewer;
    }

    private void initializeViewer() {
        this.listViewer.setInput(this.inputElement);
    }

    protected void okPressed() {
        Object[] children = this.contentProvider.getElements(this.inputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object element2 = objectArray[n2];
                Object element = element2;
                if (this.listViewer.getChecked(element) && !this.listViewer.getGrayed(element)) {
                    list.add(element);
                }
                ++n2;
            }
            this.setResult(list);
        }
        super.okPressed();
    }

    protected void updateGrey(Object element) {
        try {
            if (this.listViewer.getGrayed(element)) {
                if (!this.listViewer.getChecked(element)) {
                    this.listViewer.setChecked(element, true);
                }
                return;
            }
            if (this.listViewer.getChecked(element)) {
                LinkedHashSet<Object> allgrey = this.papiCon.getGrey(this.listViewer.getCheckedElements(), this.listViewer.getGrayedElements());
                allgrey.addAll(Arrays.asList(this.listViewer.getGrayedElements()));
                this.listViewer.setGrayedElements(allgrey.toArray());
                LinkedHashSet<Object> checkall = new LinkedHashSet<Object>();
                checkall.addAll(Arrays.asList(this.listViewer.getCheckedElements()));
                checkall.addAll(allgrey);
                this.listViewer.setCheckedElements(checkall.toArray());
            } else {
                LinkedHashSet<Object> allgrey = new LinkedHashSet<Object>(Arrays.asList(this.listViewer.getGrayedElements()));
                LinkedHashSet<Object> maybegood = new LinkedHashSet<Object>(Arrays.asList(this.listViewer.getCheckedElements()));
                maybegood.removeAll(allgrey);
                allgrey = this.papiCon.getGrey(maybegood.toArray(), null);
                this.listViewer.setGrayedElements(allgrey.toArray());
                LinkedHashSet<Object> checkall = new LinkedHashSet<Object>(maybegood);
                checkall.addAll(allgrey);
                this.listViewer.setCheckedElements(checkall.toArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

