/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.ScriptHandler;
import org.eclipse.ptp.internal.rm.jaxb.control.core.variables.RMVariableMap;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.JAXBControlUIConstants;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.dialogs.ScrollingEditableMessageDialog;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.handlers.ControlStateListener;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.launch.IJAXBLaunchConfigurationTab;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.launch.IJAXBParentLaunchConfigurationTab;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.model.ViewerUpdateModel;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.utils.LaunchTabBuilder;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.utils.WidgetActionUtils;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.variables.LCVariableMap;
import org.eclipse.ptp.internal.rm.jaxb.ui.JAXBUIPlugin;
import org.eclipse.ptp.internal.rm.jaxb.ui.util.WidgetBuilderUtils;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.messages.Messages;
import org.eclipse.ptp.launch.ui.extensions.AbstractJAXBLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.JAXBControllerLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.ui.ICellEditorUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModel;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.ButtonActionType;
import org.eclipse.ptp.rm.jaxb.core.data.TabControllerType;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class JAXBDynamicLaunchConfigurationTab
extends AbstractJAXBLaunchConfigurationTab
implements IJAXBLaunchConfigurationTab,
SelectionListener {
    protected final ILaunchController fControl;
    protected final IUpdateHandler updateHandler;
    protected final List<Viewer> viewers;
    protected final Map<Object, IUpdateModel> localWidgets;
    protected final IRMLaunchConfigurationDynamicTab fDynamicTab;
    protected Collection<ControlStateListener> listeners;
    protected ILaunchConfiguration listenerConfiguration;
    protected TabControllerType controller;
    protected String[] shared;
    protected final Collection<IUpdateModel> sharedModels;
    protected boolean checkCycles = true;

    public JAXBDynamicLaunchConfigurationTab(ILaunchController control, TabControllerType controller, JAXBControllerLaunchConfigurationTab parentTab) {
        this(control, parentTab);
        String title = controller.getTitle();
        if (title != null) {
            this.title = title;
        }
        this.controller = controller;
        String s = controller.getIncludeWidgetValuesFrom();
        this.shared = s == null ? new String[0] : s.split(",");
    }

    protected JAXBDynamicLaunchConfigurationTab(ILaunchController control, JAXBControllerLaunchConfigurationTab parentTab) {
        super(parentTab);
        this.fControl = control;
        this.fDynamicTab = parentTab;
        this.sharedModels = new ArrayList<IUpdateModel>();
        this.updateHandler = parentTab.getUpdateHandler();
        this.localWidgets = new HashMap<Object, IUpdateModel>();
        this.viewers = new ArrayList<Viewer>();
        this.setLaunchConfigurationDialog(parentTab.getLaunchConfigurationDialog());
    }

    @Override
    public RMLaunchValidation canSave(Control control) {
        return this.checkForValidationError();
    }

    @Override
    public void createControl(Composite parent, String id) throws CoreException {
        try {
            LaunchTabBuilder builder = new LaunchTabBuilder((IJAXBLaunchConfigurationTab)this);
            if (this.listeners != null) {
                this.listeners.clear();
            }
            this.control = builder.build(parent, this.checkCycles);
        }
        catch (CoreException e) {
            throw CoreExceptionUtils.newException((String)NLS.bind((String)Messages.CreateControlConfigurableError, (Object)this.title), (Throwable)e);
        }
        this.createViewScriptGroup(this.control);
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    public TabControllerType getController() {
        return this.controller;
    }

    @Override
    public Image getImage() {
        return null;
    }

    public ILaunchController getJobControl() {
        return this.fControl;
    }

    public Map<Object, IUpdateModel> getLocalWidgets() {
        return this.localWidgets;
    }

    public IJAXBParentLaunchConfigurationTab getParent() {
        return this.parentTab;
    }

    public IRemoteConnection getRemoteConnection() {
        return this.getParent().getConnection();
    }

    @Override
    public String getText() {
        return this.title;
    }

    @Override
    public RMLaunchValidation initializeFrom(ILaunchConfiguration configuration) {
        this.listenerConfiguration = configuration;
        try {
            IUpdateHandler handler = this.getParent().getUpdateHandler();
            this.viewers.clear();
            for (Map.Entry<Object, IUpdateModel> e : this.localWidgets.entrySet()) {
                Object key = e.getKey();
                if (key instanceof Viewer) {
                    Viewer viewer = (Viewer)key;
                    this.viewers.add(viewer);
                }
                handler.addUpdateModelEntry(key, e.getValue());
            }
            LCVariableMap lcMap = this.parentTab.getVariableMap();
            IVariableMap rmMap = null;
            rmMap = this.parentTab.getRMVariableMap() != null ? this.parentTab.getRMVariableMap() : this.fControl.getEnvironment();
            this.fControl.getEnvironment();
            for (IUpdateModel m : this.localWidgets.values()) {
                m.initialize(configuration, rmMap, (IVariableMap)lcMap);
            }
            for (IUpdateModel m : this.localWidgets.values()) {
                Control mControl = null;
                if (m instanceof ViewerUpdateModel) {
                    ViewerUpdateModel vmodel = (ViewerUpdateModel)m;
                    vmodel.initializeChecked();
                    mControl = vmodel.getSWTControl();
                } else if (!(m instanceof ICellEditorUpdateModel)) {
                    mControl = (Control)m.getControl();
                }
                if (mControl == null) continue;
                mControl.setVisible(true);
            }
            if (this.listeners != null) {
                for (ControlStateListener l : this.listeners) {
                    l.setState();
                }
            }
            for (Viewer v : this.viewers) {
                v.refresh();
            }
        }
        catch (Throwable t) {
            PTPLaunchPlugin.log(t);
            return new RMLaunchValidation(false, t.getMessage());
        }
        return new RMLaunchValidation(true, null);
    }

    @Override
    public RMLaunchValidation isValid(ILaunchConfiguration launchConfig) {
        return this.checkForValidationError();
    }

    @Override
    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration) {
        RMLaunchValidation v;
        if (this.control == null) {
            return new RMLaunchValidation(false, null);
        }
        if (this.control.isVisible() && !(v = this.checkForValidationError()).isSuccess()) {
            return v;
        }
        return super.performApply(configuration);
    }

    public void run(ButtonActionType action) throws CoreException {
        this.getJobControl().runCommand(action.getAction(), action.getClearValue(), this.listenerConfiguration);
        if (action.isRefresh()) {
            try {
                this.fDynamicTab.initializeFrom(null);
            }
            catch (Throwable t) {
                throw CoreExceptionUtils.newException((String)t.getLocalizedMessage(), (Throwable)t);
            }
        }
    }

    @Override
    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        return new RMLaunchValidation(true, null);
    }

    public void setListeners(Collection<ControlStateListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void setUpSharedEnvironment(Map<String, AbstractJAXBLaunchConfigurationTab> controllers) throws CoreException {
        this.sharedModels.clear();
        String[] stringArray = this.shared;
        int n = this.shared.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            AbstractJAXBLaunchConfigurationTab tab = controllers.get(title);
            if (tab instanceof JAXBDynamicLaunchConfigurationTab) {
                this.sharedModels.addAll(((JAXBDynamicLaunchConfigurationTab)tab).localWidgets.values());
            }
            ++n2;
        }
    }

    @Override
    public void setVisible() {
        try {
            this.refreshLocal(this.listenerConfiguration.getWorkingCopy());
            this.fireContentsChanged();
        }
        catch (CoreException t) {
            JAXBUIPlugin.log((Throwable)t);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Button b = (Button)e.getSource();
        Shell shell = Display.getDefault().getActiveShell();
        String title = "";
        try {
            String text = "";
            if (Messages.ViewConfig.equals(b.getText())) {
                text = this.displayConfigurationContents(this.listenerConfiguration);
                title = Messages.DisplayConfig;
            } else if (Messages.ViewExcluded.equals(b.getText())) {
                text = this.displayExcluded();
                title = Messages.ViewExcluded;
            } else {
                if (!this.parentTab.hasScript()) {
                    MessageDialog.openWarning((Shell)shell, (String)Messages.ScriptNotSupportedWarning_title, (String)(String.valueOf(Messages.ScriptNotSupportedWarning) + JAXBControlUIConstants.LINE_SEP));
                    return;
                }
                text = this.realizeLocalScript(this.listenerConfiguration);
                title = Messages.DisplayScript;
            }
            new ScrollingEditableMessageDialog(shell, title, text, true).open();
        }
        catch (Throwable t) {
            WidgetActionUtils.errorMessage((Shell)shell, (Throwable)t, (String)Messages.DisplayError, (String)Messages.DisplayErrorTitle, (boolean)false);
        }
    }

    private RMLaunchValidation checkForValidationError() {
        String error = this.parentTab.getUpdateHandler().getFirstError();
        if (error != null) {
            return new RMLaunchValidation(false, error);
        }
        return new RMLaunchValidation(true, null);
    }

    private void createViewScriptGroup(Composite control) {
        Button b;
        GridLayout layout = WidgetBuilderUtils.createGridLayout((Integer)4, (Boolean)true, (Integer)5, (Integer)5, (Integer)2, (Integer)2);
        GridData gd = WidgetBuilderUtils.createGridData((Integer)0, (Integer)4);
        Group grp = WidgetBuilderUtils.createGroup((Composite)control, (Integer)0, (Layout)layout, (Object)gd);
        if (this.parentTab.hasScript()) {
            b = WidgetBuilderUtils.createPushButton((Composite)grp, (String)Messages.ViewScript, (SelectionListener)this);
            WidgetBuilderUtils.setButtonDimensionHint((Button)b);
        }
        if (this.controller.isShowViewConfig()) {
            b = WidgetBuilderUtils.createPushButton((Composite)grp, (String)Messages.ViewConfig, (SelectionListener)this);
            WidgetBuilderUtils.setButtonDimensionHint((Button)b);
            b.setToolTipText(Messages.ViewConfigTooltip);
        }
        if (this.controller.isShowViewExcluded()) {
            b = WidgetBuilderUtils.createPushButton((Composite)grp, (String)Messages.ViewExcluded, (SelectionListener)this);
            WidgetBuilderUtils.setButtonDimensionHint((Button)b);
            b.setToolTipText(Messages.ViewExcludedTooltip);
        }
        b = WidgetBuilderUtils.createPushButton((Composite)grp, (String)Messages.DefaultValues, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                JAXBDynamicLaunchConfigurationTab.this.resetDefaults();
            }
        });
        WidgetBuilderUtils.setButtonDimensionHint((Button)b);
    }

    private synchronized String displayConfigurationContents(final ILaunchConfiguration config) throws Throwable {
        final StringBuffer buffer = new StringBuffer();
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Map validCurrent = RMVariableMap.getValidAttributes((ILaunchConfiguration)config);
                    for (Map.Entry e : validCurrent.entrySet()) {
                        Object v = e.getValue();
                        buffer.append((String)e.getKey()).append("=").append(v).append(JAXBControlUIConstants.LINE_SEP);
                    }
                }
                catch (CoreException t) {
                    return CoreExceptionUtils.getErrorStatus((String)t.getMessage(), (Throwable)t);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return buffer.toString();
    }

    private String displayExcluded() throws Throwable {
        final StringBuffer buffer = new StringBuffer();
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                Map excluded = JAXBDynamicLaunchConfigurationTab.this.parentTab.getVariableMap().getExcluded();
                for (Map.Entry e : excluded.entrySet()) {
                    Object v = e.getValue();
                    buffer.append((String)e.getKey()).append("=").append(v).append(JAXBControlUIConstants.LINE_SEP);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return buffer.toString();
    }

    private Set<String> getSharedValid(Set<String> localInvalid) {
        HashSet<String> sharedInvalid = new HashSet<String>();
        LCVariableMap lcMap = this.parentTab.getVariableMap();
        String[] stringArray = this.shared;
        int n = this.shared.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            String invalid = (String)lcMap.getValue("invalid_" + title);
            if (invalid != null) {
                String[] names;
                String[] stringArray2 = names = invalid.split(" ");
                int n3 = names.length;
                int n4 = 0;
                while (n4 < n3) {
                    String name = stringArray2[n4];
                    sharedInvalid.add(name.trim());
                    ++n4;
                }
            }
            ++n2;
        }
        TreeSet<String> sharedValid = new TreeSet<String>();
        for (IUpdateModel m : this.sharedModels) {
            String name = m.getName();
            if (name == null || sharedInvalid.contains(name) || localInvalid.contains(name)) continue;
            sharedValid.add(name);
        }
        return sharedValid;
    }

    private synchronized String realizeLocalScript(ILaunchConfiguration config) throws Throwable {
        String value = "";
        LCVariableMap lcMap = this.parentTab.getVariableMap();
        lcMap.shiftToCurrent(this.getControllerTag());
        Map env = config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
        ScriptHandler job = new ScriptHandler(null, this.parentTab.getScript(), (IVariableMap)lcMap, env, true);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        value = job.getScriptValue();
        lcMap.restoreGlobal();
        return value;
    }

    private void refresh(IUpdateModel model, LCVariableMap lcMap) {
        boolean enabled;
        String name = model.getName();
        if (name == null || "".equals(name)) {
            return;
        }
        Object value = null;
        boolean selected = true;
        Control c = null;
        if (model instanceof ViewerUpdateModel) {
            ViewerUpdateModel vmodel = (ViewerUpdateModel)model;
            vmodel.putCheckedSettings(lcMap);
            c = vmodel.getSWTControl();
        } else if (model instanceof ICellEditorUpdateModel) {
            ICellEditorUpdateModel cellModel = (ICellEditorUpdateModel)model;
            selected = cellModel.isChecked();
            c = cellModel.getParent().getControl();
        } else {
            c = (Control)model.getControl();
        }
        if (model.isWritable() && selected) {
            value = model.getValueFromControl();
            lcMap.putValue(name, value);
        }
        boolean visible = c == null ? false : !this.getParent().isInitialized() || c.isVisible();
        boolean bl = enabled = c == null ? false : c.isEnabled();
        if (visible) {
            this.visibleList.add(name);
            if (enabled) {
                this.enabledList.add(name);
                if (model.isWritable() && selected) {
                    this.validSet.add(name);
                }
            }
        } else if (enabled) {
            this.enabledList.add(name);
        }
    }

    @Override
    protected void doRefreshLocal() {
        LCVariableMap lcMap = this.parentTab.getVariableMap();
        for (IUpdateModel m : this.localWidgets.values()) {
            this.refresh(m, lcMap);
        }
        if (this.listeners != null) {
            for (ControlStateListener l : this.listeners) {
                l.setState();
            }
        }
    }

    protected Set<String> getLocalInvalid() {
        TreeSet<String> locaInvalid = new TreeSet<String>();
        for (IUpdateModel m : this.localWidgets.values()) {
            String name = m.getName();
            if (name == null || this.validSet.contains(name)) continue;
            locaInvalid.add(name);
        }
        locaInvalid.add("script_path");
        return locaInvalid;
    }

    protected synchronized void resetDefaults() {
        Collection<IUpdateModel> models = this.localWidgets.values();
        for (IUpdateModel m : models) {
            m.restoreDefault();
        }
        for (IUpdateModel m : models) {
            if (!(m instanceof ViewerUpdateModel)) continue;
            ((ViewerUpdateModel)m).storeValue();
        }
        this.updateHandler.handleUpdate(null, null);
        for (Viewer v : this.viewers) {
            v.refresh();
        }
    }

    @Override
    protected void writeLocalProperties() {
        LCVariableMap lcMap = this.parentTab.getVariableMap();
        String id = this.getControllerTag();
        lcMap.putValue("current_controller", (Object)id);
        StringBuffer list = new StringBuffer();
        for (String var : this.visibleList) {
            list.append(var).append(" ");
        }
        lcMap.putValue("visible_" + id, (Object)list.toString().trim());
        list.setLength(0);
        for (String var : this.enabledList) {
            list.append(var).append(" ");
        }
        lcMap.putValue("enabled_" + id, (Object)list.toString().trim());
        Set<String> set = this.getLocalInvalid();
        list.setLength(0);
        for (String var : set) {
            list.append(var).append(" ");
        }
        lcMap.putValue("invalid_" + id, (Object)list.toString().trim());
        set = this.getSharedValid(set);
        set.addAll(this.validSet);
        set.addAll(lcMap.getHidden());
        set.add("current_controller");
        set.add("visible_" + id);
        set.add("enabled_" + id);
        set.add("invalid_" + id);
        set.add("valid_" + id);
        list.setLength(0);
        for (String var : set) {
            list.append(var).append(" ");
        }
        lcMap.putValue("valid_" + id, (Object)list.toString().trim());
    }

    public boolean isCheckCycles() {
        return this.checkCycles;
    }

    public void setCheckCycles(boolean checkCycles) {
        this.checkCycles = checkCycles;
    }
}

