/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7Status;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.core.persistence.plain.PlainTextPersistenceModel;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.internal.core.Q7LazyResource;
import org.eclipse.rcptt.internal.core.model.OpenableElementInfo;

public class Q7ResourceInfo
extends OpenableElementInfo {
    private final Resource resource;
    private NamedElement element;
    public long timestamp;
    private final String plainStoreFormat;

    public Q7ResourceInfo(String storeFormat, URI uri) {
        this.plainStoreFormat = storeFormat;
        if (uri == null) {
            this.resource = null;
        } else {
            this.resource = new Q7LazyResource(uri);
            this.resource.setTrackingModification(true);
        }
    }

    public void load(IFile file) throws ModelException {
        if (this.resource == null) {
            throw new NullPointerException("Resource info " + this.plainStoreFormat + " can't be associated with a file");
        }
        if (file != null) {
            this.timestamp = file.getModificationStamp();
        }
        URI uri = Q7ResourceInfo.toURI(file);
        IPersistenceModel model = this.getPersistenceModel();
        if (file != null && !file.exists()) {
            Q7Status status = new Q7Status(4, "Element: " + file.getFullPath() + " doesn't exist");
            status.setStatusCode(Q7Status.Q7StatusCode.NotPressent);
            throw new ModelException(status);
        }
        InputStream stream = PersistenceManager.getInstance().loadMetadata(model);
        try {
            try {
                if (stream == null && file != null && !model.isAllowEmptyMetadataContent()) {
                    stream = file.getContents();
                }
                if (stream != null) {
                    this.resource.load(stream, PersistenceManager.getOptions());
                }
                model.updateMetadata();
                EList contents = this.resource.getContents();
                this.resource.setModified(false);
                if (contents.size() == 0) {
                    throw new RuntimeException("Empty resource " + uri);
                }
                for (EObject eObject : contents) {
                    if (!(eObject instanceof NamedElement)) continue;
                    this.element = (NamedElement)eObject;
                }
                if (this.element == null) {
                    throw new ModelException(new Q7Status(4, "Illegal object type: " + ((EObject)contents.get(0)).getClass().getName()));
                }
            }
            catch (Exception e) {
                PersistenceManager.getInstance().remove(this.resource);
                throw new ModelException((Throwable)e, 4);
            }
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static URI toURI(IFile file) {
        return URI.createPlatformResourceURI((String)(file != null ? file.getFullPath().toString() : "__uri__"), (boolean)true);
    }

    protected IPersistenceModel getPersistenceModel() {
        return PersistenceManager.getInstance().getModel(this.resource);
    }

    public void unload() {
        PersistenceManager.getInstance().remove(this.resource);
        this.element = null;
        this.timestamp = 0L;
    }

    public NamedElement getNamedElement() {
        return this.element;
    }

    public void extractAllPersistence() {
        this.getPersistenceModel().extractAll();
    }

    public void save() {
        IPersistenceModel model = this.getPersistenceModel();
        if (model instanceof PlainTextPersistenceModel) {
            ((PlainTextPersistenceModel)model).setSaveFormat(this.plainStoreFormat);
        }
        PersistenceManager.getInstance().saveResource(this.resource);
        this.resource.setModified(false);
        model.setUnmodified();
    }

    public IPersistenceModel getModel() {
        return this.getPersistenceModel();
    }

    public boolean hasChanges() {
        if (this.resource == null) {
            return true;
        }
        return this.resource.isModified() || this.getPersistenceModel().isModified();
    }

    public void createNamedElement(NamedElement createNamedElement) {
        this.element = createNamedElement;
        this.resource.getContents().add((Object)this.element);
    }

    public Resource getResource() {
        return this.resource;
    }

    public void updatePersistenceModel(IPersistenceModel newModel) {
        PersistenceManager.getInstance().replaceModelWith(this.resource, newModel);
    }
}

