/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.keyboard;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.core.lookup.WidgetLookup;
import org.eclipse.reddeer.swt.keyboard.DefaultKeyboardLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public abstract class Keyboard {
    private static final Logger log = Logger.getLogger(Keyboard.class);
    private static final int DELAY = 200;

    public void invokeKeyCombination(int ... keys) {
        Control w = WidgetLookup.getInstance().getFocusControl();
        log.info("Invoke key combination: ");
        int i = 0;
        while (i < keys.length) {
            log.info("    As char:" + (char)keys[i] + ", as int:" + keys[i]);
            this.sync();
            Display.getDisplay().post(this.keyEvent(keys[i], 1, (Widget)w));
            ++i;
        }
        i = keys.length - 1;
        while (i >= 0) {
            this.sync();
            Display.getDisplay().post(this.keyEvent(keys[i], 2, (Widget)w));
            this.sync();
            --i;
        }
    }

    public void type(String text) {
        log.info("Type text \"" + text + "\"");
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            this.invokeKeyCombination(DefaultKeyboardLayout.getInstance().getKeyCombination(c));
            ++n2;
        }
    }

    public void type(int c) {
        log.info("Type character '" + (char)c + "', as int:" + c);
        this.press(c);
        this.release(c);
    }

    public void select(int shift, boolean toLeft) {
        if (toLeft) {
            log.info("Select " + shift + " characters to the left");
        } else {
            log.debug("Select " + shift + " characters to the right");
        }
        this.press(131072);
        this.moveCursor(shift, toLeft);
        this.release(131072);
    }

    public void moveCursor(int shift, boolean toLeft) {
        log.info("Move cursor");
        int i = 0;
        while (i < shift) {
            this.sync();
            if (toLeft) {
                this.type(0x1000003);
            } else {
                this.type(0x1000004);
            }
            ++i;
        }
    }

    public abstract void writeToClipboard(boolean var1);

    public abstract void pasteFromClipboard();

    protected void press(final int key) {
        log.debug("Press character '" + (char)key + "', as int:" + key);
        Control w = WidgetLookup.getInstance().getFocusControl();
        this.sync();
        Display.syncExec((Runnable)new Runnable((Widget)w){
            private final /* synthetic */ Widget val$w;
            {
                this.val$w = widget;
            }

            @Override
            public void run() {
                Display.getDisplay().post(Keyboard.this.keyEvent(key, 1, this.val$w));
            }
        });
    }

    protected void release(final int key) {
        log.debug("Release character '" + (char)key + "', as int:" + key);
        Control w = WidgetLookup.getInstance().getFocusControl();
        Display.syncExec((Runnable)new Runnable((Widget)w){
            private final /* synthetic */ Widget val$w;
            {
                this.val$w = widget;
            }

            @Override
            public void run() {
                Display.getDisplay().post(Keyboard.this.keyEvent(key, 2, this.val$w));
            }
        });
        this.sync();
    }

    private Event keyEvent(int key, int eventType, Widget w) {
        Event e = new Event();
        e.keyCode = key;
        e.character = (char)key;
        e.type = eventType;
        e.widget = w;
        return e;
    }

    private void sync() {
        this.delay(200);
        this.emptySync();
    }

    private void emptySync() {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private void delay(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

