/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessTerminalService;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.console.Activator;
import org.eclipse.remote.internal.console.ConsoleMessages;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;

public class TerminalConsoleConnector {
    private final IRemoteConnection connection;
    private IRemoteProcess remoteProcess;
    private PageConnector[] pageConnectors = new PageConnector[0];
    private int width;
    private int height;
    private TerminalState state = TerminalState.CLOSED;
    private OutThread outThread;

    public TerminalConsoleConnector(IRemoteConnection connection) {
        this.connection = connection;
    }

    public IRemoteConnection getConnection() {
        return this.connection;
    }

    public ITerminalConnector newPageConnector() {
        PageConnector connector = new PageConnector();
        ArrayList<PageConnector> list = new ArrayList<PageConnector>(Arrays.asList(this.pageConnectors));
        list.add(connector);
        this.pageConnectors = list.toArray(new PageConnector[list.size()]);
        return connector;
    }

    private void disposePageConnector(PageConnector connector) {
        ArrayList<PageConnector> list = new ArrayList<PageConnector>(Arrays.asList(this.pageConnectors));
        list.remove((Object)connector);
        this.pageConnectors = list.toArray(new PageConnector[list.size()]);
        if (list.isEmpty()) {
            this.disconnect();
        }
    }

    private synchronized void setState(TerminalState state) {
        this.state = state;
        PageConnector[] pageConnectorArray = this.pageConnectors;
        int n = this.pageConnectors.length;
        int n2 = 0;
        while (n2 < n) {
            PageConnector connector = pageConnectorArray[n2];
            ITerminalControl control = connector.control;
            if (control != null) {
                connector.control.setState(state);
            }
            ++n2;
        }
    }

    public synchronized void connect() {
        if (this.state != TerminalState.CLOSED) {
            return;
        }
        new Job(ConsoleMessages.MAKING_CONNECTION){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                TerminalConsoleConnector terminalConsoleConnector = TerminalConsoleConnector.this;
                synchronized (terminalConsoleConnector) {
                    IRemoteProcessTerminalService termService;
                    TerminalConsoleConnector.this.setState(TerminalState.CONNECTING);
                    if (TerminalConsoleConnector.this.remoteProcess == null || TerminalConsoleConnector.this.remoteProcess.isCompleted()) {
                        try {
                            if (!TerminalConsoleConnector.this.connection.isOpen()) {
                                try {
                                    TerminalConsoleConnector.this.connection.open(monitor);
                                }
                                catch (RemoteConnectionException e) {
                                    return e.getStatus();
                                }
                            }
                            TerminalConsoleConnector.this.remoteProcess = ((IRemoteCommandShellService)TerminalConsoleConnector.this.connection.getService(IRemoteCommandShellService.class)).getCommandShell(1);
                        }
                        catch (IOException e) {
                            TerminalConsoleConnector.this.disconnect();
                            return new Status(4, "org.eclipse.remote.console", e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    if (TerminalConsoleConnector.this.remoteProcess == null) {
                        TerminalConsoleConnector.this.disconnect();
                        return new Status(4, "org.eclipse.remote.console", ConsoleMessages.TerminalConsoleConnector_0);
                    }
                    if ((TerminalConsoleConnector.this.width > 0 || TerminalConsoleConnector.this.height > 0) && (termService = (IRemoteProcessTerminalService)TerminalConsoleConnector.this.remoteProcess.getService(IRemoteProcessTerminalService.class)) != null) {
                        termService.setTerminalSize(TerminalConsoleConnector.this.width, TerminalConsoleConnector.this.height, 8 * TerminalConsoleConnector.this.width, 8 * TerminalConsoleConnector.this.height);
                    }
                    if (TerminalConsoleConnector.this.outThread == null) {
                        TerminalConsoleConnector.this.outThread = new OutThread();
                        TerminalConsoleConnector.this.outThread.start();
                    }
                    TerminalConsoleConnector.this.setState(TerminalState.CONNECTED);
                    return Status.OK_STATUS;
                }
            }
        }.schedule();
    }

    public void disconnect() {
        if (this.remoteProcess != null && !this.remoteProcess.isCompleted()) {
            new Job(ConsoleMessages.DISCONNECTING){

                protected IStatus run(IProgressMonitor monitor) {
                    TerminalConsoleConnector.this.remoteProcess.destroy();
                    TerminalConsoleConnector.this.remoteProcess = null;
                    TerminalConsoleConnector.this.setState(TerminalState.CLOSED);
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            this.setState(TerminalState.CLOSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTerminalSize() {
        int minWidth = Integer.MAX_VALUE;
        int minHeight = Integer.MAX_VALUE;
        PageConnector[] pageConnectorArray = this.pageConnectors;
        int n = this.pageConnectors.length;
        int n2 = 0;
        while (n2 < n) {
            PageConnector connector = pageConnectorArray[n2];
            if (connector.myWidth < minWidth) {
                minWidth = connector.myWidth;
            }
            if (connector.myHeight < minHeight) {
                minHeight = connector.myHeight;
            }
            ++n2;
        }
        if ((minWidth -= 4) != this.width || minHeight != this.height) {
            this.width = minWidth;
            this.height = minHeight;
            TerminalConsoleConnector terminalConsoleConnector = this;
            synchronized (terminalConsoleConnector) {
                IRemoteProcessTerminalService termService;
                if (this.remoteProcess != null && (termService = (IRemoteProcessTerminalService)this.remoteProcess.getService(IRemoteProcessTerminalService.class)) != null) {
                    termService.setTerminalSize(this.width, this.height, 8 * this.width, 8 * this.height);
                }
            }
        }
    }

    private class OutThread
    extends Thread {
        public OutThread() {
            super("Terminal Output");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                byte[] buff = new byte[1024];
                if (TerminalConsoleConnector.this.remoteProcess != null) {
                    InputStream in = TerminalConsoleConnector.this.remoteProcess.getInputStream();
                    int n = in.read(buff);
                    while (n >= 0) {
                        PageConnector[] pageConnectorArray = TerminalConsoleConnector.this.pageConnectors;
                        int n2 = TerminalConsoleConnector.this.pageConnectors.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            PageConnector connector = pageConnectorArray[n3];
                            ITerminalControl control = connector.control;
                            if (control != null) {
                                control.getRemoteToTerminalOutputStream().write(buff, 0, n);
                            }
                            ++n3;
                        }
                        n = in.read(buff);
                    }
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
            TerminalConsoleConnector terminalConsoleConnector = TerminalConsoleConnector.this;
            synchronized (terminalConsoleConnector) {
                TerminalConsoleConnector.this.outThread = null;
                TerminalConsoleConnector.this.disconnect();
            }
        }
    }

    private class PageConnector
    extends PlatformObject
    implements ITerminalConnector {
        private int myWidth;
        private int myHeight;
        private ITerminalControl control;

        private PageConnector() {
        }

        public OutputStream getTerminalToRemoteStream() {
            return TerminalConsoleConnector.this.remoteProcess != null ? TerminalConsoleConnector.this.remoteProcess.getOutputStream() : null;
        }

        public void connect(ITerminalControl control) {
            this.control = control;
            control.setVT100LineWrapping(true);
            TerminalConsoleConnector.this.connect();
            if (!control.getState().equals(TerminalConsoleConnector.this.state)) {
                control.setState(TerminalConsoleConnector.this.state);
            }
        }

        public synchronized void disconnect() {
            TerminalConsoleConnector.this.disposePageConnector(this);
        }

        public void setTerminalSize(int newWidth, int newHeight) {
            if (newWidth != this.myWidth || newHeight != this.myHeight) {
                this.myWidth = newWidth;
                this.myHeight = newHeight;
                TerminalConsoleConnector.this.setTerminalSize();
            }
        }

        public String getId() {
            return null;
        }

        public String getName() {
            return null;
        }

        public boolean isHidden() {
            return true;
        }

        public boolean isInitialized() {
            return true;
        }

        public String getInitializationErrorMessage() {
            return null;
        }

        public boolean isLocalEcho() {
            return false;
        }

        public void setDefaultSettings() {
        }

        public String getSettingsSummary() {
            return null;
        }

        public void load(ISettingsStore arg0) {
        }

        public void save(ISettingsStore arg0) {
        }
    }
}

