/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import com.google.common.collect.Iterables;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramListEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.CommonEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNodeListItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.NoCopyDragEditPartsTrackerEx;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.ViewNodeContainerFigureDesc;

public abstract class AbstractDiagramListEditPart
extends AbstractDiagramElementContainerEditPart
implements IDiagramListEditPart {
    public AbstractDiagramListEditPart(View view) {
        super(view);
    }

    @Override
    public Class<?> getMetamodelType() {
        return DNodeList.class;
    }

    public Command getCommand(Request request) {
        UnexecutableCommand result = null;
        RequestQuery requestQuery = new RequestQuery(request);
        if (requestQuery.isNoteCreationRequest() || requestQuery.isTextCreationRequest() || requestQuery.isNoteDropRequest() || requestQuery.isTextDropRequest()) {
            result = UnexecutableCommand.INSTANCE;
        } else if ("paste".equals(request.getType())) {
            for (ListCompartmentEditPart lcep : Iterables.filter((Iterable)this.children, ListCompartmentEditPart.class)) {
                result = lcep.getCommand(request);
            }
        } else {
            Command cmd = super.getCommand(request);
            return CommonEditPartOperation.handleAutoPinOnInteractiveMove(this, request, cmd);
        }
        if (result == null) {
            result = super.getCommand(request);
        }
        return CommonEditPartOperation.handleAutoPinOnInteractiveMove(this, request, (Command)result);
    }

    public DragTracker getDragTracker(Request request) {
        if (this.shouldUseRegionsContainerDragTracker(request)) {
            return this.getParent().getDragTracker(request);
        }
        return new NoCopyDragEditPartsTrackerEx((EditPart)this);
    }

    public ViewNodeContainerFigureDesc getPrimaryFigure() {
        return this.getPrimaryShape();
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DNodeListItemSemanticEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    protected void performDirectEditRequest(Request request) {
        if (request instanceof DirectEditRequest) {
            Request req = new Request();
            req.setType((Object)"direct edit");
            super.performDirectEditRequest(req);
        } else if ("direct edit".equals(request.getType())) {
            super.performDirectEditRequest(request);
        }
    }
}

