/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.views.providers.layers;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.layers.LayersActivationAdapter;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.layers.LayersEventsListener;

public class LayersContentProvider
implements IStructuredContentProvider {
    private final LayersActivationAdapter layerActivationAdapter;
    private final LayersEventsListener eventListener;
    private IDiagramWorkbenchPart diagramPart;
    private Session session;

    public LayersContentProvider(LayersActivationAdapter adapter, LayersEventsListener listener, IDiagramWorkbenchPart part) {
        this.layerActivationAdapter = adapter;
        this.eventListener = listener;
        this.diagramPart = part;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof DDiagram) {
            DiagramDescription diagramDesc = ((DDiagram)inputElement).getDescription();
            EList allLayers = new DiagramComponentizationManager().getAllLayers(this.session.getSelectedViewpoints(false), diagramDesc);
            ArrayList<Layer> layers = new ArrayList<Layer>();
            for (Layer layer : allLayers) {
                if (layer == null || layer == diagramDesc.getDefaultLayer()) continue;
                layers.add(layer);
            }
            return layers.toArray();
        }
        return Collections.EMPTY_LIST.toArray();
    }

    public void dispose() {
        if (this.diagramPart != null) {
            DiagramEditPart diaEditPart = this.diagramPart.getDiagramEditPart();
            Object obj = diaEditPart.getModel();
            if (obj instanceof View) {
                this.removeListenerFrom((View)obj);
            }
            this.diagramPart = null;
        }
        if (this.session != null) {
            this.session = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        DiagramEditPart diaEditPart;
        Object obj;
        this.layerActivationAdapter.setViewer(viewer);
        this.eventListener.setViewer(viewer);
        if (oldInput != null && (obj = (diaEditPart = this.diagramPart.getDiagramEditPart()).getModel()) instanceof View) {
            this.removeListenerFrom((View)obj);
        }
        if (newInput != null && (obj = (diaEditPart = this.diagramPart.getDiagramEditPart()).getModel()) instanceof View) {
            this.addListenerTo((View)obj);
        }
    }

    private void removeListenerFrom(View oldInput) {
        EObject element = oldInput.getElement();
        if (element instanceof DDiagram) {
            DDiagram diagram = (DDiagram)element;
            diagram.eAdapters().remove((Object)this.layerActivationAdapter);
            this.removeListenerToSession();
        }
    }

    private void addListenerTo(View newInput) {
        EObject element = newInput.getElement();
        if (element instanceof DDiagram) {
            DDiagram diagram = (DDiagram)element;
            diagram.eAdapters().add((Object)this.layerActivationAdapter);
            if (diagram instanceof DSemanticDiagram) {
                this.session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)diagram).getTarget());
                this.addListenerToSession();
            }
        }
    }

    private void addListenerToSession() {
        if (this.session != null) {
            this.session.addListener((SessionListener)this.eventListener);
        }
    }

    private void removeListenerToSession() {
        if (this.session != null) {
            this.session.removeListener((SessionListener)this.eventListener);
        }
    }
}

