/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.model;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.addon.viewers.runtime.model.EventFilterBuilder;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerFilterDefinition;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.notation.Containment;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;
import org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage;
import org.eclipse.viatra.addon.viewers.runtime.specifications.ContainmentQuerySpecificationDescriptor;
import org.eclipse.viatra.query.runtime.api.GenericPatternMatch;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.views.core.ViewModelManager;
import org.eclipse.viatra.transformation.views.core.ViewModelRule;
import org.eclipse.viatra.transformation.views.core.util.ViewModelUtil;
import org.eclipse.viatra.transformation.views.traceability.generic.AbstractQuerySpecificationDescriptor;

public class ContainmentRule
extends ViewModelRule {
    private final ContainmentQuerySpecificationDescriptor descriptor;
    private final ViewerState state;
    private ViewerDataFilter filter;

    public ContainmentRule(ContainmentQuerySpecificationDescriptor descriptor, ViewerState state, ViewerDataFilter filter) {
        super((AbstractQuerySpecificationDescriptor)descriptor);
        this.descriptor = descriptor;
        this.state = state;
        this.filter = filter;
    }

    public static ContainmentRule initiate(IQuerySpecification<?> specification, PAnnotation annotation, ViewerState state, ViewerDataFilter filter) {
        ContainmentQuerySpecificationDescriptor descriptor = new ContainmentQuerySpecificationDescriptor(specification, annotation);
        return new ContainmentRule(descriptor, state, filter);
    }

    private EventFilter<IPatternMatch> createFilter(ViewerDataFilter baseFilter) {
        if (!baseFilter.isFiltered(this.getBaseSpecification())) {
            return null;
        }
        ViewerFilterDefinition filterDefinition = baseFilter.getFilter(this.getBaseSpecification());
        return EventFilterBuilder.createEventFilter(filterDefinition, this.getReferencedSpecification());
    }

    public Job<GenericPatternMatch> getAppearedJob() {
        return Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, match -> {
            String sourceParam = "trace<" + this.descriptor.getContainer() + ">";
            String targetParam = "trace<" + this.descriptor.getItem() + ">";
            Item source = (Item)match.get(sourceParam);
            Item target = (Item)match.get(targetParam);
            EObject eObject = ViewModelUtil.create((EClass)NotationPackage.eINSTANCE.getContainment(), (EObject)this.state.getNotationModel(), (EReference)NotationPackage.eINSTANCE.getNotationModel_Containments());
            ViewModelUtil.trace((ViewModelManager)this.state.getManager(), (String)this.getReferencedSpecification().getFullyQualifiedName(), Collections.singleton(eObject), (Object[])new Object[]{match.get(this.descriptor.getContainer()), match.get(this.descriptor.getItem())});
            Containment edge = (Containment)eObject;
            edge.setSource(source);
            edge.setTarget(target);
            this.state.containmentAppeared(edge);
            this.logger.debug((Object)("Containment appeared: <" + this.getTracedSpecification().getFullyQualifiedName() + ">" + edge.toString()));
        }));
    }

    public Job<GenericPatternMatch> getDisappearedJob() {
        return Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, match -> {
            if (ViewModelUtil.target((GenericPatternMatch)match) instanceof Containment) {
                Collection edges = ViewModelUtil.delete((GenericPatternMatch)match);
                for (EObject edge : edges) {
                    EcoreUtil.delete((EObject)edge);
                    this.state.containmentDisappeared((Containment)edge);
                    this.logger.debug((Object)("Containment disappeared: <" + this.getTracedSpecification().getFullyQualifiedName() + ">" + edge.toString()));
                }
            }
        }));
    }

    protected EventFilter<IPatternMatch> prepareFilter() {
        return this.createFilter(this.filter);
    }
}

