/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal;

import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.UpdatableScript;
import org.eclipse.wst.jsdt.chromium.internal.liveeditprotocol.LiveEditResult;

public abstract class ScriptBase<ID>
implements Script {
    private final Descriptor<ID> descriptor;
    private volatile String source = null;
    private volatile boolean isCollected = false;

    public ScriptBase(Descriptor<ID> descriptor) {
        this.descriptor = descriptor;
        this.source = null;
    }

    @Override
    public Script.Type getType() {
        return this.descriptor.type;
    }

    @Override
    public String getName() {
        return this.descriptor.name;
    }

    @Override
    public int getStartLine() {
        return this.descriptor.lineOffset;
    }

    @Override
    public int getStartColumn() {
        return this.descriptor.columnOffset;
    }

    @Override
    public int getEndLine() {
        return this.descriptor.endLine;
    }

    public ID getId() {
        return this.descriptor.id;
    }

    @Override
    public boolean isCollected() {
        return this.isCollected;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean hasSource() {
        return this.source != null;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setCollected() {
        this.isCollected = true;
    }

    public int hashCode() {
        return this.descriptor.hashCode() * 257 + (this.hasSource() ? this.source.hashCode() * 4097 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScriptBase)) {
            return false;
        }
        ScriptBase that = (ScriptBase)obj;
        return this.descriptor.equals(that.descriptor) && ScriptBase.eq(this.source, that.source);
    }

    private static boolean eq(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Script (").append(this.hasSource() ? "has" : "no").append(" source): name=").append(this.getName()).append(", lineRange=[").append(this.getStartLine()).append(';').append(this.getEndLine()).append("]]");
        return sb.toString();
    }

    public static class Descriptor<ID> {
        public final Script.Type type;
        public final String name;
        public final int lineOffset;
        public final int columnOffset;
        public final int endLine;
        public final ID id;

        public Descriptor(Script.Type type, ID id, String name, int lineOffset, int columnOffset, int lineCount) {
            this.type = type;
            this.id = id;
            this.name = name;
            this.lineOffset = lineOffset;
            this.columnOffset = columnOffset;
            this.endLine = lineOffset + lineCount - 1;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : this.id.hashCode() * 257 + this.lineOffset * 4097 + this.columnOffset * 65537 + this.endLine * 0x100001;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Descriptor)) {
                return false;
            }
            Descriptor that = (Descriptor)obj;
            return this.id.equals(that.id) && this.lineOffset == that.lineOffset && this.columnOffset == that.columnOffset && this.endLine == that.endLine;
        }
    }

    protected static class UpdateResultParser {
        private static final Wrapper<LiveEditResult.OldTreeNode, UpdatableScript.OldFunctionNode> OLD_WRAPPER = new Wrapper<LiveEditResult.OldTreeNode, UpdatableScript.OldFunctionNode>(){

            @Override
            UpdatableScript.OldFunctionNode wrap(LiveEditResult.OldTreeNode original) {
                return new OldFunctionNodeImpl(original);
            }
        };
        private static final Wrapper<LiveEditResult.NewTreeNode, UpdatableScript.NewFunctionNode> NEW_WRAPPER = new Wrapper<LiveEditResult.NewTreeNode, UpdatableScript.NewFunctionNode>(){

            @Override
            UpdatableScript.NewFunctionNode wrap(LiveEditResult.NewTreeNode original) {
                return new NewFunctionNodeImpl(original);
            }
        };
        private static final Map<String, UpdatableScript.ChangeStatus> statusCodes = new HashMap<String, UpdatableScript.ChangeStatus>(5);

        static {
            statusCodes.put("unchanged", UpdatableScript.ChangeStatus.UNCHANGED);
            statusCodes.put("source changed", UpdatableScript.ChangeStatus.NESTED_CHANGED);
            statusCodes.put("changed", UpdatableScript.ChangeStatus.CODE_PATCHED);
            statusCodes.put("damaged", UpdatableScript.ChangeStatus.DAMAGED);
        }

        protected UpdateResultParser() {
        }

        public static UpdatableScript.ChangeDescription wrapChangeDescription(final LiveEditResult previewDescription) {
            if (previewDescription == null) {
                return null;
            }
            return new UpdatableScript.ChangeDescription(){

                @Override
                public UpdatableScript.OldFunctionNode getChangeTree() {
                    return (UpdatableScript.OldFunctionNode)OLD_WRAPPER.wrap(previewDescription.change_tree());
                }

                @Override
                public String getCreatedScriptName() {
                    return previewDescription.created_script_name();
                }

                @Override
                public boolean isStackModified() {
                    return previewDescription.stack_modified();
                }

                @Override
                public UpdatableScript.TextualDiff getTextualDiff() {
                    final LiveEditResult.TextualDiff protocolTextualData = previewDescription.textual_diff();
                    if (protocolTextualData == null) {
                        return null;
                    }
                    return new UpdatableScript.TextualDiff(){

                        @Override
                        public List<Long> getChunks() {
                            return protocolTextualData.chunks();
                        }
                    };
                }
            };
        }

        private static UpdatableScript.FunctionPositions wrapPositions(final LiveEditResult.Positions rawPositions) {
            return new UpdatableScript.FunctionPositions(){

                @Override
                public long getStart() {
                    return rawPositions.start_position();
                }

                @Override
                public long getEnd() {
                    return rawPositions.end_position();
                }
            };
        }

        private static <FROM, TO> List<TO> wrapList(final List<? extends FROM> originalList, final Wrapper<FROM, TO> wrapper) {
            return new AbstractList<TO>(){

                @Override
                public TO get(int index) {
                    return wrapper.wrap(originalList.get(index));
                }

                @Override
                public int size() {
                    return originalList.size();
                }
            };
        }

        private static class NewFunctionNodeImpl
        implements UpdatableScript.NewFunctionNode {
            private final LiveEditResult.NewTreeNode treeNode;
            private final UpdatableScript.FunctionPositions positions;

            NewFunctionNodeImpl(LiveEditResult.NewTreeNode treeNode) {
                this.treeNode = treeNode;
                this.positions = UpdateResultParser.wrapPositions(treeNode.positions());
            }

            @Override
            public String getName() {
                return this.treeNode.name();
            }

            @Override
            public UpdatableScript.FunctionPositions getPositions() {
                return this.positions;
            }

            @Override
            public List<? extends UpdatableScript.NewFunctionNode> children() {
                return UpdateResultParser.wrapList(this.treeNode.children(), NEW_WRAPPER);
            }

            @Override
            public UpdatableScript.OldFunctionNode asOldFunction() {
                return null;
            }
        }

        private static class OldFunctionNodeImpl
        implements UpdatableScript.OldFunctionNode {
            private final LiveEditResult.OldTreeNode treeNode;
            private final UpdatableScript.FunctionPositions positions;
            private final UpdatableScript.FunctionPositions newPositions;

            OldFunctionNodeImpl(LiveEditResult.OldTreeNode treeNode) {
                this.treeNode = treeNode;
                this.positions = UpdateResultParser.wrapPositions(treeNode.positions());
                this.newPositions = treeNode.new_positions() == null ? null : UpdateResultParser.wrapPositions(treeNode.new_positions());
            }

            @Override
            public String getName() {
                return this.treeNode.name();
            }

            @Override
            public UpdatableScript.ChangeStatus getStatus() {
                return (UpdatableScript.ChangeStatus)((Object)statusCodes.get(this.treeNode.status()));
            }

            @Override
            public String getStatusExplanation() {
                return this.treeNode.status_explanation();
            }

            @Override
            public List<? extends UpdatableScript.OldFunctionNode> children() {
                return UpdateResultParser.wrapList(this.treeNode.children(), OLD_WRAPPER);
            }

            @Override
            public List<? extends UpdatableScript.NewFunctionNode> newChildren() {
                return UpdateResultParser.wrapList(this.treeNode.new_children(), NEW_WRAPPER);
            }

            @Override
            public UpdatableScript.FunctionPositions getPositions() {
                return this.positions;
            }

            @Override
            public UpdatableScript.FunctionPositions getNewPositions() {
                return this.newPositions;
            }

            @Override
            public UpdatableScript.OldFunctionNode asOldFunction() {
                return this;
            }
        }

        private static abstract class Wrapper<FROM, TO> {
            private Wrapper() {
            }

            abstract TO wrap(FROM var1);
        }
    }
}

