/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.jsdoc.msdn;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.wst.jsdt.jsdoc.ElementInfo;
import org.eclipse.wst.jsdt.jsdoc.Util;

public class MsdnElement
extends ElementInfo {
    String typeName;
    String[][] parsedParams = null;

    public String getJsTypeName() {
        if (this.typeName != null) {
            return this.typeName;
        }
        switch (this.getType()) {
            case 3: {
                String pageText = this.getPageText();
                String p1 = "<p class=\"clsRef\">Possible Values</p>";
                String end = "</blockquote>";
                int i1 = pageText.indexOf(p1);
                if (i1 < 0) {
                    return null;
                }
                int indexOfEnd = pageText.indexOf(end, i1 += p1.length());
                String p2 = "<b>";
                String p3 = "</b>";
                int i2 = pageText.indexOf(p2, i1) + p2.length();
                int i3 = pageText.indexOf(p3, i2);
                if (i2 > indexOfEnd || i3 > indexOfEnd) {
                    return null;
                }
                this.typeName = pageText.substring(i2, i3);
                break;
            }
            case 5: {
                this.typeName = "Array";
                break;
            }
            case 2: {
                String pageText = this.getPageText();
                String p1 = "<p class=\"clsRef\">Return Value</p>";
                String end = "</blockquote>";
                int i1 = pageText.indexOf(p1);
                if (i1 < 0) {
                    return null;
                }
                int indexOfEnd = pageText.indexOf(end, i1 += p1.length());
                String p2 = "<b>";
                String p3 = "</b>";
                int i2 = pageText.indexOf(p2, i1);
                if (i2 < 0) {
                    return null;
                }
                int i3 = pageText.indexOf(p3, i2 += p2.length());
                if (i2 > indexOfEnd || i3 > indexOfEnd) {
                    return null;
                }
                this.typeName = pageText.substring(i2, i3);
            }
        }
        return this.typeName;
    }

    @Override
    public String getJsDoc(String parentName) {
        StringBuffer jsDoc = new StringBuffer();
        jsDoc.append("/**" + Util.NEW_LINE);
        String dec = "  * ";
        String endDec = Util.NEW_LINE;
        switch (this.getType()) {
            case 1: 
            case 4: 
            case 5: {
                if (parentName != null) {
                    jsDoc.append(String.valueOf(dec) + "Property " + this.getName() + endDec);
                    jsDoc.append(String.valueOf(dec) + "@type " + this.getName() + endDec);
                    jsDoc.append(String.valueOf(dec) + "@return " + this.getName() + endDec);
                    jsDoc.append(String.valueOf(dec) + "@class " + parentName + endDec);
                    jsDoc.append(String.valueOf(dec) + "@since " + this.getSince() + endDec);
                    break;
                }
                jsDoc.append(String.valueOf(dec) + "Object " + this.getName() + "()" + endDec);
                jsDoc.append(String.valueOf(dec) + "@type " + this.getName() + endDec);
                jsDoc.append(String.valueOf(dec) + "@super " + this.getSuperType() + endDec);
                jsDoc.append(String.valueOf(dec) + "@class " + this.getName() + endDec);
                jsDoc.append(String.valueOf(dec) + "@since " + this.getSince() + endDec);
                break;
            }
            case 2: {
                String superType = this.getSuperType();
                jsDoc.append(String.valueOf(dec) + "function " + this.getName() + "(" + this.getParamString() + ")" + endDec);
                String[][] params = this.getParamaters();
                int i = 0;
                while (i < params.length) {
                    jsDoc.append(String.valueOf(dec) + "@param " + params[i][0] + " " + params[i][1] + endDec);
                    ++i;
                }
                if (superType != null) {
                    jsDoc.append(String.valueOf(dec) + "@type " + superType + endDec);
                }
                if (superType != null) {
                    jsDoc.append(String.valueOf(dec) + "@return " + superType + endDec);
                }
                jsDoc.append(String.valueOf(dec) + "@class " + parentName + endDec);
                jsDoc.append(String.valueOf(dec) + "@since " + this.getSince() + endDec);
                break;
            }
            case 3: {
                jsDoc.append(String.valueOf(dec) + "Property " + this.getName() + endDec);
                jsDoc.append(String.valueOf(dec) + "@type " + this.getSuperType() + endDec);
                jsDoc.append(String.valueOf(dec) + "@return " + this.getSuperType() + endDec);
                jsDoc.append(String.valueOf(dec) + "@class " + parentName + endDec);
                jsDoc.append(String.valueOf(dec) + "@since " + this.getSince() + endDec);
            }
        }
        jsDoc.append(String.valueOf(dec) + "@link " + this.getUrl() + endDec);
        jsDoc.append("*/" + Util.NEW_LINE);
        return jsDoc.toString();
    }

    public String[][] getParamaters() {
        if (this.parsedParams != null) {
            return this.parsedParams;
        }
        String[][] noParams = new String[][]{};
        String pageText = this.getPageText();
        String p1 = "<p class=\"clsRef\">Parameters</p>";
        String end = "</blockquote>";
        int i1 = pageText.indexOf(p1);
        if (i1 < 0) {
            this.parsedParams = noParams;
            return this.parsedParams;
        }
        int indexOfEnd = pageText.indexOf(end, i1 += p1.length());
        int paramStart = i1;
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        String paramI = "<i>";
        String paramIend = "</i>";
        String p2 = "<b>";
        String p3 = "</b>";
        String paramTypeEendFallback1 = "<td>";
        String paramTypeEendFallback1End = "</td>";
        while (paramStart < indexOfEnd) {
            if ((paramStart = pageText.indexOf(paramI, paramStart)) < 0 || paramStart > indexOfEnd) break;
            int paramEnd = pageText.indexOf(paramIend, paramStart += paramI.length());
            String paramName = pageText.substring(paramStart, paramEnd);
            int typeStart = pageText.indexOf(p2, paramEnd);
            int typeEnd = -1;
            if (typeStart > 0) {
                typeEnd = pageText.indexOf(p3, typeStart += p2.length());
            } else {
                typeStart = pageText.indexOf(paramTypeEendFallback1, paramEnd + paramI.length()) + paramTypeEendFallback1.length();
                typeEnd = pageText.indexOf(paramTypeEendFallback1End, typeStart);
            }
            String typeName = null;
            try {
                typeName = pageText.substring(typeStart, typeEnd);
            }
            catch (RuntimeException runtimeException) {
                break;
            }
            paramStart = pageText.indexOf(paramTypeEendFallback1End, typeStart);
            if (this.contains(typeName, "integer")) {
                typeName = "Number";
            }
            params.add(paramName);
            types.add(typeName);
        }
        if (params.size() == 0) {
            return noParams;
        }
        this.parsedParams = new String[params.size()][2];
        int i = 0;
        while (i < params.size()) {
            this.parsedParams[i][0] = (String)params.get(i);
            this.parsedParams[i][1] = (String)types.get(i);
            ++i;
        }
        return this.parsedParams;
    }

    public String getSuperType() {
        if (this.getType() == 5) {
            return "Array";
        }
        if (this.getType() == 4) {
            return "Object";
        }
        if (this.getType() == 3) {
            String jsTypeName = this.getJsTypeName();
            if (jsTypeName == null) {
                return "Object";
            }
            if (this.contains(jsTypeName = jsTypeName.trim(), "variant")) {
                return "Object";
            }
            if (this.contains(jsTypeName, "integer")) {
                return "Number";
            }
            return jsTypeName;
        }
        if (this.getType() == 1) {
            return "Object";
        }
        if (this.getType() == 2) {
            String jsTypeName = this.getJsTypeName();
            if (jsTypeName == null) {
                return null;
            }
            if (this.contains(jsTypeName = jsTypeName.trim(), "variant")) {
                return "Object";
            }
            if (this.contains(jsTypeName, "integer")) {
                return "Number";
            }
            return jsTypeName;
        }
        return "Object";
    }

    public String getSince() {
        return "JScript 5.6";
    }

    @Override
    public String getJsStructure() {
        StringBuffer structure = new StringBuffer();
        structure.append(String.valueOf(this.getJsDoc(null)) + Util.NEW_LINE);
        ElementInfo[] children = this.getChildren();
        String myName = this.getName();
        structure.append("function " + myName + "(){};" + Util.NEW_LINE);
        structure.append(String.valueOf(myName) + ".prototype= new " + this.getSuperType() + "();" + Util.NEW_LINE);
        int i = 0;
        while (i < children.length) {
            structure.append(children[i].getJsStructure(myName));
            ++i;
        }
        return structure.toString();
    }

    public String getParamString() {
        String[][] params = this.getParamaters();
        StringBuilder paramString = new StringBuilder();
        int i = 0;
        while (i < params.length) {
            paramString.append(params[i][0]);
            if (i + 1 < params.length) {
                paramString.append(',');
            }
            ++i;
        }
        return paramString.toString();
    }

    @Override
    public String getJsStructure(String parent) {
        StringBuffer structure = new StringBuffer();
        switch (this.getType()) {
            case 3: {
                structure.append(String.valueOf(this.getJsDoc(parent)) + Util.NEW_LINE);
                if (!this.isStatic()) {
                    structure.append(String.valueOf(parent) + ".prototype." + this.getName() + "=" + MsdnElement.getInitializer(this.getSuperType()) + ";" + Util.NEW_LINE);
                    break;
                }
                structure.append(String.valueOf(parent) + "." + this.getName() + "=" + MsdnElement.getInitializer(this.getSuperType()) + ";" + Util.NEW_LINE);
                break;
            }
            case 2: {
                structure.append(String.valueOf(this.getJsDoc(parent)) + Util.NEW_LINE);
                if (!this.isStatic()) {
                    structure.append(String.valueOf(parent) + ".prototype." + this.getName() + "=function(" + this.getParamString() + "){};" + Util.NEW_LINE);
                    break;
                }
                structure.append(String.valueOf(parent) + this.getName() + "=function(" + this.getParamString() + "){};" + Util.NEW_LINE);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                structure.append(String.valueOf(this.getJsDoc(parent)) + Util.NEW_LINE);
                if (!this.isStatic()) {
                    structure.append(String.valueOf(parent) + ".prototype." + this.getName() + "= new " + this.getName() + "();" + Util.NEW_LINE);
                    break;
                }
                structure.append(String.valueOf(parent) + "." + this.getName() + "= new " + this.getName() + "();" + Util.NEW_LINE);
            }
        }
        return structure.toString();
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    public MsdnElement(String baseUrl, ElementInfo parent) {
        super(baseUrl, parent);
    }

    public MsdnElement(String baseUrl) {
        super(baseUrl, null);
    }

    private ElementInfo getMsdnElement(String baseUrl) {
        ElementInfo temp = MsdnElement.findChild(baseUrl);
        if (temp != null) {
            return temp;
        }
        MsdnElement element = new MsdnElement(baseUrl, this);
        nodes.add(element);
        return element;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        String pageText = this.getPageText();
        if (pageText == null) {
            return null;
        }
        String p1 = "<div class=\"stat\"><strong>&nbsp;";
        int i1 = pageText.indexOf(p1) + p1.length();
        String p2 = " ";
        int i2 = pageText.indexOf(p2, i1);
        this.name = pageText.substring(i1, i2);
        return this.name;
    }

    public boolean contains(String s1, String searchFor) {
        String temp2;
        String temp = s1.toLowerCase();
        return temp.indexOf(temp2 = searchFor.toLowerCase()) > -1;
    }

    @Override
    public int getType() {
        int i2;
        int i1;
        String pageText;
        String typeName = null;
        if (this.type > -1) {
            return this.type;
        }
        try {
            pageText = this.getPageText();
            String p1 = "<div class=\"stat\"><strong>&nbsp;" + this.getName();
            i1 = pageText.indexOf(p1) + p1.length();
            String p2 = "</strong>";
            i2 = pageText.indexOf(p2, i1);
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
        try {
            typeName = pageText.substring(i1, i2).trim();
        }
        catch (Exception exception) {
            return -1;
        }
        if (this.contains(typeName, "object") || this.contains(typeName, "Collection")) {
            this.type = 1;
        }
        if (this.contains(typeName, "Property")) {
            this.type = 3;
        }
        if (this.contains(typeName, "Method")) {
            this.type = 2;
        }
        if (this.contains(typeName, "Event")) {
            this.type = 4;
        }
        if (this.contains(typeName, "Collection")) {
            this.type = 5;
        }
        return this.type;
    }

    @Override
    public String getTypeName() {
        switch (this.getType()) {
            case 4: {
                return "Event";
            }
            case 5: {
                return "Collection";
            }
        }
        return super.getTypeName();
    }

    @Override
    public ElementInfo[] getChildren() {
        String name;
        int i;
        if (this.children != null && this.children.length != 0) {
            return this.children;
        }
        ArrayList<ElementInfo> children = new ArrayList<ElementInfo>();
        ElementInfo[] elemnts = this.getProperties();
        children.addAll(Arrays.asList(elemnts));
        if (DEBUG) {
            System.out.println("Found the following in getProperties()");
            i = 0;
            while (i < elemnts.length) {
                name = elemnts[i].getName();
                System.out.println("\t" + name);
                ++i;
            }
        }
        elemnts = this.getMethods();
        children.addAll(Arrays.asList(elemnts));
        if (DEBUG) {
            System.out.println("Found the following in getMethods()");
            i = 0;
            while (i < elemnts.length) {
                name = elemnts[i].getName();
                System.out.println("\t" + name);
                ++i;
            }
        }
        elemnts = this.getObjects();
        children.addAll(Arrays.asList(elemnts));
        if (DEBUG) {
            System.out.println("Found the following in getObjects()");
            i = 0;
            while (i < elemnts.length) {
                name = elemnts[i].getName();
                System.out.println("\t" + name);
                ++i;
            }
        }
        elemnts = this.getEvents();
        children.addAll(Arrays.asList(elemnts));
        if (DEBUG) {
            System.out.println("Found the following in getEvents()");
            i = 0;
            while (i < elemnts.length) {
                name = elemnts[i].getName();
                System.out.println("\t" + name);
                ++i;
            }
        }
        elemnts = this.getCollections();
        children.addAll(Arrays.asList(elemnts));
        if (DEBUG) {
            System.out.println("Found the following in getCollections()");
            i = 0;
            while (i < elemnts.length) {
                name = elemnts[i].getName();
                System.out.println("\t" + name);
                ++i;
            }
        }
        this.children = children.toArray(new ElementInfo[children.size()]);
        return this.children;
    }

    @Override
    public boolean hasChildren() {
        ElementInfo[] children = this.getChildren();
        return children != null && children.length > 0;
    }

    public ElementInfo[] getProperties() {
        ArrayList<ElementInfo> foundProps = new ArrayList<ElementInfo>();
        String baseUrl = this.getBaseUrl();
        String pageText = this.getPageText();
        String p1 = "<tr><th>Property</th><th>Description</th></tr>";
        String end = "</table>";
        int i1 = pageText.indexOf(p1);
        if (i1 < 0) {
            p1 = "<th>Attribute</th><th>Property</th><th>Description</th>";
            i1 = pageText.indexOf(p1);
        }
        if (i1 < 0) {
            return new ElementInfo[0];
        }
        int indexOfEnd = pageText.indexOf(end, i1 += p1.length());
        String p2 = "href=\"";
        int i2 = i1;
        String p3 = "\"";
        while (i2 < indexOfEnd) {
            i2 = pageText.indexOf(p2, i2) + p2.length();
            int i3 = pageText.indexOf(p3, i2);
            String urlName = pageText.substring(i2, i3);
            ElementInfo info = this.getMsdnElement(String.valueOf(baseUrl) + "/" + urlName);
            if (foundProps.contains(info)) continue;
            foundProps.add(info);
        }
        return foundProps.toArray(new ElementInfo[foundProps.size()]);
    }

    public ElementInfo[] getMethods() {
        ArrayList<ElementInfo> foundProps = new ArrayList<ElementInfo>();
        String baseUrl = this.getBaseUrl();
        String pageText = this.getPageText();
        String p1 = "<tr><th>Method</th><th>Description</th></tr>";
        String end = "</table>";
        int i1 = pageText.indexOf(p1);
        if (i1 < 0) {
            return new ElementInfo[0];
        }
        int indexOfEnd = pageText.indexOf(end, i1 += p1.length());
        String p2 = "href=\"";
        int i2 = i1;
        String p3 = "\"";
        while (i2 < indexOfEnd) {
            if ((i2 = pageText.indexOf(p2, i2) + p2.length()) > indexOfEnd) break;
            int i3 = pageText.indexOf(p3, i2);
            String urlName = pageText.substring(i2, i3);
            ElementInfo info = this.getMsdnElement(String.valueOf(baseUrl) + "/" + urlName);
            if (foundProps.contains(info)) continue;
            foundProps.add(info);
        }
        return foundProps.toArray(new ElementInfo[foundProps.size()]);
    }

    public ElementInfo[] getObjects() {
        ArrayList<ElementInfo> foundProps = new ArrayList<ElementInfo>();
        String baseUrl = this.getBaseUrl();
        String pageText = this.getPageText();
        String p1 = "<tr><th>Object</th><th>Description</th></tr>";
        String end = "</table>";
        int i1 = pageText.indexOf(p1);
        if (i1 < 0) {
            p1 = "<tr><th>Element</th><th>Object</th><th>Description</th>";
            i1 = pageText.indexOf(p1);
        }
        if (i1 < 0) {
            return new ElementInfo[0];
        }
        int indexOfEnd = pageText.indexOf(end, i1 += p1.length());
        String p2 = "href=\"";
        int i2 = i1;
        String p3 = "\"";
        while (i2 < indexOfEnd) {
            if ((i2 = pageText.indexOf(p2, i2) + p2.length()) > indexOfEnd) break;
            int i3 = pageText.indexOf(p3, i2);
            String urlName = pageText.substring(i2, i3);
            ElementInfo info = this.getMsdnElement(String.valueOf(baseUrl) + "/" + urlName);
            if (foundProps.contains(info)) continue;
            foundProps.add(info);
        }
        return foundProps.toArray(new ElementInfo[foundProps.size()]);
    }

    public ElementInfo[] getEvents() {
        ArrayList<ElementInfo> foundProps = new ArrayList<ElementInfo>();
        String baseUrl = this.getBaseUrl();
        String pageText = this.getPageText();
        String p1 = "<tr><th>Event</th><th>Description</th></tr>";
        String end = "</table>";
        int i1 = pageText.indexOf(p1);
        if (i1 < 0) {
            return new ElementInfo[0];
        }
        int indexOfEnd = pageText.indexOf(end, i1 += p1.length());
        String p2 = "href=\"";
        int i2 = i1;
        String p3 = "\"";
        while (i2 < indexOfEnd) {
            if ((i2 = pageText.indexOf(p2, i2) + p2.length()) > indexOfEnd) break;
            int i3 = pageText.indexOf(p3, i2);
            String urlName = pageText.substring(i2, i3);
            ElementInfo info = this.getMsdnElement(String.valueOf(baseUrl) + "/" + urlName);
            if (foundProps.contains(info)) continue;
            foundProps.add(info);
        }
        return foundProps.toArray(new ElementInfo[foundProps.size()]);
    }

    public ElementInfo[] getCollections() {
        ArrayList<ElementInfo> foundProps = new ArrayList<ElementInfo>();
        String baseUrl = this.getBaseUrl();
        String pageText = this.getPageText();
        String p1 = "<tr><th>Collection</th><th>Description</th></tr>";
        String end = "</table>";
        int i1 = pageText.indexOf(p1);
        if (i1 < 0) {
            return new ElementInfo[0];
        }
        int indexOfEnd = pageText.indexOf(end, i1 += p1.length());
        String p2 = "href=\"";
        int i2 = i1;
        String p3 = "\"";
        while (i2 < indexOfEnd) {
            if ((i2 = pageText.indexOf(p2, i2) + p2.length()) > indexOfEnd) break;
            int i3 = pageText.indexOf(p3, i2);
            String urlName = pageText.substring(i2, i3);
            ElementInfo info = this.getMsdnElement(String.valueOf(baseUrl) + "/" + urlName);
            if (foundProps.contains(info)) continue;
            foundProps.add(info);
        }
        return foundProps.toArray(new ElementInfo[foundProps.size()]);
    }

    private static String getInitializer(String className) {
        if (className.trim().equalsIgnoreCase("Integer")) {
            return "0";
        }
        if (className.trim().equalsIgnoreCase("Boolean")) {
            return "false";
        }
        if (className.trim().equalsIgnoreCase("String")) {
            return "\"\"";
        }
        if (className.trim().equalsIgnoreCase("Number")) {
            return "0";
        }
        return "new " + className + "()";
    }

    @Override
    public String toString() {
        if (this.name != null) {
            return String.valueOf(this.name) + " URL " + this.baseUrl;
        }
        return this.baseUrl;
    }
}

