/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.emf2xml;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapterImpl;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRenderer;
import org.eclipse.wst.common.internal.emf.resource.Translator;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emf.utilities.Assert;
import org.eclipse.wst.common.internal.emf.utilities.DOMUtilities;
import org.eclipse.wst.common.internal.emf.utilities.FeatureValueConversionException;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EMF2DOMSSEAdapter
extends EMF2DOMAdapterImpl
implements INodeAdapter {
    private Class resourceClass;

    public EMF2DOMSSEAdapter(Node node, EMF2DOMRenderer renderer, Translator translator) {
        super(node, renderer, translator);
    }

    public EMF2DOMSSEAdapter(Notifier object, Node node, EMF2DOMRenderer renderer, Translator translator) {
        super(object, node, renderer, translator);
    }

    public EMF2DOMSSEAdapter(TranslatorResource resource, Document document, EMF2DOMRenderer renderer, Translator translator) {
        super(resource, document, renderer, translator);
    }

    protected String calcIndentString(Node node) {
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)node.getParentNode(), (String)"Node must be connected into the tree");
        Node parent = node.getParentNode();
        String indentString = this.getNewlineString(node);
        Node previousSibling = DOMUtilities.getPreviousNodeSibling((Node)node);
        if (previousSibling != null) {
            indentString = this.primGetIndentString(previousSibling);
        } else {
            String parentIndentString = this.primGetIndentString(parent);
            indentString = String.valueOf(parentIndentString) + "\t";
        }
        return indentString;
    }

    protected void debugDOMNotify(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue) {
    }

    protected void disableUndoManagementIfNecessary() {
        IDOMModel model = this.getXMLModel();
        if (model != null && model.getUndoManager() != null) {
            model.disableUndoManagement();
        }
    }

    protected void enableUndoManagement() {
        IDOMModel model = this.getXMLModel();
        if (model != null && model.getUndoManager() != null) {
            model.enableUndoManagement();
        }
    }

    protected String getNewlineString(Node node) {
        IDOMNode xmlNode;
        IStructuredDocument document;
        if (node instanceof IDOMNode && (document = (xmlNode = (IDOMNode)node).getStructuredDocument()) != null) {
            return document.getLineDelimiter();
        }
        return DOMUtilities.NEWLINE_STRING;
    }

    protected IDOMModel getXMLModel() {
        if (this.getNode() != null) {
            return ((IDOMNode)this.getNode()).getModel();
        }
        return null;
    }

    protected IDOMNode getXMLNode() {
        return (IDOMNode)this.getNode();
    }

    protected void handleFeatureValueConversionException(FeatureValueConversionException ex) {
    }

    protected void handleInvalidMultiNodes(String nodeName) {
    }

    protected void indent(Node node, Translator map) {
        Assert.isNotNull((Object)node.getParentNode(), (String)"Node must be connected into the tree");
        Assert.isNotNull((Object)node);
        String indentString = this.calcIndentString(node);
        this.indentStartTag(indentString, node, map);
        this.indentEndTag(indentString, node, map);
    }

    protected void indentEndTag(String indentString, Node node, Translator map) {
        if (!map.shouldIndentEndTag(node)) {
            return;
        }
        String domPath = map.getDOMPath();
        if (!map.isManagedByParent() && !map.isDOMTextValue() || map.isManagedByParent() && domPath.length() != 0 && node.getNodeName().equals(domPath)) {
            Text newWS = node.getOwnerDocument().createTextNode(String.valueOf(this.getNewlineString(node)) + indentString);
            DOMUtilities.insertBeforeNode((Node)node, (Node)newWS, null);
        }
    }

    protected void indentStartTag(String indentString, Node node, Translator map) {
        Node parent = node.getParentNode();
        Text newWS = node.getOwnerDocument().createTextNode(String.valueOf(this.getNewlineString(node)) + indentString);
        DOMUtilities.insertAfterNode((Node)parent, (Node)newWS, (Node)DOMUtilities.getPreviousNodeSibling((Node)node));
    }

    protected boolean isEmptyTag(Element parent) {
        return ((IDOMElement)parent).isEmptyTag();
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        Translator map;
        if (!this.isNotificationEnabled()) {
            return;
        }
        this.debugDOMNotify(notifier, eventType, changedFeature, oldValue, newValue);
        if (notifier != this.getNode() && eventType != 1) {
            Element notifyingNode;
            Translator map2;
            if (notifier instanceof Element && (eventType == 4 || eventType == 5 || eventType == 1) && (map2 = this.findTranslator((notifyingNode = (Element)notifier).getNodeName(), false)) != null) {
                this.updateMOFFeature(map2, this.getNode(), this.getEObject());
            }
        } else if (eventType == 4 || eventType == 5) {
            this.updateMOF();
        } else if (eventType == 1 && (map = this.findTranslator(changedFeature.toString(), true)) != null) {
            this.updateMOFFeature(map, this.getNode(), this.getEObject());
        }
    }

    protected void postUpdateDOMFeature(Translator map, Node node, EObject mofObject) {
        this.enableUndoManagement();
    }

    protected void preUpdateDOMFeature(Translator map, Node node, EObject mofObject) {
        super.preUpdateDOMFeature(map, node, mofObject);
        this.disableUndoManagementIfNecessary();
    }

    protected void primAddDOMAdapter(Node aNode, EMF2DOMAdapter anAdapter) {
        ((IDOMNode)aNode).addAdapter((EMF2DOMSSEAdapter)anAdapter);
    }

    protected EMF2DOMAdapter primCreateAdapter(EObject mofObject, Translator childMap) {
        Element newNode = this.createNewNode(mofObject, childMap);
        return new EMF2DOMSSEAdapter((Notifier)mofObject, newNode, this.fRenderer, childMap);
    }

    protected EMF2DOMAdapter primCreateAdapter(Node node, Translator childMap) {
        return new EMF2DOMSSEAdapter(node, this.fRenderer, childMap);
    }

    protected EMF2DOMAdapter createAdapter(Node node, Translator childMap) {
        Assert.isNotNull((Object)node);
        EMF2DOMAdapter adapter = this.primGetExistingAdapter(node, childMap);
        if (adapter != null && (adapter.isMOFProxy() || adapter.getTarget() == null)) {
            this.removeDOMAdapter(node, adapter);
            if (adapter.getTarget() != null) {
                adapter.getTarget().eAdapters().remove((Object)adapter);
            }
            adapter = null;
        }
        if (adapter == null) {
            adapter = this.primCreateAdapter(node, childMap);
        }
        return adapter;
    }

    protected void addDOMAdapter(Node childNode) {
        EMF2DOMAdapter attrAdapter;
        if (childNode.getNodeType() == 1 && ((attrAdapter = this.primGetExistingAdapter(childNode)) == null || attrAdapter.getNode() != this.getNode())) {
            this.removeDOMAdapter(childNode, attrAdapter);
            this.primAddDOMAdapter(childNode, (EMF2DOMAdapter)this);
        }
    }

    protected EMF2DOMAdapter primGetExistingAdapter(Node aNode, Translator childMap) {
        INodeNotifier sseNode = (INodeNotifier)aNode;
        Collection adapters = sseNode.getAdapters();
        for (INodeAdapter adapter : adapters) {
            if (adapter == null || !adapter.isAdapterForType((Object)EMF2DOMAdapter.ADAPTER_CLASS)) continue;
            EMF2DOMSSEAdapter e2DAdapter = (EMF2DOMSSEAdapter)adapter;
            Notifier adapterTarget = e2DAdapter.getTarget();
            if (this.getTarget() == null || adapterTarget == null) {
                if (this.resourceClass == null || !this.resourceClass.equals(e2DAdapter.getResourceClass())) continue;
                return e2DAdapter;
            }
            if (this.getTarget() instanceof Resource) {
                if (adapterTarget != null && adapterTarget == this.getTarget()) {
                    return e2DAdapter;
                }
            } else {
                EObject myTarget = (EObject)this.getTarget();
                if (adapterTarget != null && ((EObject)adapterTarget).eResource() == myTarget.eResource()) {
                    return e2DAdapter;
                }
            }
            if (!(adapterTarget instanceof EObject) || ((EObject)e2DAdapter.getTarget()).eResource() != null || e2DAdapter.fTranslator != childMap) continue;
            return e2DAdapter;
        }
        return null;
    }

    protected EMF2DOMAdapter primGetExistingAdapter(Node aNode) {
        INodeNotifier sseNode = (INodeNotifier)aNode;
        Collection adapters = sseNode.getAdapters();
        for (INodeAdapter adapter : adapters) {
            if (adapter == null || !adapter.isAdapterForType((Object)EMF2DOMAdapter.ADAPTER_CLASS)) continue;
            EMF2DOMSSEAdapter e2DAdapter = (EMF2DOMSSEAdapter)adapter;
            Notifier adapterTarget = e2DAdapter.getTarget();
            if (this.getTarget() == null || adapterTarget == null) {
                if (this.resourceClass == null || !this.resourceClass.equals(e2DAdapter.getResourceClass())) continue;
                return e2DAdapter;
            }
            if (this.getTarget() instanceof Resource) {
                if (adapterTarget != null && adapterTarget == this.getTarget()) {
                    return e2DAdapter;
                }
            } else {
                EObject myTarget = (EObject)this.getTarget();
                if (adapterTarget != null && ((EObject)adapterTarget).eResource() == myTarget.eResource()) {
                    return e2DAdapter;
                }
            }
            if (!(adapterTarget instanceof EObject) || ((EObject)e2DAdapter.getTarget()).eResource() != null) continue;
            return e2DAdapter;
        }
        return null;
    }

    protected String primGetIndentString(Node node) {
        IStructuredDocument flatModel = ((IDOMNode)node).getStructuredDocument();
        int nodeStartOff = ((IDOMNode)node).getStartOffset();
        int startOff = Math.max(0, nodeStartOff - 100);
        int endOff = nodeStartOff;
        if (flatModel != null) {
            try {
                String text = flatModel.get(startOff, endOff - startOff);
                int inx = text.length() - 1;
                if (inx >= 0) {
                    while (inx >= 0) {
                        char ch = text.charAt(inx);
                        if (!Character.isWhitespace(ch) || ch == '\n' || ch == '\r') {
                            ++inx;
                            break;
                        }
                        --inx;
                    }
                    return text.substring(inx);
                }
            }
            catch (BadLocationException ex) {
                Logger.logException(ex);
            }
        }
        return "";
    }

    protected void removeDOMAdapter(Node aNode, EMF2DOMAdapter anAdapter) {
        ((IDOMNode)aNode).removeAdapter((INodeAdapter)anAdapter);
    }

    protected void reorderDOMChild(Node parentNode, Node childNode, Node insertBeforeNode, Translator map) {
        super.reorderDOMChild(parentNode, childNode, insertBeforeNode, map);
        if (insertBeforeNode != null && insertBeforeNode.getNodeType() == 1) {
            this.indentStartTag(this.calcIndentString(insertBeforeNode), insertBeforeNode, map);
        } else {
            this.indentStartTag(this.calcIndentString(childNode), childNode, map);
        }
    }

    protected void setEmptyTag(Element element) {
        ((IDOMElement)element).setEmptyTag(true);
    }

    public void updateDOM() {
        if (!this.isNotificationEnabled()) {
            return;
        }
        try {
            this.disableUndoManagementIfNecessary();
            this.primUpdateDOM();
        }
        finally {
            this.enableUndoManagement();
        }
    }

    public Class getResourceClass() {
        return this.resourceClass;
    }

    protected void initChildTranslators() {
        if (this.fRenderer != null && this.fRenderer.getResource() != null) {
            this.resourceClass = this.fRenderer.getResource().getClass();
        }
        super.initChildTranslators();
    }
}

