/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.contentassist;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.util.Strings;

public class StaticQualifierPrefixMatcher
extends PrefixMatcher {
    @Inject
    private PrefixMatcher.IgnoreCase delegate;
    protected String delimiter = "::";

    public String getLastSegment(String fqn) {
        if (fqn == null || fqn.length() == 0) {
            return null;
        }
        boolean lookForUppercase = true;
        int i = 0;
        while (i <= fqn.length() - this.delimiter.length()) {
            if (lookForUppercase && Character.isUpperCase(fqn.charAt(i))) {
                return fqn.substring(i);
            }
            lookForUppercase = this.delimiter.equals(fqn.substring(i, i + this.delimiter.length()));
            if (lookForUppercase) {
                ++i;
            }
            ++i;
        }
        return null;
    }

    public boolean isCandidateMatchingPrefix(String name, String prefix) {
        if (this.delegate.isCandidateMatchingPrefix(name, prefix)) {
            return true;
        }
        if (name.indexOf(this.delimiter) >= 0) {
            if (prefix.indexOf(this.delimiter) < 0) {
                String lastSegment = this.getLastSegment(name);
                if (lastSegment != null && this.delegate.isCandidateMatchingPrefix(lastSegment, prefix)) {
                    return true;
                }
            } else {
                List splitPrefix = Strings.split((String)prefix, (String)this.delimiter);
                if (splitPrefix.isEmpty()) {
                    return false;
                }
                List splitName = Strings.split((String)name, (String)this.delimiter);
                if (splitName.size() < splitPrefix.size()) {
                    return false;
                }
                int i = 0;
                while (i < splitPrefix.size()) {
                    if (!this.delegate.isCandidateMatchingPrefix((String)splitName.get(i), (String)splitPrefix.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }
}

