/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

class ObjectKind {
    private static final int UNRESTRICTED_MASK = 0;
    private static final int STRUCT_MASK = 1;
    private static final int DICT_MASK = 2;
    private static final int BOTH_MASK = 3;
    private int mask;
    static final ObjectKind UNRESTRICTED = new ObjectKind(0);
    static final ObjectKind STRUCT = new ObjectKind(1);
    static final ObjectKind DICT = new ObjectKind(2);
    private static final ObjectKind BOTH = new ObjectKind(3);
    private static final ObjectKind[] vals = new ObjectKind[]{UNRESTRICTED, STRUCT, DICT, BOTH};

    private ObjectKind(int mask) {
        this.mask = mask;
    }

    static ObjectKind meet(ObjectKind ok1, ObjectKind ok2) {
        return vals[ok1.mask & ok2.mask];
    }

    static ObjectKind join(ObjectKind ok1, ObjectKind ok2) {
        return vals[ok1.mask | ok2.mask];
    }

    boolean isUnrestricted() {
        return this.mask == 0;
    }

    boolean isStruct() {
        return (this.mask & 1) != 0;
    }

    boolean isDict() {
        return (this.mask & 2) != 0;
    }

    boolean isSubtypeOf(ObjectKind other) {
        return this.mask == (this.mask & other.mask);
    }
}

