/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swing;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.util.SecurityUtil;

public final class SwingImageCache {
    private final Panel p = new Panel();
    private final Hashtable<String, Image> htCache;
    private final IDisplayServer idsSWING;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swing");

    SwingImageCache(IDisplayServer idsSWING) {
        this.idsSWING = idsSWING;
        this.htCache = SecurityUtil.newHashtable();
    }

    final Image loadImage(URL url) throws ChartException {
        String sUrl = url.toString();
        Image img = this.htCache.get(sUrl);
        if (img != null) {
            logger.log(1, Messages.getString("SwingImageCache.info.using.swing.cached.image", new Object[]{url}, this.idsSWING.getULocale()));
        } else {
            logger.log(1, Messages.getString("SwingImageCache.info.loading.swing.image", new Object[]{url}, this.idsSWING.getULocale()));
            try {
                img = ImageIO.read(url);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            try {
                MediaTracker tracker = new MediaTracker(this.p);
                tracker.addImage(img, 0);
                tracker.waitForAll();
                if ((tracker.statusAll(true) & 4) != 0) {
                    StringBuffer sb = new StringBuffer();
                    Object[] oa = tracker.getErrorsAny();
                    sb.append('[');
                    int i = 0;
                    while (i < oa.length) {
                        sb.append(oa[i]);
                        if (i < oa.length - 1) {
                            sb.append(", ");
                        }
                        ++i;
                    }
                    sb.append(']');
                    throw new ChartException("org.eclipse.birt.chart.device.extension", 4, "SwingImageCache.exception.media.tracker", new Object[]{sb.toString()}, Messages.getResourceBundle(this.idsSWING.getULocale()));
                }
            }
            catch (InterruptedException ex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 4, (Throwable)ex);
            }
            catch (IOException e) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 4, (Throwable)e);
            }
            this.htCache.put(sUrl, img);
        }
        return img;
    }

    final void flush() {
        if (this.htCache.isEmpty()) {
            return;
        }
        int n = this.htCache.size();
        Enumeration<Image> eV = this.htCache.elements();
        while (eV.hasMoreElements()) {
            Image img = eV.nextElement();
            img.flush();
        }
        this.htCache.clear();
        logger.log(1, Messages.getString("SwingImageCache.info.flushed.swing.images", new Object[]{n}, this.idsSWING.getULocale()));
    }

    final Object getObserver() {
        return this.p;
    }
}

