/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.features.RoutingNet;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class RoutingLane {
    protected static final List<RoutingLane> EMPTY_LIST = new ArrayList<RoutingLane>();
    protected Rectangle rect;
    protected List<RoutingLane> leftAdjacent;
    protected List<RoutingLane> rightAdjacent;
    protected ContainerShape shape;

    public RoutingLane(int x, int y, int width, int height) {
        this(new Rectangle(x, y, width, height));
    }

    private RoutingLane(Rectangle r) {
        this.rect = new Rectangle(r);
    }

    public Adjacence adjacent(RoutingLane node) {
        return this.adjacent(node.rect);
    }

    public Adjacence adjacent(Rectangle other) {
        if (this.rect.y == other.bottom()) {
            if (this.rect.right() <= other.x || other.right() <= this.rect.x) {
                return Adjacence.NONE;
            }
            return Adjacence.TOP;
        }
        if (this.rect.x == other.right()) {
            if (this.rect.bottom() <= other.y || other.bottom() <= this.rect.y) {
                return Adjacence.NONE;
            }
            return Adjacence.LEFT;
        }
        if (this.rect.right() == other.x) {
            if (this.rect.bottom() <= other.y || other.bottom() <= this.rect.y) {
                return Adjacence.NONE;
            }
            return Adjacence.RIGHT;
        }
        if (this.rect.bottom() == other.y) {
            if (this.rect.right() <= other.x || other.right() <= this.rect.x) {
                return Adjacence.NONE;
            }
            return Adjacence.BOTTOM;
        }
        return Adjacence.NONE;
    }

    public boolean intersects(RoutingLane node) {
        return this.intersects(node.rect);
    }

    public boolean intersects(Rectangle rect) {
        return GraphicsUtil.intersects(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2, this.rect.x + 1, this.rect.y + 1, this.rect.width - 2, this.rect.height - 2);
    }

    public void addLeft(RoutingLane node) {
        if (this.leftAdjacent == null) {
            this.leftAdjacent = new ArrayList<RoutingLane>();
        }
        if (!this.leftAdjacent.contains(node)) {
            this.leftAdjacent.add(node);
        }
        if (node.rightAdjacent == null) {
            node.rightAdjacent = new ArrayList<RoutingLane>();
        }
        if (!node.rightAdjacent.contains(this)) {
            node.rightAdjacent.add(this);
        }
    }

    public boolean hasLeft() {
        return this.leftAdjacent != null && this.leftAdjacent.size() > 0;
    }

    public List<RoutingLane> getLeft() {
        if (this.hasLeft()) {
            return this.leftAdjacent;
        }
        return EMPTY_LIST;
    }

    public void addRight(RoutingLane node) {
        if (this.rightAdjacent == null) {
            this.rightAdjacent = new ArrayList<RoutingLane>();
        }
        if (!this.rightAdjacent.contains(node)) {
            this.rightAdjacent.add(node);
        }
        if (node.leftAdjacent == null) {
            node.leftAdjacent = new ArrayList<RoutingLane>();
        }
        if (!node.leftAdjacent.contains(this)) {
            node.leftAdjacent.add(this);
        }
    }

    public boolean hasRight() {
        return this.rightAdjacent != null && this.rightAdjacent.size() > 0;
    }

    public List<RoutingLane> getRight() {
        if (this.hasRight()) {
            return this.rightAdjacent;
        }
        return EMPTY_LIST;
    }

    public int getX() {
        return this.rect.x;
    }

    public int getY() {
        return this.rect.y;
    }

    public void setX(int i) {
        this.rect.x = i;
    }

    public void setY(int i) {
        this.rect.y = i;
    }

    public int getWidth() {
        return this.rect.width;
    }

    public int getHeight() {
        return this.rect.height;
    }

    public void setWidth(int i) {
        this.rect.width = i;
    }

    public void setHeight(int i) {
        this.rect.height = i;
    }

    public void setShape(PictogramElement shape) {
        this.shape = (ContainerShape)shape;
    }

    public ContainerShape getShape() {
        return this.shape;
    }

    public boolean equals(Object that) {
        if (that instanceof RoutingLane) {
            return this.rect.equals((Object)((RoutingLane)that).rect);
        }
        return false;
    }

    public void rotate(boolean b) {
        RoutingNet.rotateRectangle(this.rect);
    }

    public void navigateTo(RoutingLane ta, RoutingNet owner) {
        owner.push(this);
        if (this == ta) {
            owner.solutionFound();
        } else {
            for (RoutingLane a : this.getRight()) {
                if (owner.visited(a)) continue;
                a.navigateTo(ta, owner);
            }
            for (RoutingLane a : this.getLeft()) {
                if (owner.visited(a)) continue;
                a.navigateTo(ta, owner);
            }
        }
        owner.pop();
    }

    public static enum Adjacence {
        LEFT,
        TOP,
        BOTTOM,
        RIGHT,
        NONE;

    }
}

