/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public abstract class AbstractPushPullFeature
extends AbstractCustomFeature {
    public static final int MARGIN = 20;
    protected String description;
    protected ContainerShape containerShape;
    protected FlowElementsContainer businessObject;
    protected Diagram oldDiagram;
    protected Diagram newDiagram;
    protected BPMNDiagram oldBpmnDiagram;
    protected BPMNDiagram newBpmnDiagram;
    protected BPMNShape bpmnShape;
    protected Rectangle boundingRectangle = null;
    protected List<DiagramElement> diagramElements = new ArrayList<DiagramElement>();
    protected List<Shape> childShapes = new ArrayList<Shape>();
    protected List<Connection> internalConnections = new ArrayList<Connection>();
    protected Hashtable<Connection, SourceTarget> externalConnections = new Hashtable();

    public AbstractPushPullFeature(IFeatureProvider fp) {
        super(fp);
    }

    protected abstract void collectDiagramElements(FlowElementsContainer var1, BPMNDiagram var2);

    protected abstract void collectShapes(ContainerShape var1);

    protected abstract void moveGraphitiData(Diagram var1, Diagram var2);

    protected abstract Rectangle calculateBoundingRectangle(ContainerShape var1, List<Shape> var2);

    protected void moveDiagramElements(BPMNDiagram source, BPMNDiagram target) {
        for (DiagramElement sourceDe : this.diagramElements) {
            BaseElement be = null;
            if (sourceDe instanceof BPMNEdge) {
                be = ((BPMNEdge)sourceDe).getBpmnElement();
            } else if (sourceDe instanceof BPMNShape) {
                be = ((BPMNShape)sourceDe).getBpmnElement();
            }
            boolean moveIt = true;
            for (DiagramElement targetDe : target.getPlane().getPlaneElement()) {
                if (sourceDe instanceof BPMNEdge && targetDe instanceof BPMNEdge) {
                    if (be != ((BPMNEdge)targetDe).getBpmnElement()) continue;
                    moveIt = false;
                    continue;
                }
                if (!(sourceDe instanceof BPMNShape) || !(targetDe instanceof BPMNShape) || be != ((BPMNShape)targetDe).getBpmnElement()) continue;
                moveIt = false;
            }
            if (!moveIt) continue;
            target.getPlane().getPlaneElement().add(sourceDe);
        }
    }

    protected void moveShapes(ContainerShape source, ContainerShape target, int xOffset, int yOffset) {
        for (Shape s : this.childShapes) {
            if (s instanceof ContainerShape && FeatureSupport.hasBPMNShape((PictogramElement)((ContainerShape)s))) {
                ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram(s);
                int x = loc.getX() - xOffset;
                int y = loc.getY() - yOffset;
                MoveShapeContext moveContext = new MoveShapeContext(s);
                moveContext.setSourceContainer(source);
                moveContext.setTargetContainer(target);
                moveContext.setLocation(x, y);
                IMoveShapeFeature moveFeature = this.getFeatureProvider().getMoveShapeFeature((IMoveShapeContext)moveContext);
                moveFeature.moveShape((IMoveShapeContext)moveContext);
                this.layoutIfNecessary((ContainerShape)s);
                continue;
            }
            target.getChildren().add((Object)s);
        }
    }

    protected boolean isReferenceShape(Diagram diagram, PictogramElement pe) {
        BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)pe);
        return be instanceof Participant && FeatureSupport.isParticipantReference((Diagram)diagram, (Participant)((Participant)be));
    }

    protected AnchorContainer getExternalContainer(ContainerShape source, AnchorContainer ac) {
        AnchorContainer parent = ac;
        while (parent != null && !(parent instanceof Diagram)) {
            BaseElement be;
            if (parent == source) {
                return null;
            }
            if (parent instanceof ContainerShape && (be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)((PictogramElement)parent))) instanceof Participant) {
                return parent;
            }
            parent = parent.eContainer();
        }
        if (parent instanceof Diagram) {
            return parent;
        }
        return null;
    }

    protected boolean isDescendant(AnchorContainer ac, PictogramElement shape) {
        while (FeatureSupport.isLane((PictogramElement)ac)) {
            if (!(ac.eContainer() instanceof AnchorContainer)) continue;
            ac = (AnchorContainer)ac.eContainer();
        }
        if (shape instanceof ConnectionDecorator) {
            shape = ((ConnectionDecorator)shape).getConnection();
        }
        if (shape instanceof Connection) {
            Connection c = (Connection)shape;
            return this.isDescendant(ac, (PictogramElement)c.getStart().getParent()) && this.isDescendant(ac, (PictogramElement)c.getEnd().getParent());
        }
        Diagram diagram = Graphiti.getPeService().getDiagramForPictogramElement((PictogramElement)ac);
        while (shape != null) {
            if (this.isReferenceShape(diagram, shape)) {
                return false;
            }
            if (shape == ac) {
                return true;
            }
            if (!(shape.eContainer() instanceof ContainerShape)) break;
            shape = (ContainerShape)shape.eContainer();
        }
        return shape == ac;
    }

    protected boolean isExternalConnection(AnchorContainer ac, Connection c) {
        return !this.isDescendant(ac, (PictogramElement)c.getStart().getParent()) || !this.isDescendant(ac, (PictogramElement)c.getEnd().getParent());
    }

    protected void collectExternalConnections(ContainerShape source, Connection c) {
        if (!this.externalConnections.containsKey(c)) {
            AnchorContainer startShape = null;
            AnchorContainer endShape = null;
            AnchorContainer startContainer = null;
            AnchorContainer endContainer = null;
            startShape = c.getStart().getParent();
            endShape = c.getEnd().getParent();
            if (this.isDescendant((AnchorContainer)source, (PictogramElement)startShape)) {
                if (this.isDescendant((AnchorContainer)source, (PictogramElement)endShape)) {
                    return;
                }
                endContainer = this.getExternalContainer(source, endShape);
                this.externalConnections.put(c, new SourceTarget(startShape, endContainer, startShape));
            } else if (this.isDescendant((AnchorContainer)source, (PictogramElement)endShape)) {
                if (this.isDescendant((AnchorContainer)source, (PictogramElement)startShape)) {
                    return;
                }
                startContainer = this.getExternalContainer(source, startShape);
                this.externalConnections.put(c, new SourceTarget(startContainer, endShape, endShape));
            }
        }
    }

    protected void collectConnections(ContainerShape source) {
        for (Shape s : source.getChildren()) {
            if (!(s instanceof ContainerShape)) continue;
            for (Connection c : FeatureSupport.getConnections((AnchorContainer)s)) {
                if (this.isExternalConnection((AnchorContainer)source, c)) {
                    this.collectExternalConnections(source, c);
                } else if (!this.internalConnections.contains(c)) {
                    this.internalConnections.add(c);
                }
                for (Connection c2 : FeatureSupport.getConnections((AnchorContainer)c)) {
                    if (this.isExternalConnection((AnchorContainer)source, c2)) {
                        this.collectExternalConnections(source, c2);
                        continue;
                    }
                    if (this.internalConnections.contains(c2)) continue;
                    this.internalConnections.add(c2);
                }
            }
            BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)s);
            if (be instanceof FlowElementsContainer) {
                this.collectConnections((ContainerShape)s);
                continue;
            }
            if (!(be instanceof Lane)) continue;
            this.collectConnections((ContainerShape)s);
        }
    }

    protected void moveConnections(ContainerShape source, ContainerShape target) {
        Diagram targetDiagram = Graphiti.getPeService().getDiagramForShape((Shape)target);
        targetDiagram.getConnections().addAll(this.internalConnections);
    }

    protected ContainerShape findReferencedShape(AnchorContainer refShape, Diagram diagram) {
        BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)refShape);
        Object[] objectArray = Graphiti.getPeService().getLinkedPictogramElements(new EObject[]{be}, diagram);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ContainerShape && FeatureSupport.hasBPMNShape((PictogramElement)((ContainerShape)o))) {
                return (ContainerShape)o;
            }
            ++n2;
        }
        return null;
    }

    protected Connection findReferencedConnection(Connection refConnection, Diagram diagram) {
        BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)refConnection);
        for (Connection c : diagram.getConnections()) {
            if (BusinessObjectUtil.getFirstBaseElement((PictogramElement)c) != be) continue;
            return c;
        }
        return null;
    }

    protected Point getChildOffset(ContainerShape targetContainerShape) {
        return GraphicsUtil.createPoint((int)0, (int)0);
    }

    protected void layoutIfNecessary(ContainerShape shape) {
        BPMNShape bpmnShape;
        BPMNDiagram bpmnDiagram;
        FlowElementsContainer fec = (FlowElementsContainer)BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, FlowElementsContainer.class);
        if (fec != null && (bpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)shape)) != null && (bpmnShape = DIUtils.findBPMNShape((BPMNDiagram)bpmnDiagram, (BaseElement)fec)) != null) {
            LayoutContext layoutContext = new LayoutContext((PictogramElement)shape);
            ILayoutFeature layoutFeature = this.getFeatureProvider().getLayoutFeature((ILayoutContext)layoutContext);
            layoutFeature.layout((ILayoutContext)layoutContext);
        }
    }

    public static class SourceTarget {
        public AnchorContainer localShape;
        public AnchorContainer source;
        public AnchorContainer target;

        public SourceTarget(AnchorContainer source, AnchorContainer target, AnchorContainer localShape) {
            this.source = source;
            this.target = target;
            this.localShape = localShape;
        }
    }
}

