/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.pdom;

import org.eclipse.cdt.internal.qt.core.pdom.IQtPDOMCodec;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMLinkage;
import org.eclipse.core.runtime.CoreException;

public class QtPDOMArray<T> {
    private static int offsetInitializer = 0;
    private final QtPDOMLinkage linkage;
    private final IQtPDOMCodec<T> codec;
    private long record;

    public QtPDOMArray(QtPDOMLinkage linkage, IQtPDOMCodec<T> codec, long record) {
        this.linkage = linkage;
        this.codec = codec;
        this.record = record;
    }

    public QtPDOMArray(QtPDOMLinkage linkage, IQtPDOMCodec<T> codec, T[] array) throws CoreException {
        this.linkage = linkage;
        this.codec = codec;
        this.record = 0L;
        this.set(array);
    }

    public long getRecord() {
        return this.record;
    }

    public T[] get() throws CoreException {
        if (this.record == 0L) {
            return null;
        }
        int count = this.linkage.getDB().getInt(Field.Count.getRecord(this.record));
        long elementRec = Field.Data.getRecord(this.record);
        T[] array = this.codec.allocArray(count);
        int i = 0;
        while (i < count) {
            array[i] = this.codec.decode(this.linkage, elementRec);
            ++i;
            elementRec += (long)this.codec.getElementSize();
        }
        return array;
    }

    public long set(T[] array) throws CoreException {
        if (array == null) {
            return this.delete();
        }
        if (this.record == 0L) {
            this.record = this.linkage.getDB().malloc(Field.Data.offset + array.length * this.codec.getElementSize());
            this.linkage.getDB().putInt(Field.Count.getRecord(this.record), array.length);
        } else {
            int count = this.linkage.getDB().getInt(Field.Count.getRecord(this.record));
            if (count != array.length) {
                this.linkage.getDB().free(this.record);
                this.record = this.linkage.getDB().malloc(Field.Data.offset + array.length * this.codec.getElementSize());
                this.linkage.getDB().putInt(Field.Count.getRecord(this.record), array.length);
            }
        }
        long elementRec = Field.Data.getRecord(this.record);
        int i = 0;
        while (i < array.length) {
            this.codec.encode(this.linkage, elementRec, array[i]);
            ++i;
            elementRec += (long)this.codec.getElementSize();
        }
        return this.record;
    }

    public long delete() throws CoreException {
        if (this.record == 0L) {
            return this.record;
        }
        int count = this.linkage.getDB().getInt(Field.Count.getRecord(this.record));
        if (count > 0) {
            long elementRec = Field.Data.getRecord(this.record);
            int i = 0;
            while (i < count) {
                this.codec.encode(this.linkage, elementRec, null);
                ++i;
                elementRec += (long)this.codec.getElementSize();
            }
        }
        this.linkage.getDB().free(this.record);
        this.record = 0L;
        return this.record;
    }

    protected static enum Field {
        Count(4),
        Data(0);

        public final int offset = offsetInitializer;

        private Field(int sizeof) {
            offsetInitializer += sizeof;
        }

        public long getRecord(long baseRec) {
            return baseRec + (long)this.offset;
        }
    }
}

