/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.core.qmljs;

import org.eclipse.cdt.qt.core.qmljs.IJSExpression;

public interface IJSBinaryExpression
extends IJSExpression {
    @Override
    default public String getType() {
        return "BinaryExpression";
    }

    public BinaryOperator getOperator();

    public IJSExpression getLeft();

    public IJSExpression getRight();

    public static enum BinaryOperator {
        Equality("=="),
        Inequality("!="),
        StrictEquality("==="),
        LessThan("<"),
        LessThanOrEqual("<="),
        GreaterThan(">"),
        GreaterThanOrEqual(">="),
        LeftShift("<<"),
        RightShift(">>"),
        UnsignedRightShift(">>>"),
        Add("+"),
        Subtract("-"),
        Multiply("*"),
        Divide("/"),
        Modulus("%"),
        Or("|"),
        EclusiveOr("^"),
        And("&"),
        In("in"),
        Instanceof("instanceof");

        private final String op;

        public static BinaryOperator fromObject(Object obj) {
            if (obj instanceof String) {
                BinaryOperator[] binaryOperatorArray = BinaryOperator.values();
                int n = binaryOperatorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BinaryOperator op = binaryOperatorArray[n2];
                    if (obj.equals(op.toString())) {
                        return op;
                    }
                    ++n2;
                }
            }
            return null;
        }

        private BinaryOperator(String op) {
            this.op = op;
        }

        public String toString() {
            return this.op;
        }
    }
}

