/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui;

import java.util.List;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.model.CDOClassInfo;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.internal.ui.EMFIntrospectionProvider;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.ui.views.RowIntrospectionProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class CDOIntrospectionProvider
extends EMFIntrospectionProvider {
    protected static final int PRIORITY = 60;
    protected static final int CATEGORY = -10;
    private static final String CDO_ID = "cdoID";
    private static final String CDO_LOCK_STATE = "cdoLockState";
    private static final String CDO_PERMISSION = "cdoPermission";
    private static final String CDO_REVISION = "cdoRevision";
    private static final String CDO_CLASS_INFO = "cdoClassInfo";
    private static final String CDO_STATE = "cdoState";
    private static final String CDO_VIEW = "cdoView";
    private final Color foreground = Display.getDefault().getSystemColor(14);

    public CDOIntrospectionProvider() {
        super(CDOObject.class.getName(), "CDOObject");
    }

    @Override
    public int getPriority() {
        return 60;
    }

    @Override
    public boolean canHandle(Object object) {
        return CDOIntrospectionProvider.getCDOObject(object) != null;
    }

    @Override
    protected void fillRows(Object parent, List<RowIntrospectionProvider.Row> rows) throws Exception {
        super.fillRows(parent, rows);
        CDOObject cdoObject = CDOIntrospectionProvider.getCDOObject(parent);
        if (cdoObject != null) {
            rows.add(this.createCDOIDRow(cdoObject));
            rows.add(this.createCDOLockStateRow(cdoObject));
            rows.add(this.createCDOPermissionRow(cdoObject));
            rows.add(this.createCDORevisionRow(cdoObject));
            rows.add(this.createCDOClassInfoRow(cdoObject));
            rows.add(this.createCDOStateRow(cdoObject));
            rows.add(this.createCDOViewRow(cdoObject));
        }
    }

    @Override
    public RowIntrospectionProvider.Row getElementByName(Object parent, String name) throws Exception {
        CDOObject cdoObject;
        RowIntrospectionProvider.Row result = super.getElementByName(parent, name);
        if (result == null && (cdoObject = CDOIntrospectionProvider.getCDOObject(parent)) != null) {
            if (CDO_ID.equals(name)) {
                return this.createCDOIDRow(cdoObject);
            }
            if (CDO_LOCK_STATE.equals(name)) {
                return this.createCDOLockStateRow(cdoObject);
            }
            if (CDO_PERMISSION.equals(name)) {
                return this.createCDOPermissionRow(cdoObject);
            }
            if (CDO_REVISION.equals(name)) {
                return this.createCDORevisionRow(cdoObject);
            }
            if (CDO_CLASS_INFO.equals(name)) {
                return this.createCDOClassInfoRow(cdoObject);
            }
            if (CDO_STATE.equals(name)) {
                return this.createCDOStateRow(cdoObject);
            }
            if (CDO_VIEW.equals(name)) {
                return this.createCDOViewRow(cdoObject);
            }
        }
        return result;
    }

    private RowIntrospectionProvider.Row createCDOViewRow(CDOObject cdoObject) {
        return CDOIntrospectionProvider.createRow(CDO_VIEW, cdoObject.cdoView(), CDOView.class.getName(), -10, this.foreground);
    }

    private RowIntrospectionProvider.Row createCDOStateRow(CDOObject cdoObject) {
        return CDOIntrospectionProvider.createRow(CDO_STATE, cdoObject.cdoState(), CDOState.class.getName(), -10, this.foreground);
    }

    private RowIntrospectionProvider.Row createCDORevisionRow(CDOObject cdoObject) {
        return CDOIntrospectionProvider.createRow(CDO_REVISION, cdoObject.cdoRevision(), CDORevision.class.getName(), -10, this.foreground);
    }

    private RowIntrospectionProvider.Row createCDOClassInfoRow(CDOObject cdoObject) {
        CDORevision revision = cdoObject.cdoRevision();
        return CDOIntrospectionProvider.createRow(CDO_CLASS_INFO, revision == null ? null : revision.getClassInfo(), CDOClassInfo.class.getName(), -10, this.foreground);
    }

    private RowIntrospectionProvider.Row createCDOPermissionRow(CDOObject cdoObject) {
        return CDOIntrospectionProvider.createRow(CDO_PERMISSION, cdoObject.cdoPermission(), CDOPermission.class.getName(), -10, this.foreground);
    }

    private RowIntrospectionProvider.Row createCDOLockStateRow(CDOObject cdoObject) {
        return CDOIntrospectionProvider.createRow(CDO_LOCK_STATE, cdoObject.cdoLockState(), CDOLockState.class.getName(), -10, this.foreground);
    }

    private RowIntrospectionProvider.Row createCDOIDRow(CDOObject cdoObject) {
        return CDOIntrospectionProvider.createRow(CDO_ID, cdoObject.cdoID(), CDOID.class.getName(), -10, this.foreground);
    }

    private static CDOObject getCDOObject(Object object) {
        if (object instanceof EObject) {
            return CDOUtil.getCDOObject((EObject)((EObject)object));
        }
        return null;
    }
}

