/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecp.view.internal.editor.controls.ColumnEnablementConfigurationDMRRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.table.model.VEnablementConfiguration;
import org.eclipse.emf.ecp.view.spi.table.model.VTablePackage;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(name="ColumnEnablementConfigurationDMRRendererService", service={EMFFormsDIRendererService.class})
public class ColumnEnablementConfigurationDMRRendererService
implements EMFFormsDIRendererService<VControl> {
    private EMFFormsDatabindingEMF databinding;
    private ReportService reportService;

    @Reference(cardinality=ReferenceCardinality.MANDATORY, unbind="-")
    public void setEMFFormsDatabindingEMF(EMFFormsDatabindingEMF databinding) {
        this.databinding = databinding;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, unbind="-")
    public void setreportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        if (!VControl.class.isInstance(vElement)) {
            return Double.NaN;
        }
        VDomainModelReference domainModelReference = ((VControl)VControl.class.cast(vElement)).getDomainModelReference();
        if (domainModelReference == null) {
            return Double.NaN;
        }
        try {
            IEMFValueProperty valueProperty = this.databinding.getValueProperty(domainModelReference, viewModelContext.getDomainModel());
            if (viewModelContext.getDomainModel() instanceof VEnablementConfiguration && valueProperty.getStructuralFeature() == VTablePackage.eINSTANCE.getSingleColumnConfiguration_ColumnDomainReference()) {
                return 3.0;
            }
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report(new AbstractReport((Throwable)ex));
        }
        return Double.NaN;
    }

    public Class<? extends AbstractSWTRenderer<VControl>> getRendererClass() {
        return ColumnEnablementConfigurationDMRRenderer.class;
    }
}

