/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.binary;

import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryBaseTableAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinTableAnnotation;

public final class BinaryJoinTableAnnotation
extends BinaryBaseTableAnnotation
implements JoinTableAnnotation {
    private final Vector<JoinColumnAnnotation> joinColumns = this.buildJoinColumns();
    private final Vector<JoinColumnAnnotation> inverseJoinColumns = this.buildInverseJoinColumns();

    public BinaryJoinTableAnnotation(JavaResourceModel parent, IAnnotation jdtAnnotation) {
        super(parent, jdtAnnotation);
    }

    public String getAnnotationName() {
        return "javax.persistence.JoinTable";
    }

    @Override
    public void update() {
        super.update();
        this.updateJoinColumns();
        this.updateInverseJoinColumns();
    }

    @Override
    protected String getNameElementName() {
        return "name";
    }

    @Override
    protected String getSchemaElementName() {
        return "schema";
    }

    @Override
    protected String getCatalogElementName() {
        return "catalog";
    }

    @Override
    protected String getUniqueConstraintElementName() {
        return "uniqueConstraints";
    }

    @Override
    public ListIterable<JoinColumnAnnotation> getJoinColumns() {
        return IterableTools.cloneLive(this.joinColumns);
    }

    @Override
    public int getJoinColumnsSize() {
        return this.joinColumns.size();
    }

    @Override
    public JoinColumnAnnotation joinColumnAt(int index) {
        return this.joinColumns.get(index);
    }

    @Override
    public JoinColumnAnnotation addJoinColumn(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveJoinColumn(int targetIndex, int sourceIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeJoinColumn(int index) {
        throw new UnsupportedOperationException();
    }

    private Vector<JoinColumnAnnotation> buildJoinColumns() {
        Object[] jdtJoinColumns = this.getJdtMemberValues("joinColumns");
        Vector<JoinColumnAnnotation> result = new Vector<JoinColumnAnnotation>(jdtJoinColumns.length);
        Object[] objectArray = jdtJoinColumns;
        int n = jdtJoinColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Object jdtJoinColumn = objectArray[n2];
            result.add(new BinaryJoinColumnAnnotation((JavaResourceModel)this, (IAnnotation)jdtJoinColumn));
            ++n2;
        }
        return result;
    }

    private void updateJoinColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterable<JoinColumnAnnotation> getInverseJoinColumns() {
        return IterableTools.cloneLive(this.inverseJoinColumns);
    }

    @Override
    public int getInverseJoinColumnsSize() {
        return this.inverseJoinColumns.size();
    }

    @Override
    public JoinColumnAnnotation inverseJoinColumnAt(int index) {
        return this.inverseJoinColumns.get(index);
    }

    @Override
    public JoinColumnAnnotation addInverseJoinColumn(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveInverseJoinColumn(int targetIndex, int sourceIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeInverseJoinColumn(int index) {
        throw new UnsupportedOperationException();
    }

    private Vector<JoinColumnAnnotation> buildInverseJoinColumns() {
        Object[] jdtJoinColumns = this.getJdtMemberValues("inverseJoinColumns");
        Vector<JoinColumnAnnotation> result = new Vector<JoinColumnAnnotation>(jdtJoinColumns.length);
        Object[] objectArray = jdtJoinColumns;
        int n = jdtJoinColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Object jdtJoinColumn = objectArray[n2];
            result.add(new BinaryJoinColumnAnnotation((JavaResourceModel)this, (IAnnotation)jdtJoinColumn));
            ++n2;
        }
        return result;
    }

    private void updateInverseJoinColumns() {
        throw new UnsupportedOperationException();
    }
}

