/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.ui.internal.facet;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jst.jsf.facelet.core.internal.facet.ChangeActionType;
import org.eclipse.jst.jsf.facelet.core.internal.facet.FacetChangeModel;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.project.facet.ui.AbstractFacetWizardPage;

public abstract class FaceletChangePage
extends AbstractFacetWizardPage {
    private Button _chgDefaultSuffix;
    private Button _chgViewHandler;
    private Button _chgConfigureListener;
    private Button _chgWebappLifecycleListener;
    private DataBindingContext _bindingContext;
    private FacetChangeModel _dataModel;

    public FaceletChangePage(String name) {
        super(name);
    }

    public void setConfig(Object config) {
        this._dataModel = (FacetChangeModel)config;
    }

    protected String getTextForChangeType() {
        ChangeActionType actionType = this._dataModel.getChangeActionType();
        switch (actionType) {
            case ADD: {
                return "Add";
            }
            case REMOVE: {
                return "Remove";
            }
        }
        return "*ERROR*";
    }

    private void initDefaultSuffixButton(Composite parent) {
        this._chgDefaultSuffix = new Button(parent, 32);
        this._chgDefaultSuffix.setText(String.valueOf(this.getTextForChangeType()) + " '.xhtml' DEFAULT_SUFFIX parameter");
        this._chgDefaultSuffix.setSelection(this._dataModel.isChgDefaultSuffix());
        this._chgDefaultSuffix.setLayoutData((Object)new RowData());
        IObservableValue modelObservable = BeansObservables.observeValue((Object)this._dataModel, (String)"chgDefaultSuffix");
        this._bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._chgDefaultSuffix), modelObservable, null, null);
    }

    private void initViewHandlerButton(Composite parent) {
        this._chgViewHandler = new Button(parent, 32);
        this._chgViewHandler.setText(String.valueOf(this.getTextForChangeType()) + " Facelet view handler");
        this._chgViewHandler.setSelection(this._dataModel.isChgViewHandler());
        this._chgViewHandler.setLayoutData((Object)new RowData());
        IObservableValue modelObservable = BeansObservables.observeValue((Object)this._dataModel, (String)"chgViewHandler");
        this._bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._chgViewHandler), modelObservable, null, null);
    }

    private void initConfigureListener(Composite parent) {
        this._chgConfigureListener = new Button(parent, 32);
        this._chgConfigureListener.setText(String.valueOf(this.getTextForChangeType()) + " configure listener (needed by some Tomcat containers)");
        this._chgConfigureListener.setSelection(this._dataModel.isChgConfigureListener());
        this._chgConfigureListener.setLayoutData((Object)new RowData());
        IObservableValue modelObservable = BeansObservables.observeValue((Object)this._dataModel, (String)"chgConfigureListener");
        this._bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._chgConfigureListener), modelObservable, null, null);
    }

    private void initWebappLifecycleListener(Composite parent) {
        this._chgWebappLifecycleListener = new Button(parent, 32);
        this._chgWebappLifecycleListener.setText(String.valueOf(this.getTextForChangeType()) + " web application lifecycle listener (needed by some Tomcat containers)");
        this._chgWebappLifecycleListener.setSelection(this._dataModel.isChgConfigureListener());
        this._chgWebappLifecycleListener.setLayoutData((Object)new RowData());
        IObservableValue modelObservable = BeansObservables.observeValue((Object)this._dataModel, (String)"chgWebAppLifecycleListener");
        this._bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._chgWebappLifecycleListener), modelObservable, null, null);
    }

    public void createControl(Composite parent) {
        this.setTitle("Facelet");
        this.setMessage("Configure Facelet settings");
        this._bindingContext = new DataBindingContext();
        Composite control = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        control.setLayout((Layout)rowLayout);
        Group webXMLGroup = new Group(control, 0);
        webXMLGroup.setLayout((Layout)rowLayout);
        webXMLGroup.setText("Deployment Descriptor (web.xml) Configuration");
        this.initDefaultSuffixButton((Composite)webXMLGroup);
        this.initConfigureListener((Composite)webXMLGroup);
        this.initWebappLifecycleListener((Composite)webXMLGroup);
        Group facesConfigGroup = new Group(control, 0);
        facesConfigGroup.setLayout((Layout)rowLayout);
        facesConfigGroup.setText("Application (faces-config.xml) Configuration");
        this.initViewHandlerButton((Composite)facesConfigGroup);
        this.setControl((Control)control);
    }
}

