/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.model.edit.pom.translators;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.m2e.model.edit.pom.translators.SSESyncResource;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class TranslatorAdapter
implements INodeAdapter {
    protected SSESyncResource resource;
    protected Element node;

    public TranslatorAdapter(SSESyncResource resource) {
        this.resource = resource;
    }

    protected static String getElementText(Element e) {
        StringBuilder ret = new StringBuilder();
        NodeList children = e.getChildNodes();
        int nChildren = children.getLength();
        int i = 0;
        while (i < nChildren) {
            Node child = children.item(i);
            if (child instanceof Text) {
                ret.append(((Text)child).getData());
            }
            ++i;
        }
        return ret.toString().trim();
    }

    public abstract void load();

    public abstract void save();

    public abstract void update(Object var1, Object var2, int var3);

    protected int namedIndexOf(Element parentNode, Element element) {
        int ret = 0;
        NodeList children = parentNode.getChildNodes();
        int nChildren = children.getLength();
        int i = 0;
        while (i < nChildren) {
            Element e;
            Node child = children.item(i);
            if (child instanceof Element && (e = (Element)child).getLocalName().equals(element.getLocalName())) {
                if (e == element) {
                    return ret;
                }
                ++ret;
            }
            ++i;
        }
        return -1;
    }

    protected int absoluteIndexOf(Element parentNode, Element element) {
        int ret = 0;
        NodeList children = parentNode.getChildNodes();
        int nChildren = children.getLength();
        int i = 0;
        while (i < nChildren) {
            Element e;
            Node child = children.item(i);
            if (child instanceof Element && (e = (Element)child).getLocalName().equals(element.getLocalName())) {
                if (e == element) {
                    return ret;
                }
                ++ret;
            }
            ++i;
        }
        return -1;
    }

    protected Element getFirstChildWithName(Element parent, String name) {
        return this.getNthChildWithName(parent, name, 0);
    }

    protected Element getNthChildWithName(Element parent, String name, int n) {
        int matchCount = 0;
        NodeList children = parent.getChildNodes();
        int nChildren = children.getLength();
        int i = 0;
        while (i < nChildren) {
            Element e;
            Node child = children.item(i);
            if (child instanceof Element && ((e = (Element)child).getTagName().equals(name) || "*".equals(name))) {
                if (matchCount == n) {
                    return e;
                }
                ++matchCount;
            }
            ++i;
        }
        return null;
    }

    public Element getNode() {
        return this.node;
    }

    public void setNode(Element node) {
        this.node = node;
    }

    protected void formatNode(Element element) {
        this.createWSBefore(element);
        this.createWSAfter(element);
    }

    protected void createWSBefore(Element element) {
        try {
            String indent;
            IStructuredDocument doc = ((IDOMNode)element).getStructuredDocument();
            int nodeStartOff = ((IDOMNode)element).getStartOffset();
            StringBuilder betweenText = new StringBuilder();
            int i = nodeStartOff - 1;
            while (i > -1) {
                char next = doc.getChar(i);
                if (next == '>') break;
                betweenText.insert(0, next);
                --i;
            }
            int origLen = betweenText.length();
            int nlIndex = betweenText.lastIndexOf("\n");
            if (nlIndex == -1) {
                String nl = this.getNewlineString();
                betweenText.insert(0, nl);
                nlIndex = nl.length() - 1;
            }
            if (!(indent = this.getIndentForNode(element)).equals(betweenText.substring(nlIndex + 1))) {
                betweenText.replace(nlIndex + 1, betweenText.length(), indent);
            }
            if (origLen > 0) {
                doc.replaceText((Object)this, i + 1, origLen, betweenText.toString());
            } else {
                Text t = element.getOwnerDocument().createTextNode(betweenText.toString());
                element.getParentNode().insertBefore(t, element);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void createWSAfter(Element element) {
        try {
            IStructuredDocument doc = ((IDOMNode)element).getStructuredDocument();
            int nodeEndOff = ((IDOMNode)element).getEndOffset();
            StringBuilder betweenText = new StringBuilder();
            int i = nodeEndOff;
            while (i < doc.getLength()) {
                char next = doc.getChar(i);
                if (next == '<') break;
                betweenText.append(next);
                ++i;
            }
            int origLen = betweenText.length();
            int nlIndex = betweenText.lastIndexOf("\n");
            if (nlIndex == -1) {
                String nl = this.getNewlineString();
                betweenText.insert(0, nl);
                nlIndex = nl.length() - 1;
            }
            Node refNode = element.getNextSibling();
            while (refNode != null && !(refNode instanceof Element)) {
                refNode = refNode.getNextSibling();
            }
            String indent = "";
            indent = refNode == null ? this.getIndentBeforeStartTag(element.getParentNode()) : this.getIndentForNode((Element)refNode);
            if (!indent.equals(betweenText.substring(nlIndex + 1))) {
                betweenText.replace(nlIndex + 1, betweenText.length(), indent);
            }
            if (origLen > 0) {
                doc.replaceText((Object)this, nodeEndOff, origLen, betweenText.toString());
            } else {
                Text t = element.getOwnerDocument().createTextNode(betweenText.toString());
                if (refNode == null) {
                    element.getParentNode().appendChild(t);
                } else {
                    element.getParentNode().insertBefore(t, refNode);
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void removeChildElement(Element e) {
        IStructuredDocument doc = ((IDOMNode)e).getStructuredDocument();
        int nodeStartOff = ((IDOMNode)e).getStartOffset();
        int nodeEndOff = ((IDOMNode)e).getEndOffset();
        int i = nodeStartOff - 1;
        while (i > 0) {
            char c = ' ';
            try {
                c = doc.getChar(i);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (Character.isWhitespace(c)) {
                --i;
            }
            if (c != 10) continue;
            if (i <= 0) break;
            try {
                c = doc.getChar(i);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (c != 13) break;
            --i;
            break;
        }
        doc.replaceText((Object)this, i + 1, nodeEndOff - i - 1, null);
    }

    private String getIndentForNode(Element node) {
        String ret = null;
        Node prev = node.getPreviousSibling();
        while (prev != null) {
            if (prev instanceof Element) {
                ret = this.getIndentBeforeStartTag(prev);
                break;
            }
            prev = prev.getPreviousSibling();
        }
        if (ret == null) {
            ret = String.valueOf(this.getIndentBeforeStartTag(node.getParentNode())) + "\t";
        }
        return ret;
    }

    private String getIndentBeforeStartTag(Node node) {
        StringBuilder builder = new StringBuilder(100);
        IStructuredDocument doc = ((IDOMNode)node).getStructuredDocument();
        int nodeStartOff = ((IDOMNode)node).getStartOffset();
        int i = nodeStartOff - 1;
        while (i > 0) {
            char c = ' ';
            try {
                c = doc.getChar(i);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (!Character.isWhitespace(c) || c == 13 || c == 10) break;
            builder.insert(0, c);
            --i;
        }
        return builder.toString();
    }

    private String getNewlineString() {
        return ((IDOMNode)this.node).getStructuredDocument().getLineDelimiter();
    }
}

