/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.ui.executionviewer.view;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.m2m.atl.profiler.model.Context;
import org.eclipse.m2m.atl.profiler.model.ExecutionError;
import org.eclipse.m2m.atl.profiler.model.ProfilingInstruction;
import org.eclipse.m2m.atl.profiler.model.ProfilingOperation;
import org.eclipse.m2m.atl.profiler.ui.executionviewer.view.ExecutionView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ExecutionViewLabelProvider
extends AdapterFactoryLabelProvider {
    public ExecutionViewLabelProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String getText(Object object) {
        String txt = " ? ";
        if (object instanceof ProfilingInstruction || object instanceof ProfilingOperation) {
            ProfilingInstruction pi = (ProfilingInstruction)object;
            txt = "[" + pi.getInstructionID() + "] " + pi.getContent();
            if (pi.getContent().equals("__resolve__")) {
                ProfilingOperation po = (ProfilingOperation)pi;
                if (ExecutionView.isShowResolvContextInlabel()) {
                    txt = String.valueOf(txt) + " => ";
                    for (Context c : po.getContext()) {
                        txt = String.valueOf(txt) + c.getContent() + " ;";
                    }
                }
            }
        }
        if (object instanceof Context) {
            Context c = (Context)object;
            txt = "Context :: " + c.getContent();
        }
        if (object instanceof ExecutionError) {
            ExecutionError error = (ExecutionError)object;
            txt = error.getMessage();
        }
        return txt;
    }

    public Image getImage(Object object) {
        if (object instanceof ProfilingOperation) {
            ProfilingOperation pop = (ProfilingOperation)object;
            if (pop.isHasError()) {
                return this.getSystemErrorIcon();
            }
            return super.getImage(object);
        }
        if (object instanceof ExecutionError) {
            return this.getSystemErrorIcon();
        }
        return super.getImage(object);
    }

    private Image getSystemErrorIcon() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        return display.getSystemImage(1);
    }
}

