/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.serializer.SerializationBuilder;
import org.eclipse.ocl.examples.xtext.serializer.UserModelAnalysis;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.impl.Serializer;
import org.eclipse.xtext.util.ReplaceRegion;

public class DeclarativeSerializer
extends Serializer {
    @Inject
    private @NonNull UserModelAnalysis modelAnalysis;
    @Inject
    private @NonNull SerializationBuilder serializationBuilder;

    public void serialize(EObject eObject, Writer writer, SaveOptions options) throws IOException {
        Preconditions.checkNotNull((Object)eObject, (Object)"eObject must not be null.");
        Preconditions.checkNotNull((Object)writer, (Object)"writer must not be null.");
        Preconditions.checkNotNull((Object)options, (Object)"options must not be null.");
        this.modelAnalysis.analyze(eObject);
        this.modelAnalysis.serialize(this.serializationBuilder, eObject, null);
        this.serializationBuilder.close();
        String serializedOutput = this.serializationBuilder.toString();
        writer.append(serializedOutput);
        writer.flush();
        Iterable<@NonNull String> errors = this.serializationBuilder.getErrors();
        if (errors != null) {
            StringBuilder s = new StringBuilder();
            s.append("Failed to serialize '" + EcoreUtil.getURI((EObject)eObject) + "'");
            for (String error : errors) {
                s.append("\n\t");
                s.append(error);
            }
            throw new IOException(s.toString());
        }
    }

    public String serialize(EObject obj) {
        return super.serialize(obj);
    }

    protected void serialize(EObject semanticObject, EObject context, ISequenceAcceptor tokens, ISerializationDiagnostic.Acceptor errors) {
        super.serialize(semanticObject, context, tokens, errors);
    }

    protected void serialize(ISerializationContext context, EObject semanticObject, ISequenceAcceptor tokens, ISerializationDiagnostic.Acceptor errors) {
        super.serialize(context, semanticObject, tokens, errors);
    }

    protected void serialize(EObject obj, ITokenStream tokenStream, SaveOptions options) throws IOException {
        super.serialize(obj, tokenStream, options);
    }

    public ITextRegionAccess serializeToRegions(EObject obj) {
        return super.serializeToRegions(obj);
    }

    protected void serialize(EObject obj, Appendable appendable, SaveOptions options) throws IOException {
        super.serialize(obj, appendable, options);
    }

    public String serialize(EObject obj, SaveOptions options) {
        return super.serialize(obj, options);
    }

    public ReplaceRegion serializeReplacement(EObject obj, SaveOptions options) {
        return super.serializeReplacement(obj, options);
    }
}

