/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ecore.es2as;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.library.JavaCompareToOperation;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.OppositePropertyDetails;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class Ecore2ASReferenceSwitch
extends EcoreSwitch<Object> {
    @Deprecated
    public static final String PROPERTY_OPPOSITE_ROLE_NAME_KEY = "Property.oppositeRoleName";
    @Deprecated
    public static final Object PROPERTY_OPPOSITE_ROLE_UNIQUE_KEY = OppositePropertyDetails.PROPERTY_OPPOSITE_ROLE_UNIQUE_KEY;
    @Deprecated
    public static final Object PROPERTY_OPPOSITE_ROLE_ORDERED_KEY = OppositePropertyDetails.PROPERTY_OPPOSITE_ROLE_ORDERED_KEY;
    @Deprecated
    public static final Object PROPERTY_OPPOSITE_ROLE_LOWER_KEY = OppositePropertyDetails.PROPERTY_OPPOSITE_ROLE_LOWER_KEY;
    @Deprecated
    public static final Object PROPERTY_OPPOSITE_ROLE_UPPER_KEY = OppositePropertyDetails.PROPERTY_OPPOSITE_ROLE_UPPER_KEY;
    protected final @NonNull Ecore2AS converter;
    protected final @NonNull PivotMetamodelManager metamodelManager;
    protected final @NonNull StandardLibraryInternal standardLibrary;
    private final @NonNull Property oclInvalidProperty;

    public Ecore2ASReferenceSwitch(@NonNull Ecore2AS converter) {
        this.converter = converter;
        this.metamodelManager = converter.getMetamodelManager();
        this.standardLibrary = this.metamodelManager.getStandardLibrary();
        this.oclInvalidProperty = this.standardLibrary.getOclInvalidProperty();
    }

    public Object caseEAnnotation(EAnnotation eAnnotation) {
        assert (eAnnotation != null);
        Annotation pivotElement = this.converter.getCreated(Annotation.class, (EObject)eAnnotation);
        if (pivotElement == null) {
            return this;
        }
        this.doSwitchAll(Element.class, ClassUtil.nullFree(pivotElement.getReferences()), (List<? extends EObject>)eAnnotation.getReferences());
        return pivotElement;
    }

    public Object caseEClass(EClass eClass) {
        assert (eClass != null);
        Class pivotElement = this.converter.getCreated(Class.class, (EObject)eClass);
        if (pivotElement == null) {
            return this;
        }
        this.doSwitchAll(Class.class, ClassUtil.nullFree(pivotElement.getSuperClasses()), (List<? extends EObject>)eClass.getEGenericSuperTypes());
        if (pivotElement.getSuperClasses().isEmpty() && !(pivotElement instanceof AnyType)) {
            Class oclElementType = this.standardLibrary.getOclElementType();
            pivotElement.getSuperClasses().add(oclElementType);
        }
        return pivotElement;
    }

    public Object caseEDataType(EDataType eDataType) {
        assert (eDataType != null);
        DataType pivotElement = this.converter.getCreated(DataType.class, (EObject)eDataType);
        if (pivotElement == null) {
            return this;
        }
        this.doCompareToOperation(pivotElement, eDataType);
        return pivotElement;
    }

    public Object caseEEnum(EEnum eEnum) {
        return null;
    }

    public Object caseEOperation(EOperation eOperation) {
        assert (eOperation != null);
        if (this.converter.isInvariant(eOperation)) {
            Constraint asConstraint = this.converter.getCreated(Constraint.class, (EObject)eOperation);
            if (asConstraint == null) {
                return this;
            }
            EAnnotation redefinesAnnotation = eOperation.getEAnnotation("redefines");
            if (redefinesAnnotation != null) {
                for (EObject eReference : redefinesAnnotation.getReferences()) {
                    NamedElement redefinedConstraint;
                    if (eReference == null || !this.checkProxy(eReference) || !((redefinedConstraint = this.converter.getCreated(NamedElement.class, eReference)) instanceof Constraint)) continue;
                    asConstraint.getRedefinedConstraints().add((Constraint)redefinedConstraint);
                }
            }
            return asConstraint;
        }
        TypedElement pivotElement = this.caseETypedElement((ETypedElement)eOperation);
        if (!(pivotElement instanceof Operation)) {
            return this;
        }
        Operation asOperation = (Operation)pivotElement;
        EAnnotation redefinesAnnotation = eOperation.getEAnnotation("redefines");
        if (redefinesAnnotation != null) {
            for (EObject eReference : redefinesAnnotation.getReferences()) {
                NamedElement redefinedOperation;
                if (eReference == null || !this.checkProxy(eReference) || !((redefinedOperation = this.converter.getCreated(NamedElement.class, eReference)) instanceof Operation)) continue;
                asOperation.getRedefinedOperations().add((Operation)redefinedOperation);
            }
        }
        this.doSwitchAll(Type.class, ClassUtil.nullFree(asOperation.getRaisedExceptions()), (List<? extends EObject>)eOperation.getEGenericExceptions());
        return asOperation;
    }

    public Object caseEReference(EReference eReference) {
        assert (eReference != null);
        Property asProperty = this.caseEStructuralFeature((EStructuralFeature)eReference);
        if (asProperty == this.oclInvalidProperty) {
            return this;
        }
        this.doSwitchAll(Property.class, ClassUtil.nullFree(asProperty.getKeys()), (List<? extends EObject>)eReference.getEKeys());
        Property oppositeProperty = null;
        EReference eOpposite = eReference.getEOpposite();
        if (eOpposite != null) {
            oppositeProperty = this.converter.getCreated(Property.class, (EObject)eOpposite);
            asProperty.setOpposite(oppositeProperty);
        } else {
            OppositePropertyDetails oppositePropertyDetails = OppositePropertyDetails.createFromEReference(eReference);
            if (oppositePropertyDetails != null) {
                this.metamodelManager.createImplicitOppositeProperty(asProperty, oppositePropertyDetails.getName(), oppositePropertyDetails.isOrdered(), oppositePropertyDetails.isUnique(), oppositePropertyDetails.getLower(), oppositePropertyDetails.getUpper());
            } else {
                asProperty.setOpposite(null);
            }
        }
        return asProperty;
    }

    public @NonNull Property caseEStructuralFeature(EStructuralFeature eStructuralFeature) {
        EAnnotation eAnnotation;
        EAnnotation duplicatesAnnotation;
        EObject eContainer;
        assert (eStructuralFeature != null);
        TypedElement pivotElement = this.caseETypedElement((ETypedElement)eStructuralFeature);
        if (pivotElement == this.oclInvalidProperty) {
            return this.oclInvalidProperty;
        }
        Property asProperty = (Property)pivotElement;
        EAnnotation redefinesAnnotation = eStructuralFeature.getEAnnotation("redefines");
        if (redefinesAnnotation != null) {
            for (EObject eReference : redefinesAnnotation.getReferences()) {
                if (eReference == null || !this.checkProxy(eReference)) continue;
                Property redefinedProperty = this.converter.getCreated(Property.class, eReference);
                asProperty.getRedefinedProperties().add(redefinedProperty);
            }
        }
        if ((eContainer = eStructuralFeature.eContainer()) instanceof EAnnotation && "duplicates".equals((duplicatesAnnotation = (EAnnotation)eContainer).getSource()) && (eAnnotation = duplicatesAnnotation.getEAnnotation(eStructuralFeature.getName())) != null) {
            String newLowerBound = null;
            Boolean newOrdered = null;
            Boolean newUnique = null;
            String newUpperBound = null;
            Type newType = null;
            boolean changedType = false;
            EMap details = eAnnotation.getDetails();
            for (String key : details.keySet()) {
                EClassifier eClassifier;
                EPackage ePackage;
                Object value = details.get((Object)key);
                if (value == null) continue;
                if ("lowerBound".equals(key)) {
                    newLowerBound = value.toString();
                    changedType = true;
                    continue;
                }
                if ("ordered".equals(key)) {
                    newOrdered = Boolean.valueOf(value.toString());
                    changedType = true;
                    continue;
                }
                if ("unique".equals(key)) {
                    newUnique = Boolean.valueOf(value.toString());
                    changedType = true;
                    continue;
                }
                if ("upperBound".equals(key)) {
                    newUpperBound = value.toString();
                    changedType = true;
                    continue;
                }
                if (!"eType".equals(key)) continue;
                String[] path = value.toString().split("::");
                EObject eRoot = EcoreUtil.getRootContainer((EObject)eStructuralFeature);
                int iSize = path.length;
                if (iSize < 2 || !(eRoot instanceof EPackage) || !path[0].equals((ePackage = (EPackage)eRoot).getName())) continue;
                int i = 1;
                while (ePackage != null && i < iSize - 1) {
                    ePackage = (EPackage)NameUtil.getENamedElement(ePackage.getESubpackages(), path[i]);
                    ++i;
                }
                if (ePackage == null || (eClassifier = (EClassifier)NameUtil.getENamedElement(ePackage.getEClassifiers(), path[iSize - 1])) == null) continue;
                newType = this.converter.getASType((EObject)eClassifier);
                changedType = true;
            }
            if (changedType) {
                boolean isRequired;
                Type pivotType;
                Type type;
                UnlimitedNaturalValue oldUpperValue;
                boolean oldUnique;
                boolean oldOrdered;
                IntegerValue oldLowerValue;
                Type oldType = asProperty.getType();
                if (oldType instanceof CollectionType) {
                    CollectionType oldCollectionType = (CollectionType)oldType;
                    oldType = oldCollectionType.getElementType();
                    oldLowerValue = oldCollectionType.getLowerValue();
                    oldOrdered = oldCollectionType.isOrdered();
                    oldUnique = oldCollectionType.isUnique();
                    oldUpperValue = oldCollectionType.getUpperValue();
                } else {
                    oldLowerValue = asProperty.isIsRequired() ? ValueUtil.ONE_VALUE : ValueUtil.ZERO_VALUE;
                    oldOrdered = false;
                    oldUnique = false;
                    oldUpperValue = ValueUtil.UNLIMITED_ONE_VALUE;
                }
                boolean isOrdered = newOrdered != null ? newOrdered : oldOrdered;
                IntegerValue lowerValue = newLowerBound != null ? ValueUtil.integerValueOf(newLowerBound) : oldLowerValue;
                boolean isUnique = newUnique != null ? newUnique : oldUnique;
                UnlimitedNaturalValue upperValue = newUpperBound != null ? ValueUtil.unlimitedNaturalValueOf(newUpperBound) : oldUpperValue;
                Type type2 = type = newType != null ? newType : oldType;
                if (type != null) {
                    pivotType = type;
                    if (upperValue.equals(ValueUtil.ONE_VALUE)) {
                        isRequired = lowerValue.equals(ValueUtil.ONE_VALUE);
                    } else {
                        isRequired = true;
                        pivotType = this.metamodelManager.getCollectionType(isOrdered, isUnique, pivotType, false, lowerValue, upperValue);
                    }
                } else {
                    isRequired = false;
                    pivotType = this.standardLibrary.getOclVoidType();
                }
                asProperty.setType(pivotType);
                asProperty.setIsRequired(isRequired);
            }
        }
        String defaultValueLiteral = null;
        if (eStructuralFeature.eIsSet((EStructuralFeature)EcorePackage.Literals.ESTRUCTURAL_FEATURE__DEFAULT_VALUE_LITERAL)) {
            defaultValueLiteral = eStructuralFeature.getDefaultValueLiteral();
        }
        asProperty.setDefaultValueString(defaultValueLiteral);
        return asProperty;
    }

    public @NonNull TypedElement caseETypedElement(ETypedElement eTypedElement) {
        boolean isRequired;
        Type pivotType;
        assert (eTypedElement != null);
        TypedElement pivotElement = this.converter.getCreated(TypedElement.class, (EObject)eTypedElement);
        if (pivotElement == null) {
            return this.oclInvalidProperty;
        }
        EGenericType eType = eTypedElement.getEGenericType();
        if (eType != null) {
            EClassifier eClassifier = eType.getEClassifier();
            int lower = eTypedElement.getLowerBound();
            int upper = eTypedElement.getUpperBound();
            if (lower == 0 && upper == -1 && this.converter.isEcoreOnlyEntryClass(eClassifier)) {
                pivotType = this.converter.getCreated(Type.class, (EObject)eType);
                assert (this.converter.isEntryClass(eClassifier));
                assert (pivotType == null);
                assert (eClassifier != null);
                isRequired = true;
                pivotType = this.getEcoreOnlyEntryClassMapType((EClass)eClassifier);
            } else {
                pivotType = this.converter.getASType((EObject)eType);
                assert (pivotType != null);
                if (upper == 1) {
                    if (lower == 0) {
                        java.lang.Class instanceClass;
                        if (this.converter.cannotBeOptional(eTypedElement)) {
                            lower = 1;
                            Ecore2AS.NOT_OPTIONAL.println(String.valueOf(NameUtil.qualifiedNameFor(eTypedElement)) + " converted to not-optional");
                        } else if (eClassifier instanceof EDataType && (instanceClass = ((EDataType)eClassifier).getInstanceClass()) == Boolean.class && pivotType.getESObject() == EcorePackage.Literals.EBOOLEAN_OBJECT) {
                            pivotType = this.standardLibrary.getBooleanType();
                        }
                    }
                    isRequired = lower == 1;
                } else {
                    isRequired = true;
                    if (this.converter.isEntryClass(eClassifier)) {
                        Iterable<@NonNull Property> ownedProperties = PivotUtil.getOwnedProperties((Class)pivotType);
                        Property keyProperty = ClassUtil.nonNullState(NameUtil.getNameable(ownedProperties, "key"));
                        Property valueProperty = ClassUtil.nonNullState(NameUtil.getNameable(ownedProperties, "value"));
                        if (keyProperty.getType() == null) {
                            return this.oclInvalidProperty;
                        }
                        if (valueProperty.getType() == null) {
                            return this.oclInvalidProperty;
                        }
                        pivotType = this.metamodelManager.getMapType((Class)pivotType);
                    } else {
                        boolean isNullFree = Ecore2AS.isNullFree(eTypedElement);
                        boolean isOrdered = eTypedElement.isOrdered();
                        boolean isUnique = eTypedElement.isUnique();
                        IntegerValue lowerValue = ValueUtil.integerValueOf(lower);
                        UnlimitedNaturalValue upperValue = upper != -1 ? ValueUtil.unlimitedNaturalValueOf(upper) : ValueUtil.UNLIMITED_VALUE;
                        pivotType = this.metamodelManager.getCollectionType(isOrdered, isUnique, pivotType, isNullFree, lowerValue, upperValue);
                    }
                }
            }
        } else {
            isRequired = false;
            pivotType = this.standardLibrary.getOclVoidType();
        }
        pivotElement.setType(pivotType);
        pivotElement.setIsRequired(isRequired);
        return pivotElement;
    }

    public Object caseETypeParameter(ETypeParameter eTypeParameter) {
        assert (eTypeParameter != null);
        TemplateParameter pivotElement = this.converter.getCreated(TemplateParameter.class, (EObject)eTypeParameter);
        if (pivotElement == null) {
            return this;
        }
        this.doSwitchAll(Class.class, ClassUtil.nullFree(pivotElement.getConstrainingClasses()), (List<? extends EObject>)eTypeParameter.getEBounds());
        return pivotElement;
    }

    protected boolean checkProxy(@NonNull EObject eReference) {
        if (!eReference.eIsProxy()) {
            return true;
        }
        this.converter.error("Unresolved proxy: " + EcoreUtil.getURI((EObject)eReference));
        return false;
    }

    protected void doCompareToOperation(@NonNull DataType pivotElement, @NonNull EDataType eDataType) {
        java.lang.Class instanceClass = eDataType.getInstanceClass();
        if (instanceClass != null) {
            try {
                Method declaredMethod = instanceClass.getDeclaredMethod("compareTo", instanceClass);
                if (declaredMethod != null) {
                    Operation operation = PivotFactory.eINSTANCE.createOperation();
                    operation.setName("compareTo");
                    operation.setImplementation(new JavaCompareToOperation(declaredMethod));
                    Parameter parameter = PivotFactory.eINSTANCE.createParameter();
                    parameter.setName("that");
                    parameter.setType(this.standardLibrary.getOclSelfType());
                    operation.getOwnedParameters().add(parameter);
                    operation.setType(this.standardLibrary.getIntegerType());
                    pivotElement.getOwnedOperations().add(operation);
                    pivotElement.getSuperClasses().add(this.standardLibrary.getOclComparableType());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object doInPackageSwitch(EObject eObject) {
        int classifierID = eObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public <T extends Element> void doSwitchAll(java.lang.Class<T> pivotClass, Collection<T> pivotElements, List<? extends EObject> eObjects) {
        java.lang.Class<T> pivotClass2 = pivotClass;
        for (EObject eObject : eObjects) {
            T pivotElement;
            if (eObject == null || !this.checkProxy(eObject) || (pivotElement = this.converter.getASElement(pivotClass2, eObject)) == null) continue;
            pivotElements.add(pivotElement);
        }
    }

    protected @Nullable Type getEcoreOnlyEntryClassMapType(@NonNull EClass eClass) {
        EStructuralFeature keyFeature = eClass.getEStructuralFeature("key");
        EStructuralFeature valueFeature = eClass.getEStructuralFeature("value");
        if (keyFeature == null) {
            this.converter.error("Missing 'key' feature for map '" + eClass.getName());
        } else if (valueFeature == null) {
            this.converter.error("Missing 'value' feature for map '" + eClass.getName());
        } else {
            EGenericType keyGenericType = keyFeature.getEGenericType();
            EGenericType valueGenericType = valueFeature.getEGenericType();
            if (keyGenericType == null) {
                this.converter.error("No 'key' EGenericType for map '" + eClass.getName());
            } else if (valueGenericType == null) {
                this.converter.error("No 'value' EGenericType for map '" + eClass.getName());
            } else {
                HashMap<@NonNull String, @NonNull Type> resolvedSpecializations = new HashMap<String, Type>();
                Type keyType = this.converter.resolveType(resolvedSpecializations, keyGenericType);
                Type valueType = this.converter.resolveType(resolvedSpecializations, valueGenericType);
                if (keyType != null && valueType != null) {
                    boolean keysAreNullFree = keyFeature.isRequired();
                    boolean valuesAreNullFree = valueFeature.isRequired();
                    Class mapMetatype = this.standardLibrary.getMapType();
                    return this.metamodelManager.getCompleteEnvironment().getMapType(mapMetatype, keyType, keysAreNullFree, valueType, valuesAreNullFree);
                }
            }
        }
        return null;
    }
}

