/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.IClassMemberContext;
import org.eclipse.php.internal.core.codeassist.strategies.ClassMembersStrategy;
import org.eclipse.php.internal.core.language.PHPMagicMethods;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class ClassMethodsStrategy
extends ClassMembersStrategy {
    public ClassMethodsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public ClassMethodsStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof IClassMemberContext) || !(context instanceof AbstractCompletionContext)) {
            return;
        }
        IClassMemberContext concreteContext = (IClassMemberContext)context;
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        CompletionRequestor requestor = abstractContext.getCompletionRequestor();
        String prefix = abstractContext.getPrefix().isEmpty() ? abstractContext.getPreviousWord() : abstractContext.getPrefix();
        boolean isParentCall = this.isParentCall(concreteContext);
        String suffix = this.getSuffix(abstractContext);
        ISourceRange replaceRange = null;
        replaceRange = suffix.equals("") ? this.getReplacementRange(concreteContext) : this.getReplacementRangeWithBraces(concreteContext);
        PHPVersion phpVersion = this.getCompanion().getPHPVersion();
        HashSet<String> magicMethods = new HashSet<String>();
        magicMethods.addAll(Arrays.asList(PHPMagicMethods.getMethods(phpVersion)));
        boolean exactName = requestor.isContextInformationMode();
        if (!exactName && this.getCompanion().getOffset() - 1 >= 0 && this.getCompanion().getDocument().getChar(this.getCompanion().getOffset() - 1) == '(') {
            exactName = true;
        }
        IType[] iTypeArray = concreteContext.getLhsTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                ITypeHierarchy hierarchy = this.getCompanion().getSuperTypeHierarchy(type, null);
                IMethod[] methods = isParentCall ? PHPModelUtils.getSuperTypeHierarchyMethod(type, hierarchy, prefix, exactName, null) : PHPModelUtils.getTypeHierarchyMethod(type, hierarchy, prefix, exactName, null);
                boolean inConstructor = this.isInConstructor(type, type.getMethods(), concreteContext);
                for (IMethod method : this.removeOverriddenElements(Arrays.asList(methods))) {
                    this.reportMethod(method, type, concreteContext, inConstructor, magicMethods, suffix, replaceRange, reporter);
                }
            }
            catch (CoreException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
    }

    protected void reportMethod(IMethod method, IType type, IClassMemberContext concreteContext, boolean inConstructor, Set<String> magicMethods, String suffix, ISourceRange replaceRange, ICompletionReporter reporter) throws ModelException {
        if ((!PHPModelUtils.isConstructor(method) || inConstructor && this.isSuperConstructor(method, type, concreteContext)) && !this.isFiltered((IMember)method, type, concreteContext)) {
            if (magicMethods.contains(method.getElementName())) {
                reporter.reportMethod(method, suffix, replaceRange, 12);
            } else {
                reporter.reportMethod(method, suffix, replaceRange, 8);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isInConstructor(IType type, IMethod[] methods, IClassMemberContext concreteContext) {
        try {
            int i = 0;
            while (true) {
                if (i >= methods.length) {
                    return false;
                }
                IMethod method = methods[i];
                if (PHPModelUtils.isConstructor(method) && method.getDeclaringType().equals(type)) {
                    ISourceRange constructorRange = method.getSourceRange();
                    if (this.getCompanion().getOffset() > constructorRange.getOffset() && this.getCompanion().getOffset() < constructorRange.getOffset() + constructorRange.getLength()) {
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (ModelException modelException) {}
        return false;
    }

    private boolean isSuperConstructor(IMethod method, IType type, IClassMemberContext context) {
        return PHPModelUtils.isConstructor(method) && context.getTriggerType() == IClassMemberContext.Trigger.CLASS && this.isParent(context) && !method.getDeclaringType().equals(type);
    }

    private boolean isParent(IClassMemberContext context) {
        return !this.isThisCall(context) && this.isParentCall(context) && this.isDirectParentCall(context);
    }

    @Override
    protected boolean showNonStaticMembers(IClassMemberContext context) {
        return super.showNonStaticMembers(context) || context.getTriggerType() == IClassMemberContext.Trigger.CLASS;
    }

    public String getSuffix(AbstractCompletionContext abstractContext) throws BadLocationException {
        IStructuredDocument document = this.getCompanion().getDocument();
        int offset = this.getCompanion().getOffset();
        while (document.getLength() > offset) {
            char ch = document.getChar(offset);
            if (ch == '(') break;
            if (ch == '\n') {
                return "()";
            }
            ++offset;
        }
        return "";
    }
}

