/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.CommentHandler;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class AddBlockCommentHandler
extends CommentHandler
implements IHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDocument document;
        Object o;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else if (editor != null && (o = editor.getAdapter(ITextEditor.class)) != null) {
            textEditor = (ITextEditor)o;
        }
        if (textEditor != null && (document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null) {
            ITextSelection textSelection = this.getCurrentSelection(textEditor);
            if (this.isMoreThanOneContextBlockSelected(document, textSelection)) {
                org.eclipse.wst.sse.ui.internal.handlers.AddBlockCommentHandler addBlockCommentHandlerWST = new org.eclipse.wst.sse.ui.internal.handlers.AddBlockCommentHandler();
                return addBlockCommentHandlerWST.execute(event);
            }
            if (textSelection.isEmpty()) {
                return null;
            }
            if (document instanceof IStructuredDocument) {
                int selectionOffset = textSelection.getOffset();
                IStructuredDocument sDoc = (IStructuredDocument)document;
                IStructuredDocumentRegion sdRegion = sDoc.getRegionAtCharacterOffset(selectionOffset);
                ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(selectionOffset);
                IStructuredDocumentRegion container = sdRegion;
                if (textRegion instanceof ITextRegionContainer) {
                    container = (ITextRegionContainer)textRegion;
                    textRegion = container.getRegionAtCharacterOffset(selectionOffset);
                }
                if (textRegion.getType() == "PHP_CONTENT") {
                    this.processAction(textEditor, document, textSelection);
                } else {
                    org.eclipse.wst.sse.ui.internal.handlers.AddBlockCommentHandler addBlockCommentHandlerWST = new org.eclipse.wst.sse.ui.internal.handlers.AddBlockCommentHandler();
                    return addBlockCommentHandlerWST.execute(event);
                }
            }
        }
        return null;
    }

    @Override
    void processAction(ITextEditor textEditor, IDocument document, ITextSelection textSelection) {
        int openCommentOffset = textSelection.getOffset();
        int closeCommentOffset = openCommentOffset + textSelection.getLength();
        if (textSelection.getLength() == 0) {
            return;
        }
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
        if (model != null) {
            try {
                model.beginRecording((Object)this, PHPUIMessages.AddBlockComment_tooltip);
                model.aboutToChangeModel();
                try {
                    try {
                        document.replace(closeCommentOffset, 0, "*/");
                        document.replace(openCommentOffset, 0, "/*");
                    }
                    catch (BadLocationException e) {
                        Logger.log(202, e.getMessage(), e);
                        model.changedModel();
                        model.endRecording((Object)this);
                    }
                }
                finally {
                    model.changedModel();
                    model.endRecording((Object)this);
                }
            }
            finally {
                model.releaseFromEdit();
            }
        }
    }
}

