/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPHP;
import org.eclipse.php.internal.ui.actions.Messages;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenCallHierarchyAction
extends SelectionDispatchAction {
    private PHPStructuredEditor fEditor;

    public OpenCallHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(CallHierarchyMessages.OpenCallHierarchyAction_label);
        this.setToolTipText(CallHierarchyMessages.OpenCallHierarchyAction_tooltip);
        this.setDescription(CallHierarchyMessages.OpenCallHierarchyAction_description);
    }

    public OpenCallHierarchyAction(PHPStructuredEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private boolean isEnabled(IStructuredSelection selection) {
        if (selection == null || selection.size() != 1) {
            return false;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof ElementImplForPHP) {
            return true;
        }
        if (!(firstElement instanceof IModelElement) && firstElement instanceof IAdaptable) {
            firstElement = ((IAdaptable)firstElement).getAdapter(IModelElement.class);
        }
        if (!(firstElement instanceof IModelElement)) {
            return false;
        }
        if (!(firstElement instanceof IModelElement)) {
            return false;
        }
        switch (((IModelElement)firstElement).getElementType()) {
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
            case 3: 
            case 5: 
            case 10: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public void run(ITextSelection selection) {
        ISourceModule input = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable((Shell)this.getShell(), (Object)input)) {
            return;
        }
        try {
            IModelElement enclosingMethod;
            IModelElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null) {
                return;
            }
            ArrayList<IModelElement> candidates = new ArrayList<IModelElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                IModelElement[] resolvedElements = CallHierarchyUI.getCandidates((Object)elements[i]);
                if (resolvedElements != null) {
                    candidates.addAll(Arrays.asList(resolvedElements));
                }
                ++i;
            }
            if (candidates.isEmpty() && (enclosingMethod = this.getEnclosingMethod((IModelElement)input, selection)) != null) {
                candidates.add(enclosingMethod);
            }
            this.run(candidates.toArray(new IModelElement[candidates.size()]));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)OpenCallHierarchyAction.getErrorDialogTitle(), (String)"");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private IModelElement getEnclosingMethod(IModelElement input, ITextSelection selection) {
        IModelElement enclosingElement = null;
        try {
            switch (input.getElementType()) {
                case 5: {
                    ISourceModule cu = (ISourceModule)input.getAncestor(5);
                    if (cu == null) break;
                    enclosingElement = cu.getElementAt(selection.getOffset());
                }
            }
            if (enclosingElement != null && enclosingElement.getElementType() == 9) {
                return enclosingElement;
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        if (selection instanceof ITextSelection) {
            this.run((ITextSelection)selection);
        } else {
            if (selection.size() != 1) {
                return;
            }
            Object input = selection.getFirstElement();
            if (!(input instanceof IModelElement)) {
                IStatus status = OpenCallHierarchyAction.createStatus(Messages.OpenCallHierarchyAction_0);
                ErrorDialog.openError((Shell)this.getShell(), (String)OpenCallHierarchyAction.getErrorDialogTitle(), (String)"", (IStatus)status);
                return;
            }
            IModelElement element = (IModelElement)input;
            if (!ActionUtil.isProcessable((Shell)this.getShell(), (Object)element)) {
                return;
            }
            ArrayList<IModelElement> result = new ArrayList<IModelElement>(1);
            IStatus status = OpenCallHierarchyAction.compileCandidates(result, element);
            if (status.isOK()) {
                this.run(result.toArray(new IModelElement[result.size()]));
            } else {
                this.openErrorDialog(status);
            }
        }
    }

    private int openErrorDialog(IStatus status) {
        String message = "";
        String dialogTitle = OpenCallHierarchyAction.getErrorDialogTitle();
        return ErrorDialog.openError((Shell)this.getShell(), (String)dialogTitle, (String)message, (IStatus)status);
    }

    private static String getErrorDialogTitle() {
        return "";
    }

    public void run(IModelElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        CallHierarchyUI.open((IModelElement[])elements, (IWorkbenchWindow)this.getSite().getWorkbenchWindow(), (String)this.getCallHierarchyID());
    }

    private static IStatus compileCandidates(List<IModelElement> result, IModelElement elem) {
        Status ok = new Status(0, DLTKUIPlugin.getPluginId(), 0, "", null);
        switch (elem.getElementType()) {
            case 9: {
                result.add(elem);
                return ok;
            }
        }
        return OpenCallHierarchyAction.createStatus("");
    }

    private static IStatus createStatus(String message) {
        return new Status(1, DLTKUIPlugin.getPluginId(), 10001, message, null);
    }

    public String getCallHierarchyID() {
        return "org.eclipse.dltk.callhierarchy.view";
    }
}

