/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.refactor.processors;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKFeatures;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.dltk.internal.corext.refactoring.participants.ScriptProcessors;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.dltk.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.dltk.internal.corext.refactoring.util.ModelElementUtil;
import org.eclipse.dltk.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.dltk.internal.corext.util.Resources;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.php.internal.ui.refactor.processors.DeleteChangeCreator;
import org.eclipse.php.internal.ui.refactor.processors.DeleteModifications;
import org.eclipse.php.internal.ui.refactor.processors.ReadOnlyResourceFinder;
import org.eclipse.php.internal.ui.refactor.processors.ReorgUtils;

public final class ScriptDeleteProcessor
extends DeleteProcessor
implements ICommentProvider {
    private boolean fWasCanceled;
    private Object[] fElements;
    private IResource[] fResources;
    private IModelElement[] fScriptElements;
    private IReorgQueries fDeleteQueries;
    private DeleteModifications fDeleteModifications;
    private String fComment;
    private Change fDeleteChange;
    private boolean fDeleteSubPackages;
    public static final String IDENTIFIER = "org.eclipse.dltk.ui.DeleteProcessor";

    public ScriptDeleteProcessor(Object[] elements) {
        this.fElements = elements;
        this.fResources = RefactoringAvailabilityTester.getResources((Object[])elements);
        this.fScriptElements = RefactoringAvailabilityTester.getScriptElements((Object[])elements);
        this.fDeleteSubPackages = false;
        this.fWasCanceled = false;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        if (this.fElements.length == 0) {
            return false;
        }
        if (this.fElements.length != this.fResources.length + this.fScriptElements.length) {
            return false;
        }
        int i = 0;
        while (i < this.fResources.length) {
            if (!RefactoringAvailabilityTester.isDeleteAvailable((IResource)this.fResources[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.fScriptElements.length) {
            if (!RefactoringAvailabilityTester.isDeleteAvailable((IModelElement)this.fScriptElements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean needsProgressMonitor() {
        if (this.fResources != null && this.fResources.length > 0) {
            return true;
        }
        if (this.fScriptElements != null) {
            int i = 0;
            while (i < this.fScriptElements.length) {
                int type = this.fScriptElements[i].getElementType();
                if (type <= 5) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.DeleteRefactoring_7;
    }

    public Object[] getElements() {
        return this.fElements;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return this.fDeleteModifications.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), shared);
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] jNatures = ScriptProcessors.computeAffectedNaturs((IModelElement[])this.fScriptElements);
        String[] rNatures = ResourceProcessors.computeAffectedNatures((IResource[])this.fResources);
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(jNatures));
        result.addAll(Arrays.asList(rNatures));
        return result.toArray(new String[result.size()]);
    }

    public void setDeleteSubPackages(boolean selection) {
        this.fDeleteSubPackages = selection;
    }

    public boolean getDeleteSubPackages() {
        return this.fDeleteSubPackages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSubPackagesToDelete() {
        try {
            int i = 0;
            while (true) {
                IScriptFolder scriptFolder;
                if (i >= this.fScriptElements.length) {
                    return false;
                }
                if (this.fScriptElements[i] instanceof IScriptFolder && !(scriptFolder = (IScriptFolder)this.fScriptElements[i]).isRootFolder() && scriptFolder.hasSubfolders()) {
                    return true;
                }
                ++i;
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return false;
    }

    public void setQueries(IReorgQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fDeleteQueries = queries;
    }

    public IModelElement[] getScriptElementsToDelete() {
        return this.fScriptElements;
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }

    public IResource[] getResourcesToDelete() {
        return this.fResources;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        Assert.isNotNull((Object)this.fDeleteQueries);
        RefactoringStatus result = new RefactoringStatus();
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync((IResource[])ReorgUtils.getNotLinked(this.fResources))));
        IResource[] javaResources = ReorgUtils.getResources(this.fScriptElements);
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync((IResource[])ReorgUtils.getNotLinked(javaResources))));
        int i = 0;
        while (i < this.fScriptElements.length) {
            ++i;
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.DeleteRefactoring_1, 1);
        try {
            this.fWasCanceled = false;
            RefactoringStatus result = new RefactoringStatus();
            this.recalculateElementsToDelete();
            this.checkDirtySourceModules(result);
            this.checkDirtyResources(result);
            this.fDeleteModifications = new DeleteModifications();
            this.fDeleteModifications.delete(this.fResources);
            this.fDeleteModifications.delete(this.fScriptElements);
            List<IResource> packageDeletes = this.fDeleteModifications.postProcess();
            TextChangeManager manager = new TextChangeManager();
            this.fDeleteChange = DeleteChangeCreator.createDeleteChange(manager, this.fResources, this.fScriptElements, this.getProcessorName(), packageDeletes);
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            this.fDeleteModifications.buildDelta(deltaFactory);
            IFile[] files = this.getBuildpathFiles();
            int i = 0;
            while (i < files.length) {
                deltaFactory.change(files[i]);
                ++i;
            }
            files = ResourceUtil.getFiles((ISourceModule[])manager.getAllSourceModules());
            i = 0;
            while (i < files.length) {
                deltaFactory.change(files[i]);
                ++i;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        catch (OperationCanceledException e) {
            this.fWasCanceled = true;
            throw e;
        }
        catch (ModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
        finally {
            pm.done();
        }
    }

    private void checkDirtySourceModules(RefactoringStatus result) throws CoreException {
        if (this.fScriptElements == null || this.fScriptElements.length == 0) {
            return;
        }
        int je = 0;
        while (je < this.fScriptElements.length) {
            IModelElement element = this.fScriptElements[je];
            if (element instanceof ISourceModule) {
                this.checkDirtySourceModule(result, (ISourceModule)element);
            } else if (element instanceof IScriptFolder) {
                ISourceModule[] units = ((IScriptFolder)element).getSourceModules();
                int u = 0;
                while (u < units.length) {
                    this.checkDirtySourceModule(result, units[u]);
                    ++u;
                }
            }
            ++je;
        }
    }

    private void checkDirtySourceModule(RefactoringStatus result, ISourceModule cunit) {
        IResource resource = cunit.getResource();
        if (resource == null || resource.getType() != 1) {
            return;
        }
        this.checkDirtyFile(result, (IFile)resource);
    }

    private void checkDirtyResources(final RefactoringStatus result) throws CoreException {
        int i = 0;
        while (i < this.fResources.length) {
            IResource resource = this.fResources[i];
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource visitedResource) throws CoreException {
                    if (visitedResource instanceof IFile) {
                        ScriptDeleteProcessor.this.checkDirtyFile(result, (IFile)visitedResource);
                    }
                    return true;
                }
            }, 2, false);
            ++i;
        }
    }

    private void checkDirtyFile(RefactoringStatus result, IFile file) {
        if (file == null || !file.exists()) {
            return;
        }
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.NORMALIZE);
        if (buffer != null && buffer.isDirty()) {
            if (buffer.isStateValidated() && buffer.isSynchronized()) {
                result.addWarning(MessageFormat.format(RefactoringCoreMessages.ScriptDeleteProcessor_unsaved_changes, file.getFullPath().toString()));
            } else {
                result.addFatalError(MessageFormat.format(RefactoringCoreMessages.ScriptDeleteProcessor_unsaved_changes, file.getFullPath().toString()));
            }
        }
    }

    private void recalculateElementsToDelete() throws CoreException {
        if (this.fDeleteSubPackages) {
            this.addSubPackages();
        }
        this.removeElementsWithParentsInSelection();
        this.removeUnconfirmedFoldersThatContainSourceFolders();
        this.removeUnconfirmedReferencedArchives();
        this.addEmptySourceModulesToDelete();
        this.removeScriptElementsChildrenOfScriptElements();
        this.confirmDeletingReadOnly();
        this.addDeletableParentPackagesOnPackageDeletion();
    }

    private void addSubPackages() throws ModelException {
        HashSet<Object> modelElements = new HashSet<Object>();
        int i = 0;
        while (i < this.fScriptElements.length) {
            if (this.fScriptElements[i] instanceof IScriptFolder) {
                modelElements.addAll(Arrays.asList(ModelElementUtil.getPackageAndSubpackages((IScriptFolder)((IScriptFolder)this.fScriptElements[i]))));
            } else {
                modelElements.add(this.fScriptElements[i]);
            }
            ++i;
        }
        this.fScriptElements = modelElements.toArray(new IModelElement[modelElements.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private void addDeletableParentPackagesOnPackageDeletion() throws CoreException {
        void var5_8;
        List<IModelElement> initialPackagesToDelete = ReorgUtils.getElementsOfType(this.fScriptElements, 4);
        if (initialPackagesToDelete.size() == 0) {
            return;
        }
        Collections.sort(initialPackagesToDelete, new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                IScriptFolder one = (IScriptFolder)arg0;
                IScriptFolder two = (IScriptFolder)arg1;
                return two.getElementName().compareTo(one.getElementName());
            }
        });
        HashSet<IResource> deletedChildren = new HashSet<IResource>();
        deletedChildren.addAll(Arrays.asList(this.fResources));
        int i = 0;
        while (i < this.fScriptElements.length) {
            if (!ReorgUtils.isInsideSourceModule(this.fScriptElements[i])) {
                deletedChildren.add(this.fScriptElements[i].getResource());
            }
            ++i;
        }
        ArrayList<IScriptFolder> allFragmentsToDelete = new ArrayList<IScriptFolder>();
        for (IScriptFolder iScriptFolder : initialPackagesToDelete) {
            IScriptFolder parent;
            allFragmentsToDelete.add(iScriptFolder);
            if (!this.canRemoveCompletely(iScriptFolder, initialPackagesToDelete) || (parent = ModelElementUtil.getParentSubpackage((IScriptFolder)iScriptFolder)) == null || initialPackagesToDelete.contains(parent)) continue;
            ArrayList<IScriptFolder> emptyParents = new ArrayList<IScriptFolder>();
            this.addDeletableParentPackages(parent, initialPackagesToDelete, deletedChildren, emptyParents);
            allFragmentsToDelete.addAll(emptyParents);
        }
        ArrayList<Object> modelElements = new ArrayList<Object>();
        boolean bl = false;
        while (var5_8 < this.fScriptElements.length) {
            IScriptFolder frag;
            if (!(this.fScriptElements[var5_8] instanceof IScriptFolder) && !allFragmentsToDelete.contains(frag = (IScriptFolder)this.fScriptElements[var5_8].getAncestor(4))) {
                modelElements.add(this.fScriptElements[var5_8]);
            }
            ++var5_8;
        }
        modelElements.addAll(allFragmentsToDelete);
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        int i3 = 0;
        while (i3 < this.fResources.length) {
            IResource parent = this.fResources[i3];
            if (parent.getType() == 1) {
                parent = parent.getParent();
            }
            if (!deletedChildren.contains(parent)) {
                arrayList.add(this.fResources[i3]);
            }
            ++i3;
        }
        this.fScriptElements = modelElements.toArray(new IModelElement[modelElements.size()]);
        this.fResources = arrayList.toArray(new IResource[arrayList.size()]);
    }

    private boolean canRemoveCompletely(IScriptFolder pack, List<?> packagesToDelete) throws ModelException {
        IScriptFolder[] subPackages = ModelElementUtil.getPackageAndSubpackages((IScriptFolder)pack);
        int i = 0;
        while (i < subPackages.length) {
            if (!subPackages[i].equals(pack) && !packagesToDelete.contains(subPackages[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addDeletableParentPackages(IScriptFolder frag, List<?> initialPackagesToDelete, Set<IResource> resourcesToDelete, List<IScriptFolder> deletableParentPackages) throws CoreException {
        IConfirmQuery query;
        if (frag.getResource().isLinked() && !(query = this.fDeleteQueries.createYesNoQuery(RefactoringCoreMessages.ScriptDeleteProcessor_confirm_linked_folder_delete, false, 8)).confirm(MessageFormat.format(RefactoringCoreMessages.ScriptDeleteProcessor_delete_linked_folder_question, frag.getResource().getName()))) {
            return;
        }
        IResource[] children = ((IContainer)frag.getResource()).members();
        int i = 0;
        while (i < children.length) {
            if (!resourcesToDelete.contains(children[i])) {
                return;
            }
            ++i;
        }
        resourcesToDelete.add(frag.getResource());
        deletableParentPackages.add(frag);
        IScriptFolder parent = ModelElementUtil.getParentSubpackage((IScriptFolder)frag);
        if (parent != null && !initialPackagesToDelete.contains(parent)) {
            this.addDeletableParentPackages(parent, initialPackagesToDelete, resourcesToDelete, deletableParentPackages);
        }
    }

    private void removeUnconfirmedReferencedArchives() throws ModelException {
        String queryTitle = RefactoringCoreMessages.DeleteRefactoring_2;
        IConfirmQuery query = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 3);
        this.removeUnconfirmedReferencedProjectFragments(query);
        this.removeUnconfirmedReferencedArchiveFiles(query);
    }

    private void removeUnconfirmedReferencedArchiveFiles(IConfirmQuery query) throws ModelException, OperationCanceledException {
        ArrayList<IResource> filesToSkip = new ArrayList<IResource>(0);
        int i = 0;
        while (i < this.fResources.length) {
            IProjectFragment root;
            IScriptProject project;
            IResource resource = this.fResources[i];
            if (resource instanceof IFile && (project = DLTKCore.create((IProject)resource.getProject())) != null && project.exists() && (root = project.findProjectFragment(resource.getFullPath())) != null) {
                ArrayList<IScriptProject> referencingProjects = new ArrayList<IScriptProject>(1);
                referencingProjects.add(root.getScriptProject());
                referencingProjects.addAll(Arrays.asList(ModelElementUtil.getReferencingProjects((IProjectFragment)root)));
                if (ScriptDeleteProcessor.skipDeletingReferencedRoot(query, root, referencingProjects)) {
                    filesToSkip.add(resource);
                }
            }
            ++i;
        }
        this.removeFromSetToDelete((IResource[])filesToSkip.toArray(new IFile[filesToSkip.size()]));
    }

    private void removeUnconfirmedReferencedProjectFragments(IConfirmQuery query) throws ModelException, OperationCanceledException {
        ArrayList<IProjectFragment> rootsToSkip = new ArrayList<IProjectFragment>(0);
        int i = 0;
        while (i < this.fScriptElements.length) {
            List<IScriptProject> referencingProjects;
            IProjectFragment root;
            IModelElement element = this.fScriptElements[i];
            if (element instanceof IProjectFragment && ScriptDeleteProcessor.skipDeletingReferencedRoot(query, root = (IProjectFragment)element, referencingProjects = Arrays.asList(ModelElementUtil.getReferencingProjects((IProjectFragment)root)))) {
                rootsToSkip.add(root);
            }
            ++i;
        }
        this.removeFromSetToDelete(rootsToSkip.toArray(new IModelElement[rootsToSkip.size()]));
    }

    private static boolean skipDeletingReferencedRoot(IConfirmQuery query, IProjectFragment root, List<IScriptProject> referencingProjects) throws OperationCanceledException {
        if (referencingProjects.isEmpty() || root == null || !root.exists() || !root.isArchive()) {
            return false;
        }
        String question = MessageFormat.format(RefactoringCoreMessages.DeleteRefactoring_3, root.getElementName());
        return !query.confirm(question, referencingProjects.toArray());
    }

    private void removeUnconfirmedFoldersThatContainSourceFolders() throws CoreException {
        String queryTitle = RefactoringCoreMessages.DeleteRefactoring_4;
        IConfirmQuery query = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 4);
        ArrayList<IFolder> foldersToSkip = new ArrayList<IFolder>(0);
        int i = 0;
        while (i < this.fResources.length) {
            String question;
            IFolder folder;
            IResource resource = this.fResources[i];
            if (resource instanceof IFolder && ScriptDeleteProcessor.containsSourceFolder(folder = (IFolder)resource) && !query.confirm(question = MessageFormat.format(RefactoringCoreMessages.DeleteRefactoring_5, folder.getName()))) {
                foldersToSkip.add(folder);
            }
            ++i;
        }
        this.removeFromSetToDelete(foldersToSkip.toArray(new IResource[foldersToSkip.size()]));
    }

    private static boolean containsSourceFolder(IFolder folder) throws CoreException {
        IResource[] subFolders = folder.members();
        int i = 0;
        while (i < subFolders.length) {
            if (subFolders[i] instanceof IFolder) {
                IModelElement element = DLTKCore.create((IResource)folder);
                if (element instanceof IProjectFragment) {
                    return true;
                }
                if (!(element instanceof IScriptFolder) && ScriptDeleteProcessor.containsSourceFolder((IFolder)subFolders[i])) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private void removeElementsWithParentsInSelection() {
        ParentChecker parentUtil = new ParentChecker(this.fResources, this.fScriptElements);
        parentUtil.removeElementsWithAncestorsOnList(false);
        this.fScriptElements = parentUtil.getScriptElements();
        this.fResources = parentUtil.getResources();
    }

    private void removeScriptElementsChildrenOfScriptElements() {
        ParentChecker parentUtil = new ParentChecker(this.fResources, this.fScriptElements);
        parentUtil.removeElementsWithAncestorsOnList(true);
        this.fScriptElements = parentUtil.getScriptElements();
    }

    private IFile[] getBuildpathFiles() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        int i = 0;
        while (i < this.fScriptElements.length) {
            IProject project;
            IFile buildpathFile;
            IModelElement element = this.fScriptElements[i];
            if (element instanceof IProjectFragment && (buildpathFile = (project = element.getScriptProject().getProject()).getFile(".classpath")).exists()) {
                result.add(buildpathFile);
            }
            ++i;
        }
        return result.toArray(new IFile[result.size()]);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        pm.done();
        return this.fDeleteChange;
    }

    private void addToSetToDelete(IModelElement[] newElements) {
        this.fScriptElements = ReorgUtils.union(this.fScriptElements, newElements);
    }

    private void removeFromSetToDelete(IResource[] resourcesToNotDelete) {
        this.fResources = ReorgUtils.setMinus(this.fResources, resourcesToNotDelete);
    }

    private void removeFromSetToDelete(IModelElement[] elementsToNotDelete) {
        this.fScriptElements = ReorgUtils.setMinus(this.fScriptElements, elementsToNotDelete);
    }

    private void confirmDeletingReadOnly() throws CoreException {
        if (!ReadOnlyResourceFinder.confirmDeleteOfReadOnlyElements(this.fScriptElements, this.fResources, this.fDeleteQueries)) {
            throw new OperationCanceledException();
        }
    }

    private void addEmptySourceModulesToDelete() throws ModelException {
        Set<ISourceModule> modulesToEmpty = this.getCusToEmpty();
        this.addToSetToDelete((IModelElement[])modulesToEmpty.toArray(new ISourceModule[modulesToEmpty.size()]));
    }

    private Set<ISourceModule> getCusToEmpty() throws ModelException {
        HashSet<ISourceModule> result = new HashSet<ISourceModule>();
        int i = 0;
        while (i < this.fScriptElements.length) {
            IDLTKLanguageToolkit toolkit;
            IModelElement element = this.fScriptElements[i];
            ISourceModule module = ReorgUtils.getSourceModule(element);
            if (module != null && !result.contains(module) && (toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)module)) != null && toolkit.get(DLTKFeatures.DELETE_MODULE_WITHOUT_TOP_LEVEL_TYPES) && this.willHaveAllTopLevelTypesDeleted(module)) {
                result.add(module);
            }
            ++i;
        }
        return result;
    }

    private boolean willHaveAllTopLevelTypesDeleted(ISourceModule cu) throws ModelException {
        HashSet<IModelElement> elementSet = new HashSet<IModelElement>(Arrays.asList(this.fScriptElements));
        IType[] topLevelTypes = cu.getTypes();
        int i = 0;
        while (i < topLevelTypes.length) {
            if (!elementSet.contains(topLevelTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canEnableComment() {
        return true;
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }
}

