/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.Action;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPVariable;
import org.eclipse.ptp.internal.debug.ui.PDebugImage;
import org.eclipse.ptp.internal.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.internal.debug.ui.dialogs.ArrayVariableDialog;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.ptp.internal.debug.ui.views.PTabFolder;
import org.eclipse.swt.widgets.Shell;

public class AddVariableAction
extends Action {
    protected PTabFolder folder = null;
    public static final String name = Messages.AddVariableAction_0;

    public AddVariableAction(PTabFolder folder) {
        super(name, 1);
        this.setImageDescriptor(PDebugImage.getDescriptor("add_variable_normal.gif"));
        this.setToolTipText(name);
        this.folder = folder;
    }

    public Shell getShell() {
        return this.folder.getViewSite().getShell();
    }

    public void run() {
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    AddVariableAction.this.openDialog(AddVariableAction.this.folder.getStackFrame());
                }
                catch (CoreException e) {
                    PTPDebugUIPlugin.errorDialog(AddVariableAction.this.getShell(), Messages.AddVariableAction_1, e.getStatus());
                }
            }
        });
    }

    protected void openDialog(IPStackFrame frame) throws DebugException {
        IPVariable variable;
        ArrayVariableDialog dialog;
        if (frame != null && (dialog = new ArrayVariableDialog(this.getShell(), frame)).open() == 0 && (variable = dialog.getSelectedVariable()) != null) {
            this.folder.createTabItem(variable.getName(), variable);
        }
    }
}

