/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.time.ui;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.controls.SectionWithComposite;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.verification.BaseVerificationEditor;
import org.eclipse.rcptt.verifications.time.TimePackage;
import org.eclipse.rcptt.verifications.time.TimeVerification;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TimeVerificationEditor
extends BaseVerificationEditor {
    private EMFUpdateValueStrategy minutesStrategy = new EMFUpdateValueStrategy(){
        {
            this.setBeforeSetValidator(new IValidator(){

                public IStatus validate(Object value) {
                    Integer minutes = (Integer)value;
                    if (minutes < 0 || minutes > 99) {
                        return ValidationStatus.error((String)"Value should be in [0, 99] interval.");
                    }
                    return ValidationStatus.ok();
                }
            });
        }
    };
    private EMFUpdateValueStrategy secondsStrategy = new EMFUpdateValueStrategy(){
        {
            this.setBeforeSetValidator(new IValidator(){

                public IStatus validate(Object value) {
                    Integer seconds = (Integer)value;
                    if (seconds < 0 || seconds > 60) {
                        return ValidationStatus.error((String)"Value should be in [0, 60] interval.");
                    }
                    return ValidationStatus.ok();
                }
            });
        }
    };

    public TimeVerification getVerification() {
        try {
            return (TimeVerification)super.getElement().getNamedElement();
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return null;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public Control create(Composite parent, FormToolkit toolkit, IWorkbenchSite site, EditorHeader header) {
        Section section = new SectionWithComposite("Execution Time", 322).create(parent, toolkit);
        Composite client = (Composite)section.getClient();
        GridLayoutFactory.fillDefaults().numColumns(4).spacing(8, 16).applyTo(client);
        this.createMinutesAndSecondsControls(toolkit, client);
        this.createIncludeContextsControls(toolkit, client);
        return section;
    }

    private void createIncludeContextsControls(FormToolkit toolkit, Composite client) {
        Button includeContextsCheckbox = toolkit.createButton(client, "Take into account the time spent executing contexts", 32);
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)includeContextsCheckbox);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)includeContextsCheckbox), EMFObservables.observeValue((EObject)this.getVerification(), (EStructuralFeature)TimePackage.Literals.TIME_VERIFICATION__INCLUDE_CONTEXTS));
    }

    private void createMinutesAndSecondsControls(FormToolkit toolkit, Composite client) {
        Label introLabel = toolkit.createLabel(client, "Test case execution time should be less than:");
        introLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        introLabel.setBackground(null);
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)introLabel);
        Text minutesText = toolkit.createText(client, "00", 133120);
        GridDataFactory.fillDefaults().hint(minutesText.computeSize((int)-1, (int)-1, (boolean)true).x, -1).indent(32, 0).applyTo((Control)minutesText);
        Binding minutesBinding = this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)minutesText, (int)24), EMFObservables.observeValue((EObject)this.getVerification(), (EStructuralFeature)TimePackage.Literals.TIME_VERIFICATION__MINUTES), (UpdateValueStrategy)this.minutesStrategy, (UpdateValueStrategy)new EMFUpdateValueStrategy());
        ControlDecorationSupport.create((ValidationStatusProvider)minutesBinding, (int)16512, (Composite)client, (ControlDecorationUpdater)new ControlDecorationUpdater(){

            protected void update(ControlDecoration decoration, IStatus status) {
                decoration.setMarginWidth(2);
                super.update(decoration, status);
            }
        });
        Label minutesLabel = toolkit.createLabel(client, "minute(s) and");
        minutesLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        minutesLabel.setBackground(null);
        Text secondsText = toolkit.createText(client, "00", 133120);
        GridDataFactory.fillDefaults().hint(secondsText.computeSize((int)-1, (int)-1, (boolean)true).x, -1).applyTo((Control)secondsText);
        Binding secondsBinding = this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)secondsText, (int)24), EMFObservables.observeValue((EObject)this.getVerification(), (EStructuralFeature)TimePackage.Literals.TIME_VERIFICATION__SECONDS), (UpdateValueStrategy)this.secondsStrategy, (UpdateValueStrategy)new EMFUpdateValueStrategy());
        ControlDecorationSupport.create((ValidationStatusProvider)secondsBinding, (int)16512, (Composite)client, (ControlDecorationUpdater)new ControlDecorationUpdater(){

            protected void update(ControlDecoration decoration, IStatus status) {
                decoration.setMarginWidth(2);
                super.update(decoration, status);
            }
        });
        Label secondsLabel = toolkit.createLabel(client, "second(s)");
        secondsLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        secondsLabel.setBackground(null);
    }

    public void setSelectionAtLine(int line) {
    }
}

