/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner.statement;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.internal.runner.statement.AbstractStatementWithScreenshot;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class RunTestMethod
extends AbstractStatementWithScreenshot {
    private static final Logger log = Logger.getLogger(RunTestMethod.class);

    public RunTestMethod(String config, TestClass testClass, FrameworkMethod testMethod, Object target) {
        super(config, null, testClass, testMethod, target);
    }

    public void evaluate() throws Throwable {
        try {
            this.frameworkMethod.invokeExplosively(this.target, new Object[0]);
        }
        catch (Throwable t) {
            Test annotation = (Test)this.frameworkMethod.getAnnotations()[0];
            if (ScreenshotCapturer.shouldCaptureScreenshotOnException(t) && (annotation.expected().getName().equals("org.junit.Test$None") || !annotation.expected().isAssignableFrom(t.getClass()))) {
                log.error("Test " + this.target.getClass().getName() + "." + this.frameworkMethod.getName() + " throws exception: ", t);
                this.createScreenshot();
            }
            throw t;
        }
    }
}

