/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.button;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.handler.ButtonHandler;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.impl.button.AbstractButton;
import org.eclipse.swt.widgets.Button;
import org.hamcrest.Matcher;

public class RadioButton
extends AbstractButton {
    private static final Logger log = Logger.getLogger(RadioButton.class);

    public RadioButton() {
        this((ReferencedComposite)null);
    }

    public RadioButton(Button widget) {
        super(widget);
    }

    public RadioButton(ReferencedComposite referencedComposite) {
        this(referencedComposite, 0, new Matcher[0]);
    }

    public RadioButton(String text) {
        this(null, text);
    }

    public RadioButton(ReferencedComposite referencedComposite, String text) {
        this(referencedComposite, 0, new Matcher[]{new WithMnemonicTextMatcher(text)});
    }

    public RadioButton(Matcher<?> ... matchers) {
        this((ReferencedComposite)null, matchers);
    }

    public RadioButton(ReferencedComposite referencedComposite, Matcher<?> ... matchers) {
        this(referencedComposite, 0, matchers);
    }

    public RadioButton(int index, Matcher<?> ... matchers) {
        this(null, index, matchers);
    }

    public RadioButton(ReferencedComposite referencedComposite, int index, Matcher<?> ... matchers) {
        super(referencedComposite, index, 16, matchers);
    }

    public boolean isSelected() {
        return ButtonHandler.getInstance().isSelected((Button)this.swtWidget);
    }

    public void toggle(boolean checked) {
        if (checked) {
            if (this.isSelected()) {
                log.debug("Radio Button " + this.getDescriptiveText() + " already checked, no action performed");
                return;
            }
            log.info("Select radio button " + this.getDescriptiveText());
            this.click();
        } else if (this.isSelected()) {
            log.info("Unchecking Radio Button " + this.getDescriptiveText());
            this.click();
        } else {
            log.debug("Radio button " + this.getDescriptiveText() + " already unselected, no action performed");
            return;
        }
    }
}

