/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command.view;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.session.danalysis.DViewHelper;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.common.tools.api.util.EObjectCouple;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.BundledImage;
import org.eclipse.sirius.diagram.CustomStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.Dot;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.Ellipse;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.GaugeCompositeStyle;
import org.eclipse.sirius.diagram.Lozenge;
import org.eclipse.sirius.diagram.Note;
import org.eclipse.sirius.diagram.ShapeContainerStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.AbstractNodeMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContainerMappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.EdgeMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.NodeMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.operations.BorderedStyleSpecOperation;
import org.eclipse.sirius.diagram.business.internal.metamodel.operations.StyleSpecOperations;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.diagram.util.DiagramSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.ui.RefreshFilter;
import org.eclipse.sirius.viewpoint.DRefreshable;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class RefreshSiriusElement
extends RecordingCommand {
    private DRefreshable uniqueRefreshable;
    private Collection<?> refreshablesList;
    private Collection<RefreshFilter> filters;

    public RefreshSiriusElement(TransactionalEditingDomain domain, DRefreshable objectToRefresh) {
        super(domain, Messages.RefreshSiriusElement_refreshRepresentationMsg);
        this.uniqueRefreshable = objectToRefresh;
    }

    public RefreshSiriusElement(TransactionalEditingDomain domain, Collection<?> objectsToRefresh, Collection<RefreshFilter> filters) {
        super(domain, Messages.RefreshSiriusElement_refreshRepresentationMsg);
        this.refreshablesList = objectsToRefresh;
        this.filters = filters;
    }

    protected void doExecute() {
        if (this.uniqueRefreshable != null) {
            RefreshSiriusElement.refresh(this.uniqueRefreshable);
            this.enableVisibilityUpdate(this.uniqueRefreshable);
            this.forceVisibilityRefresh(this.uniqueRefreshable);
        }
        if (this.refreshablesList != null) {
            for (Object obj : this.refreshablesList) {
                if (obj instanceof DRepresentation) {
                    if (this.isFiltered((DRepresentation)obj)) continue;
                    DialectManager.INSTANCE.refresh((DRepresentation)obj, (IProgressMonitor)new NullProgressMonitor());
                    this.enableVisibilityUpdate((DRefreshable)obj);
                    this.forceVisibilityRefresh((DRefreshable)obj);
                    continue;
                }
                if (!(obj instanceof DRefreshable)) continue;
                RefreshSiriusElement.refresh((DRefreshable)obj);
                this.enableVisibilityUpdate((DRefreshable)obj);
                this.forceVisibilityRefresh((DRefreshable)obj);
            }
        }
    }

    private void forceVisibilityRefresh(DRefreshable obj) {
        if (obj instanceof DDiagram) {
            DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility((DDiagram)obj);
        } else if (obj instanceof DDiagramElement) {
            DDiagramElement dde = (DDiagramElement)obj;
            DDiagram parentDiagram = dde.getParentDiagram();
            Session session = SessionManager.INSTANCE.getSession(dde.getTarget());
            NotificationUtil.sendNotification((EObject)parentDiagram, (int)0, (int)2);
            DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, parentDiagram);
            DisplayServiceManager.INSTANCE.getDisplayService().computeVisibility(mappingManager, parentDiagram, dde);
            NotificationUtil.sendNotification((EObject)parentDiagram, (int)1, (int)2);
        }
    }

    private boolean isFiltered(DRepresentation vp) {
        if (this.filters != null) {
            for (RefreshFilter filter : this.filters) {
                if (filter.shouldRefresh(vp)) continue;
                return true;
            }
        }
        return false;
    }

    private void enableVisibilityUpdate(DRefreshable obj) {
        DDiagram diagram = null;
        if (obj instanceof DDiagramElement) {
            diagram = ((DDiagramElement)obj).getParentDiagram();
        } else if (obj instanceof DDiagram) {
            diagram = (DDiagram)obj;
        }
        if (diagram != null) {
            NotificationUtil.sendNotification((EObject)diagram, (int)0, (int)5);
        }
    }

    public static void refresh(DRefreshable refreshable) {
        if (refreshable instanceof DView) {
            DViewHelper.refreshViewContents((DView)((DView)refreshable));
        } else {
            new Refresher().doSwitch((EObject)refreshable);
        }
    }

    private static void refreshBorderNodes(AbstractDNode adn) {
        HashSet<EObjectCouple> managedBorderingNodes = new HashSet<EObjectCouple>();
        DDiagram parentDiagram = adn.getParentDiagram();
        for (DNode n : adn.getOwnedBorderedNodes()) {
            RefreshSiriusElement.refresh((DRefreshable)n);
            managedBorderingNodes.add(new EObjectCouple(n.getTarget(), (EObject)n.getActualMapping(), RefreshIdsHolder.getOrCreateHolder((EObject)parentDiagram)));
        }
        RepresentationElementMapping mapping = adn.getMapping();
        if (mapping instanceof AbstractNodeMapping) {
            AbstractNodeMappingSpecOperations.createBorderingNodes((AbstractNodeMapping)mapping, adn.getTarget(), (DDiagramElement)adn, managedBorderingNodes, parentDiagram);
        }
    }

    private static class Refresher
    extends DiagramSwitch<DRefreshable> {
        private Refresher() {
        }

        public DRefreshable caseDRepresentation(DRepresentation object) {
            DialectManager.INSTANCE.refresh(object, (IProgressMonitor)new NullProgressMonitor());
            return object;
        }

        public DRefreshable caseDNodeContainer(DNodeContainer object) {
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)object);
            new ContainerMappingWithInterpreterHelper(interpreter).updateContainer(object.getActualMapping(), (DDiagramElementContainer)object);
            for (DDiagramElement iterElement : object.getOwnedDiagramElements()) {
                this.doSwitch((EObject)iterElement);
            }
            RefreshSiriusElement.refreshBorderNodes((AbstractDNode)object);
            return object;
        }

        public DRefreshable caseBundledImage(BundledImage object) {
            StyleSpecOperations.refresh((Style)object);
            BorderedStyleSpecOperation.refresh((BorderedStyle)object);
            return object;
        }

        public DRefreshable caseCustomStyle(CustomStyle object) {
            StyleSpecOperations.refresh((Style)object);
            BorderedStyleSpecOperation.refresh((BorderedStyle)object);
            return object;
        }

        public DRefreshable caseWorkspaceImage(WorkspaceImage object) {
            StyleSpecOperations.refresh((Style)object);
            BorderedStyleSpecOperation.refresh((BorderedStyle)object);
            return object;
        }

        public DRefreshable caseSquare(Square object) {
            StyleSpecOperations.refresh((Style)object);
            BorderedStyleSpecOperation.refresh((BorderedStyle)object);
            return object;
        }

        public DRefreshable caseShapeContainerStyle(ShapeContainerStyle object) {
            StyleSpecOperations.refresh((Style)object);
            return object;
        }

        public DRefreshable caseNote(Note object) {
            StyleSpecOperations.refresh((Style)object);
            BorderedStyleSpecOperation.refresh((BorderedStyle)object);
            return object;
        }

        public DRefreshable caseLozenge(Lozenge object) {
            StyleSpecOperations.refresh((Style)object);
            BorderedStyleSpecOperation.refresh((BorderedStyle)object);
            return object;
        }

        public DRefreshable caseGaugeCompositeStyle(GaugeCompositeStyle object) {
            StyleSpecOperations.refresh((Style)object);
            BorderedStyleSpecOperation.refresh((BorderedStyle)object);
            return object;
        }

        public DRefreshable caseFlatContainerStyle(FlatContainerStyle object) {
            StyleSpecOperations.refresh((Style)object);
            BorderedStyleSpecOperation.refresh((BorderedStyle)object);
            return object;
        }

        public DRefreshable caseEllipse(Ellipse object) {
            StyleSpecOperations.refresh((Style)object);
            BorderedStyleSpecOperation.refresh((BorderedStyle)object);
            return object;
        }

        public DRefreshable caseEdgeStyle(EdgeStyle object) {
            StyleSpecOperations.refresh((Style)object);
            return object;
        }

        public DRefreshable caseDot(Dot object) {
            StyleSpecOperations.refresh((Style)object);
            BorderedStyleSpecOperation.refresh((BorderedStyle)object);
            return object;
        }

        public DRefreshable caseDNode(DNode object) {
            NodeMapping nodeMapping = object.getActualMapping();
            if (nodeMapping != null) {
                IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)object);
                new NodeMappingHelper(interpreter).updateNode(nodeMapping, object);
                RefreshSiriusElement.refreshBorderNodes((AbstractDNode)object);
            }
            return object;
        }

        public DRefreshable caseDNodeList(DNodeList object) {
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)object);
            new ContainerMappingWithInterpreterHelper(interpreter).updateContainer(object.getActualMapping(), (DDiagramElementContainer)object);
            for (DNodeListElement iterElement : object.getOwnedElements()) {
                this.doSwitch((EObject)iterElement);
            }
            RefreshSiriusElement.refreshBorderNodes((AbstractDNode)object);
            return object;
        }

        public DRefreshable caseDNodeListElement(DNodeListElement object) {
            if (object.getActualMapping() != null) {
                IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)object);
                new NodeMappingHelper(interpreter).updateListElement(object.getActualMapping(), object);
            }
            return object;
        }

        public DRefreshable caseDEdge(DEdge object) {
            Option<EdgeMapping> edgeMapping = new IEdgeMappingQuery(object.getActualMapping()).getEdgeMapping();
            if (edgeMapping.some()) {
                this.updateEdge((EdgeMapping)edgeMapping.get(), object);
            }
            return object;
        }

        private void updateEdge(EdgeMapping edgeMapping, DEdge dEdge) {
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)dEdge);
            new EdgeMappingHelper(interpreter).updateEdge(edgeMapping, dEdge);
        }
    }
}

