/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class URIQuery {
    public static final String ENVIRONMENT_URI_SCHEME = "environment";
    public static final URI VIEWPOINT_ENVIRONMENT_QUERY = URI.createURI((String)"environment:/viewpoint");
    public static final String INMEMORY_URI_SCHEME = "memory";
    public static final String CDO_URI_SCHEME = "cdo";
    private URI uri;

    public URIQuery(URI uri) {
        this.uri = uri;
    }

    public Option<IResource> getCorrespondingResource() {
        IWorkspaceRoot res = null;
        if (this.uri.isPlatformPlugin()) {
            String pluginResourceString = this.uri.toString();
            if (pluginResourceString != null) {
                res = ResourcesPlugin.getWorkspace().getRoot();
            }
        } else {
            String platformResourceString = this.uri.toPlatformString(true);
            if (platformResourceString != null) {
                res = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourceString));
            } else if (this.uri.toFileString() != null) {
                res = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.uri.toFileString()));
            }
        }
        if (res == null) {
            return Options.newNone();
        }
        return Options.newSome((Object)res);
    }

    public boolean isSiriusCoreEnvironmentURI() {
        return VIEWPOINT_ENVIRONMENT_QUERY.equals(this.uri);
    }

    public boolean isEnvironmentURI() {
        return ENVIRONMENT_URI_SCHEME.equals(this.uri.scheme());
    }

    public boolean isInMemoryURI() {
        return INMEMORY_URI_SCHEME.equals(this.uri.scheme());
    }

    public boolean isCDOURI() {
        return CDO_URI_SCHEME.equals(this.uri.scheme());
    }

    public String toPlatformString() {
        String platformString = null;
        if (this.isInMemoryURI()) {
            StringBuffer result = new StringBuffer();
            result.append('/').append(this.uri.opaquePart());
            platformString = result.toString();
        } else if (this.uri.isPlatform()) {
            platformString = this.uri.toPlatformString(true);
        }
        return platformString;
    }
}

