/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.validator;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tcf.te.ui.controls.validator.Validator;

public class FileNameValidator
extends Validator {
    public static final String INFO_MISSING_FILE_NAME = "FileNameValidator_Information_MissingName";
    public static final String ERROR_INVALID_FILE_NAME = "FileNameValidator_Error_InvalidName";
    public static final String ERROR_IS_DIRECTORY = "FileNameValidator_Error_IsDirectory";
    public static final String ERROR_MUST_EXIST = "FileNameValidator_Error_MustExist";
    public static final String ERROR_READ_ONLY = "FileNameValidator_Error_ReadOnly";
    public static final String ERROR_NO_ACCESS = "FileNameValidator_Error_NoAccess";
    public static final String ERROR_IS_RELATIV = "FileNameValidator_Error_IsRelativ";
    public static final String ERROR_IS_ABSOLUT = "FileNameValidator_Error_IsAbsolut";
    public static final String ERROR_NOT_RELATIV_TO_WS = "FileNameValidator_Error_NotRelativToWorkspace";
    public static final String ERROR_HAS_SPACES = "FileNameValidator_Error_HasSpaces";
    private List<String> fileExtensions;
    public static final int ATTR_MUST_EXIST = 2;
    public static final int ATTR_CAN_READ = 4;
    public static final int ATTR_CAN_WRITE = 8;
    public static final int ATTR_ABSOLUT = 16;
    public static final int ATTR_RELATIV = 32;
    public static final int ATTR_NO_SPACES = 64;
    public static final int ATTR_RELATIV_TO_WS = 128;
    private boolean isFile;
    private boolean exists;
    private boolean canRead;
    private boolean canWrite;
    private boolean absolute;
    private boolean spaces;

    public FileNameValidator(int attributes) {
        super(attributes);
    }

    public FileNameValidator(int attributes, String[] fileExtensions) {
        super(attributes);
        this.setFileExtensions(fileExtensions);
    }

    public void setFileExtensions(String[] fileExtensions) {
        this.fileExtensions = Arrays.asList(fileExtensions);
    }

    public String[] getFileExtensions() {
        if (this.fileExtensions != null) {
            return this.fileExtensions.toArray(new String[this.fileExtensions.size()]);
        }
        return new String[0];
    }

    @Override
    protected void init() {
        super.init();
        this.isFile = false;
        this.exists = false;
        this.canRead = false;
        this.canWrite = false;
        this.absolute = false;
        this.spaces = false;
    }

    @Override
    public boolean isValid(String newFile) {
        IPath workSpacePath;
        File absFile;
        this.init();
        if (newFile == null || newFile.trim().length() == 0) {
            if (this.isAttribute(1)) {
                this.setMessage(this.getMessageText(INFO_MISSING_FILE_NAME), this.getMessageTextType(INFO_MISSING_FILE_NAME, 1));
                return false;
            }
            return true;
        }
        newFile = newFile.trim();
        File file = new File(newFile);
        this.absolute = file.isAbsolute();
        boolean relativToWs = false;
        if (!this.absolute && (relativToWs = (absFile = (workSpacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation()).append((IPath)new Path(file.toString())).toFile()).exists())) {
            file = absFile;
        }
        this.exists = file.exists();
        this.isFile = file.isFile() || !this.exists;
        File parentFile = file.getParentFile();
        while (parentFile != null && !parentFile.exists()) {
            parentFile = parentFile.getParentFile();
        }
        this.canRead = file.canRead() || !this.exists && parentFile != null && parentFile.canRead();
        this.canWrite = file.canWrite() || !this.exists && parentFile != null && parentFile.canWrite();
        boolean bl = this.spaces = file.toString().trim().indexOf(32) > 0;
        if (this.isAttribute(2) && !this.exists) {
            this.setMessage(this.getMessageText(ERROR_MUST_EXIST), this.getMessageTextType(ERROR_MUST_EXIST, 3));
        } else if (this.isAttribute(64) && this.spaces) {
            this.setMessage(this.getMessageText(ERROR_HAS_SPACES), this.getMessageTextType(ERROR_HAS_SPACES, 3));
        } else if (this.isAttribute(16) && !this.isAttribute(32) && !this.isAttribute(128) && !this.absolute) {
            this.setMessage(this.getMessageText(ERROR_IS_RELATIV), this.getMessageTextType(ERROR_IS_RELATIV, 3));
        } else if (this.isAttribute(32) && !this.isAttribute(16) && this.absolute) {
            this.setMessage(this.getMessageText(ERROR_IS_ABSOLUT), this.getMessageTextType(ERROR_IS_ABSOLUT, 3));
        } else if (this.isAttribute(128) && !this.absolute && !relativToWs) {
            this.setMessage(this.getMessageText(ERROR_NOT_RELATIV_TO_WS), this.getMessageTextType(ERROR_NOT_RELATIV_TO_WS, 3));
        } else if (this.exists && !this.isFile) {
            this.setMessage(this.getMessageText(ERROR_IS_DIRECTORY), this.getMessageTextType(ERROR_IS_DIRECTORY, 3));
        } else if (this.isFile && !this.hasValidExtension(newFile)) {
            this.setMessage(this.getMessageText(ERROR_INVALID_FILE_NAME), this.getMessageTextType(ERROR_INVALID_FILE_NAME, 3));
        } else if (this.isAttribute(4) && !this.canRead) {
            this.setMessage(this.getMessageText(ERROR_NO_ACCESS), this.getMessageTextType(ERROR_NO_ACCESS, 3));
        } else if (this.isAttribute(8) && !this.canWrite) {
            this.setMessage(this.getMessageText(ERROR_READ_ONLY), this.getMessageTextType(ERROR_READ_ONLY, 3));
        }
        return this.getMessageType() != 3;
    }

    private boolean hasValidExtension(String newFile) {
        if (this.fileExtensions != null && this.fileExtensions.size() > 0) {
            Iterator<String> i = this.fileExtensions.iterator();
            while (i.hasNext()) {
                String ex = i.next().toLowerCase();
                if (!newFile.toLowerCase().endsWith(ex) && !ex.equals("*") && !ex.equals("*.*") && !ex.equals(".*")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isRelative() {
        return !this.absolute;
    }
}

