/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.ant.app;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.uml2.ant.app.IDiagnosticReporter;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.util.UMLUtil;

public class DefineProfileApplication
implements IApplication {
    protected static final Integer EXIT_FAILURE = 1;
    protected final IDiagnosticReporter reporter;
    protected List<URI> profileURIs = new ArrayList<URI>(1);
    protected Map<String, String> profileDefinitionOptions = new HashMap<String, String>();

    public DefineProfileApplication() {
        this(null);
    }

    public DefineProfileApplication(IDiagnosticReporter reporter) {
        this.reporter = reporter == null ? new IDiagnosticReporter.PrintStreamReporter(System.out) : reporter;
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        if (args == null) {
            args = new String[]{};
        }
        return this.run(args);
    }

    public void stop() {
    }

    public Object run(final String[] args) throws Exception {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor progressMonitor) throws CoreException {
                    try {
                        try {
                            DefineProfileApplication.this.run(progressMonitor, args);
                        }
                        catch (Exception exception) {
                            throw new CoreException((IStatus)new Status(4, UMLPlugin.getPlugin().getSymbolicName(), 0, "Error running profile definition application.", (Throwable)exception));
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, BasicMonitor.toIProgressMonitor((Monitor)new BasicMonitor.Printing(System.out)));
            return EXIT_OK;
        }
        catch (Exception e) {
            e.printStackTrace();
            UMLPlugin.INSTANCE.log((Object)e);
            return EXIT_FAILURE;
        }
    }

    public void run(IProgressMonitor progressMonitor, String[] arguments) throws Exception {
        this.run(BasicMonitor.toMonitor((IProgressMonitor)progressMonitor), arguments);
    }

    public void run(Monitor monitor, String[] arguments) throws Exception {
        if (arguments.length == 0 || "-help".equalsIgnoreCase(arguments[0].toString())) {
            this.printUsage();
        } else {
            this.processArguments(arguments);
            this.execute(monitor);
        }
    }

    public void execute(Monitor monitor) throws Exception {
        ResourceSetImpl rset = new ResourceSetImpl();
        try {
            monitor.beginTask("Defining profile(s):", this.profileURIs.size() + 1);
            for (URI profileURI : this.profileURIs) {
                monitor.subTask(profileURI.lastSegment());
                this.defineProfile((ResourceSet)rset, profileURI);
                monitor.worked(1);
            }
        }
        finally {
            try {
                monitor.subTask("Cleaning up.");
                for (Resource next : rset.getResources()) {
                    next.unload();
                    next.eAdapters().clear();
                }
                rset.getResources().clear();
                rset.eAdapters().clear();
            }
            finally {
                monitor.done();
            }
        }
    }

    protected void defineProfile(ResourceSet rset, URI profileURI) throws Exception {
        Profile profile = (Profile)UML2Util.load((ResourceSet)rset, (URI)profileURI, (EClass)UMLPackage.Literals.PROFILE);
        if (profile != null) {
            HashMap<Class<UML2Util.QualifiedTextProvider>, UMLUtil.QualifiedTextProvider> context = new HashMap<Class<UML2Util.QualifiedTextProvider>, UMLUtil.QualifiedTextProvider>();
            context.put(UML2Util.QualifiedTextProvider.class, new UMLUtil.QualifiedTextProvider());
            BasicDiagnostic diagnostic = new BasicDiagnostic();
            profile.define(this.profileDefinitionOptions, (DiagnosticChain)diagnostic, context);
            for (Diagnostic next : diagnostic.getChildren()) {
                this.reporter.report(next);
            }
            profile.eResource().save(null);
        }
    }

    public void printUsage() {
        System.out.println(this.getUsage());
    }

    protected String getUsage() {
        String nl = System.getProperty("line.separator");
        StringBuilder result = new StringBuilder();
        result.append("Usage: { <model.profile.uml> }+ <OPTIONS>").append(nl);
        result.append("<OPTIONS>             ::= { <DEFINE-OPTION> }*").append(nl);
        result.append("<DEFINE-OPTION>       ::= < -ECORE_TAGGED_VALUES |").append(nl);
        result.append("                               -REDEFINING_OPERATIONS | -REDEFINING_PROPERTIES |").append(nl);
        result.append("                               -SUBSETTING_PROPERTIES | -UNION_PROPERTIES | -DERIVED_FEATURES |").append(nl);
        result.append("                               -DUPLICATE_OPERATIONS | -DUPLICATE_OPERATION_INHERITANCE |").append(nl);
        result.append("                               -DUPLICATE_FEATURES | -DUPLICATE_FEATURE_INHERITANCE |").append(nl);
        result.append("                               -UNTYPED_PROPERTIES |").append(nl);
        result.append("                               -SUPER_CLASS_ORDER | -ANNOTATION_DETAILS |").append(nl);
        result.append("                               -INVARIANT_CONSTRAINTS | -VALIDATION_DELEGATES | -NON_API_INVARIANTS |").append(nl);
        result.append("                               -OPERATION_BODIES | -INVOCATION_DELEGATES |").append(nl);
        result.append("                               -PROPERTY_DEFAULT_EXPRESSIONS |").append(nl);
        result.append("                               -COMMENTS | -CAMEL_CASE_NAMES |").append(nl);
        result.append("                               -FOREIGN_DEFINITIONS >").append(nl);
        result.append("                             < PROCESS | IGNORE | REPORT | DISCARD >").append(nl);
        result.append("").append(nl);
        result.append("For example:").append(nl);
        result.append("").append(nl);
        result.append("  defineProfile").append(nl);
        result.append("    ../../profiles/j2ee.profile.uml").append(nl);
        result.append("    -INVARIANT_CONSTRAINTS PROCESS -VALIDATION_DELEGATES PROCESS").append(nl);
        result.append("    -NON_API_INVARIANTS PROCESS -CAMEL_CASE_NAMES PROCESS").append(nl);
        result.append("    -UNTYPED_PROPERTIES REPORT").append(nl);
        return result.toString();
    }

    protected void processArguments(String[] arguments) {
        int index = this.processModelPaths(arguments, 0);
        while (index < arguments.length) {
            index = this.processArgument(arguments, index);
        }
    }

    protected int processModelPaths(String[] arguments, int index) {
        while (index < arguments.length && !UML2Util.isEmpty((String)arguments[index]) && !arguments[index].startsWith("-")) {
            String location = arguments[index++];
            this.profileURIs.add(URI.createFileURI((String)new File(location).getAbsolutePath()));
        }
        return index;
    }

    protected int processArgument(String[] arguments, int index) {
        if (this.isProfileDefinitionOption(arguments[index])) {
            this.profileDefinitionOptions.put(arguments[index].substring(1), arguments[++index]);
        } else {
            this.handleUnrecognizedArgument(arguments[index]);
        }
        return index + 1;
    }

    protected boolean isProfileDefinitionOption(String key) {
        String strippedKey = key.substring(1);
        return "ECORE_TAGGED_VALUES".equalsIgnoreCase(strippedKey) || "REDEFINING_OPERATIONS".equalsIgnoreCase(strippedKey) || "REDEFINING_PROPERTIES".equalsIgnoreCase(strippedKey) || "SUBSETTING_PROPERTIES".equalsIgnoreCase(strippedKey) || "UNION_PROPERTIES".equalsIgnoreCase(strippedKey) || "DERIVED_FEATURES".equalsIgnoreCase(strippedKey) || "DUPLICATE_OPERATIONS".equalsIgnoreCase(strippedKey) || "DUPLICATE_OPERATION_INHERITANCE".equalsIgnoreCase(strippedKey) || "DUPLICATE_FEATURES".equalsIgnoreCase(strippedKey) || "DUPLICATE_FEATURE_INHERITANCE".equalsIgnoreCase(strippedKey) || "UNTYPED_PROPERTIES".equalsIgnoreCase(strippedKey) || "SUPER_CLASS_ORDER".equalsIgnoreCase(strippedKey) || "ANNOTATION_DETAILS".equalsIgnoreCase(strippedKey) || "INVARIANT_CONSTRAINTS".equalsIgnoreCase(strippedKey) || "VALIDATION_DELEGATES".equalsIgnoreCase(strippedKey) || "NON_API_INVARIANTS".equalsIgnoreCase(strippedKey) || "OPERATION_BODIES".equalsIgnoreCase(strippedKey) || "INVOCATION_DELEGATES".equalsIgnoreCase(strippedKey) || "PROPERTY_DEFAULT_EXPRESSIONS".equalsIgnoreCase(strippedKey) || "COMMENTS".equalsIgnoreCase(strippedKey) || "CAMEL_CASE_NAMES".equalsIgnoreCase(strippedKey) || "FOREIGN_DEFINITIONS".equalsIgnoreCase(strippedKey);
    }

    protected void handleUnrecognizedArgument(String argument) {
        throw new IllegalArgumentException(String.format("Unrecognized argument: \"%s\"", argument));
    }
}

