/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.model.Include;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.text.LineComparator;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.UNCPathConverter;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtility {
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";

    private EditorUtility() {
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = null;
        try {
            input = EditorUtility.getEditorInput(inputElement);
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        if (input != null && (p = CUIPlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement) throws CModelException, PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws CModelException, PartInitException {
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input != null) {
            return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, inputElement), activate);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart part, ICElement element) {
        if (element == null) {
            return;
        }
        if (part instanceof CEditor) {
            ((CEditor)part).setSelection(element);
        } else if (part instanceof ITextEditor && element instanceof ISourceReference && !(element instanceof ITranslationUnit)) {
            ISourceReference reference = (ISourceReference)element;
            try {
                ISourceRange range = reference.getSourceRange();
                ((ITextEditor)part).selectAndReveal(range.getIdStartPos(), range.getIdLength());
            }
            catch (CModelException exc) {
                CUIPlugin.log(exc.getStatus());
            }
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        if (file == null) {
            return null;
        }
        if (!file.getProject().isAccessible()) {
            EditorUtility.closedProject(file.getProject());
            return null;
        }
        try {
            IEditorInput input;
            File tempFile;
            if (!file.isLinked(512) && (tempFile = file.getRawLocation().toFile()) != null) {
                String canonicalPath = null;
                try {
                    canonicalPath = tempFile.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (canonicalPath != null) {
                    Path path = new Path(canonicalPath);
                    file = CUIPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                }
            }
            if ((input = EditorUtility.getEditorInput(file)) != null) {
                return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, file), activate);
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return null;
    }

    @Deprecated
    public static boolean isLinked(IFile file) {
        if (file.isLinked()) {
            return true;
        }
        IPath path = file.getLocation();
        while (path.segmentCount() > 0) {
            IContainer[] containers;
            path = path.removeLastSegments(1);
            IContainer[] iContainerArray = containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation(path);
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer container = iContainerArray[n2];
                if (container instanceof IFolder && ((IFolder)container).isLinked()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static void closedProject(IProject project) {
        MessageBox errorMsg = new MessageBox(CUIPlugin.getActiveWorkbenchShell(), 33);
        errorMsg.setText(CUIPlugin.getResourceString("EditorUtility.closedproject"));
        String desc = CUIPlugin.getResourceString("Editorutility.closedproject.description");
        errorMsg.setMessage(MessageFormat.format(desc, project.getName()));
        errorMsg.open();
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = CUIPlugin.getActivePage()) != null) {
            IEditorPart editorPart = p.openEditor(input, editorID, activate);
            return editorPart;
        }
        return null;
    }

    private static IEditorInput getEditorInput(ICElement element) throws CModelException {
        while (element != null) {
            IResource resource;
            ITranslationUnit tu;
            if (element instanceof ISourceReference && (tu = ((ISourceReference)element).getTranslationUnit()) != null) {
                element = tu;
            }
            if (element instanceof IWorkingCopy && ((IWorkingCopy)element).isWorkingCopy()) {
                element = ((IWorkingCopy)element).getOriginalElement();
            }
            if (element instanceof ITranslationUnit) {
                ITranslationUnit unit = (ITranslationUnit)element;
                IResource resource2 = unit.getResource();
                if (resource2 instanceof IFile) {
                    return new FileEditorInput((IFile)resource2);
                }
                return new ExternalEditorInput(unit);
            }
            if (element instanceof IBinary && (resource = element.getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) throws CModelException {
        IPath location;
        if (input instanceof ICElement) {
            return EditorUtility.getEditorInput((ICElement)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (input instanceof IStorage && (location = ((IStorage)input).getFullPath()) != null) {
            return new ExternalEditorInput(location);
        }
        return null;
    }

    public static IEditorPart openInEditor(IPath location, ICElement element) throws PartInitException {
        return EditorUtility.openInEditor(location, element, true);
    }

    public static IEditorPart openInEditor(IPath location, ICElement element, boolean activate) throws PartInitException {
        IEditorInput input = EditorUtility.getEditorInputForLocation(location, element);
        return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, element), activate);
    }

    public static IEditorPart openInEditor(URI locationURI, ICElement element) throws PartInitException {
        IEditorInput input = EditorUtility.getEditorInputForLocation(locationURI, element);
        return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, element), true);
    }

    public static IEditorInput getEditorInputForLocation(URI locationURI, ICElement context) {
        ICProject cproject;
        IFile resource = EditorUtility.getWorkspaceFileAtLocation(locationURI, context);
        if (resource != null) {
            return new FileEditorInput(resource);
        }
        if (context == null) {
            try {
                ICProject[] projects = CCorePlugin.getDefault().getCoreModel().getCModel().getCProjects();
                int i = 0;
                block4: while (i < projects.length) {
                    IIncludeReference[] includeReferences = projects[i].getIncludeReferences();
                    int j = 0;
                    while (j < includeReferences.length) {
                        IPath path = URIUtil.toPath((URI)locationURI);
                        if (path == null) {
                            path = new Path(locationURI.getPath());
                        }
                        if (includeReferences[j].isOnIncludeEntry(path)) {
                            context = projects[i];
                            break block4;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (context == null && projects.length > 0) {
                    context = projects[0];
                }
            }
            catch (CModelException projects) {
                // empty catch block
            }
        }
        if (context != null && (cproject = context.getCProject()) != null) {
            ITranslationUnit unit = CoreModel.getDefault().createTranslationUnitFrom(cproject, locationURI);
            if (unit != null) {
                IFileStore fileStore = null;
                try {
                    fileStore = EFS.getStore((URI)locationURI);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return null;
                }
                if (fileStore != null) {
                    return new ExternalEditorInput(unit);
                }
            }
            IProject markerResource = cproject.getProject();
            return new ExternalEditorInput(locationURI, (IResource)markerResource);
        }
        return new ExternalEditorInput(locationURI);
    }

    public static IEditorInput getEditorInputForLocation(IPath location, ICElement context) {
        ICProject cproject;
        IFile resource = EditorUtility.getWorkspaceFileAtLocation(location, context);
        if (resource != null) {
            return new FileEditorInput(resource);
        }
        if (location.isUNC()) {
            return EditorUtility.getEditorInputForLocation(UNCPathConverter.getInstance().toURI(location), context);
        }
        if (context == null) {
            try {
                ICProject[] projects = CCorePlugin.getDefault().getCoreModel().getCModel().getCProjects();
                int i = 0;
                block2: while (i < projects.length) {
                    IIncludeReference[] includeReferences = projects[i].getIncludeReferences();
                    int j = 0;
                    while (j < includeReferences.length) {
                        if (includeReferences[j].isOnIncludeEntry(location)) {
                            context = projects[i];
                            break block2;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (context == null && projects.length > 0) {
                    context = projects[0];
                }
            }
            catch (CModelException projects) {
                // empty catch block
            }
        }
        if (context != null && (cproject = context.getCProject()) != null) {
            ICElement parent;
            ITranslationUnit unit = CoreModel.getDefault().createTranslationUnitFrom(cproject, location);
            if (unit == null && context instanceof Include && location.toFile().exists() && (parent = context.getParent()) instanceof WorkingCopy) {
                WorkingCopy copy = (WorkingCopy)parent;
                if (copy.isCLanguage()) {
                    unit = new ExternalTranslationUnit((ICElement)cproject, URIUtil.toURI((IPath)location), "org.eclipse.cdt.core.cHeader");
                } else if (copy.isCXXLanguage()) {
                    unit = new ExternalTranslationUnit((ICElement)cproject, URIUtil.toURI((IPath)location), "org.eclipse.cdt.core.cxxHeader");
                }
            }
            if (unit != null) {
                return new ExternalEditorInput(unit);
            }
            IProject markerResource = cproject.getProject();
            return new ExternalEditorInput(location, (IResource)markerResource);
        }
        return new ExternalEditorInput(location);
    }

    public static IFile getWorkspaceFileAtLocation(IPath location, ICElement context) {
        IFile file;
        ICProject cProject;
        IProject project = null;
        if (context != null && (cProject = context.getCProject()) != null) {
            project = cProject.getProject();
        }
        if ((file = ResourceLookup.selectFileForLocation((IPath)location, project)) != null && file.isAccessible()) {
            return file;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        file = root.getFileForLocation(location);
        if (file != null && file.isAccessible()) {
            return file;
        }
        if (location.segmentCount() >= 2 && (file = root.getFile(location)) != null && file.isAccessible()) {
            return file;
        }
        return null;
    }

    public static IFile getWorkspaceFileAtLocation(URI locationURI, ICElement context) {
        IFile file;
        ICProject cProject;
        IProject project = null;
        if (context != null && (cProject = context.getCProject()) != null) {
            project = cProject.getProject();
        }
        if ((file = ResourceLookup.selectFileForLocationURI((URI)locationURI, project)) != null && file.isAccessible()) {
            return file;
        }
        return null;
    }

    public static ICElement getActiveEditorCInput() {
        IEditorPart part;
        IWorkbenchPage page = CUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null) {
            return EditorUtility.getEditorInputCElement(part);
        }
        return null;
    }

    public static ICElement getEditorInputCElement(IEditorPart part) {
        IEditorInput editorInput = part.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return (ICElement)editorInput.getAdapter(ICElement.class);
    }

    public static ITranslationUnit getWorkingCopy(ITranslationUnit tu) {
        if (tu == null) {
            return null;
        }
        if (tu.isWorkingCopy()) {
            return tu;
        }
        return CDTUITools.getWorkingCopyManager().findSharedWorkingCopy(tu);
    }

    public static String getEditorID(String name) {
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)name, (boolean)true, (boolean)false);
            if (descriptor != null) {
                return descriptor.getId();
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        return DEFAULT_TEXT_EDITOR_ID;
    }

    public static String getEditorID(IEditorInput input, Object inputObject) {
        IEditorRegistry registry;
        IEditorDescriptor desc;
        int elementType;
        String contentTypeId;
        ITranslationUnit cElement = null;
        if (input instanceof IFileEditorInput) {
            editorInput = (IFileEditorInput)input;
            IFile file = editorInput.getFile();
            try {
                IEditorRegistry registry2;
                IEditorDescriptor desc2;
                String editorID = file.getPersistentProperty(IDE.EDITOR_KEY);
                if (editorID != null && (desc2 = (registry2 = PlatformUI.getWorkbench().getEditorRegistry()).findEditor(editorID)) != null) {
                    return editorID;
                }
            }
            catch (CoreException editorID) {
                // empty catch block
            }
            cElement = CoreModel.getDefault().create(file);
        } else if (input instanceof ITranslationUnitEditorInput) {
            editorInput = (ITranslationUnitEditorInput)input;
            cElement = editorInput.getTranslationUnit();
            if (cElement == null && input instanceof ExternalEditorInput && inputObject instanceof ICElement) {
                cElement = ((ICElement)inputObject).getAncestor(60);
            }
        } else if (inputObject instanceof ICElement) {
            cElement = (ICElement)inputObject;
        }
        IContentType contentType = null;
        if (cElement instanceof ITranslationUnit && (contentTypeId = cElement.getContentTypeId()) != null) {
            contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
        }
        if (contentType == null) {
            IProject project = null;
            if (cElement != null) {
                project = cElement.getCProject().getProject();
            } else {
                IFile file = ResourceUtil.getFile((IEditorInput)input);
                if (file != null) {
                    project = file.getProject();
                }
            }
            contentType = CCorePlugin.getContentType((IProject)project, (String)input.getName());
        }
        if (contentType == null && cElement != null && ((elementType = cElement.getElementType()) == 18 || elementType == 14)) {
            contentType = Platform.getContentTypeManager().getContentType("org.eclipse.cdt.core.binaryFile");
        }
        if ((desc = (registry = PlatformUI.getWorkbench().getEditorRegistry()).getDefaultEditor(input.getName(), contentType)) != null) {
            String editorID = desc.getId();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                IDE.setDefaultEditor((IFile)file, (String)editorID);
            }
            return editorID;
        }
        return DEFAULT_TEXT_EDITOR_ID;
    }

    public static int findLocalizedModifier(String token) {
        if (token == null) {
            return 0;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return NLS.bind((String)CEditorMessages.EditorUtility_concatModifierStrings, (Object[])new String[]{modifierString, newModifierString});
    }

    public static IStorage getStorage(IBinary bin) {
        FileStorage store = null;
        try {
            IBuffer buffer = bin.getBuffer();
            if (buffer != null) {
                store = new FileStorage((InputStream)new ByteArrayInputStream(buffer.getContents().getBytes()), bin.getPath());
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return store;
    }

    public static ICProject getCProject(IEditorInput input) {
        ICProject cProject = null;
        if (input instanceof IFileEditorInput) {
            IProject project = ((IFileEditorInput)input).getFile().getProject();
            if (project != null && !(cProject = CoreModel.getDefault().create(project)).exists()) {
                cProject = null;
            }
        } else if (input instanceof ITranslationUnitEditorInput) {
            IResource resource;
            ITranslationUnit tu = ((ITranslationUnitEditorInput)input).getTranslationUnit();
            if (tu != null) {
                cProject = tu.getCProject();
            } else if (input instanceof ExternalEditorInput && (resource = ((ExternalEditorInput)input).getMarkerResource()) instanceof IProject) {
                cProject = CoreModel.getDefault().create((IProject)resource);
            }
        }
        return cProject;
    }

    public static IEditorPart[] getDirtyEditors(boolean skipNonResourceEditors) {
        IWorkbenchWindow[] windows;
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorPart[] editors;
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorPart[] iEditorPartArray = editors = page.getDirtyEditors();
                int n5 = editors.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorPart ep = iEditorPartArray[n6];
                    IEditorInput input = ep.getEditorInput();
                    if (inputs.add(input) && (!skipNonResourceEditors || EditorUtility.isResourceEditorInput(input))) {
                        result.add(ep);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    private static boolean isResourceEditorInput(IEditorInput input) {
        if (input instanceof MultiEditorInput) {
            IEditorInput[] inputs;
            IEditorInput[] iEditorInputArray = inputs = ((MultiEditorInput)input).getInput();
            int n = inputs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorInput input2 = iEditorInputArray[n2];
                if (input2.getAdapter(IResource.class) != null) {
                    return true;
                }
                ++n2;
            }
        } else if (input.getAdapter(IResource.class) != null) {
            return true;
        }
        return false;
    }

    public static IEditorPart[] getDirtyEditorsToSave(boolean saveUnknownEditors) {
        IWorkbenchWindow[] windows;
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorPart[] editors;
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorPart[] iEditorPartArray = editors = page.getDirtyEditors();
                int n5 = editors.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorPart editor = iEditorPartArray[n6];
                    IEditorPart ep = editor;
                    IEditorInput input = ep.getEditorInput();
                    if (EditorUtility.mustSaveDirtyEditor(ep, input, saveUnknownEditors) && inputs.add(input)) {
                        result.add(ep);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    private static boolean mustSaveDirtyEditor(IEditorPart ep, IEditorInput input, boolean saveUnknownEditors) {
        ITranslationUnit tu;
        IResource resource = (IResource)input.getAdapter(IResource.class);
        if (resource == null) {
            return saveUnknownEditors;
        }
        ICElement element = CCorePlugin.getDefault().getCoreModel().create(resource);
        if (element instanceof ITranslationUnit && EditorUtility.getWorkingCopy(tu = (ITranslationUnit)element) == null) {
            return true;
        }
        ITextEditor textEditor = EditorUtility.getTextEditor(ep);
        if (textEditor == null) {
            return saveUnknownEditors;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (!(documentProvider instanceof TextFileDocumentProvider)) {
            return saveUnknownEditors;
        }
        return false;
    }

    public static IRegion[] calculateChangedLineRegions(final ITextFileBuffer buffer, final IProgressMonitor monitor) throws CoreException {
        final IRegion[][] result = new IRegion[1][];
        final IStatus[] errorStatus = new IStatus[]{Status.OK_STATUS};
        try {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    CUIPlugin.log((IStatus)new Status(4, "org.eclipse.cdt.ui", 10006, exception.getLocalizedMessage(), exception));
                    String msg = Messages.EditorUtility_error_calculatingChangedRegions;
                    errorStatus[0] = new Status(4, "org.eclipse.cdt.ui", 10006, msg, exception);
                    result[0] = null;
                }

                public void run() throws Exception {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.EditorUtility_calculatingChangedRegions_message, (int)4);
                    IFileStore fileStore = buffer.getFileStore();
                    ITextFileBufferManager fileBufferManager = FileBuffers.createTextFileBufferManager();
                    fileBufferManager.connectFileStore(fileStore, (IProgressMonitor)progress.split(3));
                    try {
                        IDocument currentDocument = buffer.getDocument();
                        IDocument oldDocument = ((ITextFileBuffer)fileBufferManager.getFileStoreFileBuffer(fileStore)).getDocument();
                        result[0] = this.getChangedLineRegions(oldDocument, currentDocument);
                    }
                    finally {
                        fileBufferManager.disconnectFileStore(fileStore, (IProgressMonitor)progress.split(1));
                    }
                }

                private IRegion[] getChangedLineRegions(IDocument oldDocument, IDocument currentDocument) {
                    LineComparator leftSide = new LineComparator(oldDocument);
                    LineComparator rightSide = new LineComparator(currentDocument);
                    RangeDifference[] differences = RangeDifferencer.findDifferences((IRangeComparator)leftSide, (IRangeComparator)rightSide);
                    ArrayList<Object> regions = new ArrayList<Object>();
                    int numberOfLines = currentDocument.getNumberOfLines();
                    RangeDifference[] rangeDifferenceArray = differences;
                    int n = differences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RangeDifference curr = rangeDifferenceArray[n2];
                        if (curr.kind() == 2) {
                            int startLine = Math.min(curr.rightStart(), numberOfLines - 1);
                            int endLine = curr.rightEnd() - 1;
                            try {
                                IRegion startLineRegion = currentDocument.getLineInformation(startLine);
                                if (startLine >= endLine) {
                                    if (startLine == endLine || startLineRegion.getOffset() + startLineRegion.getLength() == currentDocument.getLength()) {
                                        regions.add(startLineRegion);
                                    }
                                } else {
                                    IRegion endLineRegion = currentDocument.getLineInformation(endLine);
                                    int startOffset = startLineRegion.getOffset();
                                    int endOffset = endLineRegion.getOffset() + endLineRegion.getLength();
                                    regions.add(new Region(startOffset, endOffset - startOffset));
                                }
                            }
                            catch (BadLocationException e) {
                                CUIPlugin.log(e);
                            }
                        }
                        ++n2;
                    }
                    return regions.toArray(new IRegion[regions.size()]);
                }
            });
        }
        finally {
            if (!errorStatus[0].isOK()) {
                throw new CoreException(errorStatus[0]);
            }
        }
        return result[0];
    }

    public static IProject getProjectForActiveEditor() {
        IEditorInput editorInput;
        IFile file;
        ITextEditor activeEditor;
        IWorkbenchPage activePage;
        IProject project = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (activePage = window.getActivePage()) != null && (activeEditor = EditorUtility.getTextEditor(activePage.getActiveEditor())) != null && (file = ResourceUtil.getFile((IEditorInput)(editorInput = activeEditor.getEditorInput()))) != null) {
            project = file.getProject();
        }
        return project;
    }

    public static ITextEditor getTextEditor(IEditorPart editor) {
        return editor == null ? null : (ITextEditor)editor.getAdapter(ITextEditor.class);
    }
}

