/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emfforms.spi.swt.table.ColumnConfiguration;
import org.eclipse.emfforms.spi.swt.table.ConfigurationCallback;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTableViewerColumnBuilder<V extends AbstractTableViewer, C extends ViewerColumn> {
    private int columnId;
    private final ColumnConfiguration config;
    private EMFDataBindingContext dataBindingContext;

    public AbstractTableViewerColumnBuilder(ColumnConfiguration config) {
        this.config = config;
    }

    public C build(V tableViewer) {
        C tableViewerColumn = this.createViewerColumn(tableViewer);
        this.configure(tableViewer, tableViewerColumn);
        this.executeCallbacks(tableViewer, tableViewerColumn);
        return tableViewerColumn;
    }

    public abstract C createViewerColumn(V var1);

    protected abstract Item getTableColumn(C var1);

    protected abstract void configureViewerColumn(C var1);

    protected void configure(V tableViewer, C viewerColumn) {
        Item tableColumn = this.getTableColumn(viewerColumn);
        this.configureDatabinding((Widget)tableColumn);
        this.configureLabelProvider(viewerColumn, tableViewer);
        this.configureEditingSupport(viewerColumn, tableViewer);
        this.configureContextMap((Widget)tableColumn);
        this.configureViewerColumn(viewerColumn);
    }

    private void executeCallbacks(V tableViewer, C tableViewerColumn) {
        for (ConfigurationCallback<AbstractTableViewer, ViewerColumn> callback : this.config.getConfigurationCallbacks()) {
            callback.configure(this.config, (AbstractTableViewer)tableViewer, (ViewerColumn)tableViewerColumn);
        }
    }

    protected abstract void configureEditingSupport(C var1, V var2);

    public AbstractTableViewerColumnBuilder<V, C> withDatabinding(EMFDataBindingContext dataBindingContext) {
        this.dataBindingContext = dataBindingContext;
        return this;
    }

    protected void bindValue(Widget column, IWidgetValueProperty valueProperty, IObservableValue observable) {
        if (this.dataBindingContext == null) {
            return;
        }
        this.dataBindingContext.bindValue((IObservableValue)valueProperty.observe(column), observable);
    }

    protected void configureDatabinding(Widget column) {
        this.bindValue(column, WidgetProperties.text(), this.config.getColumnText());
    }

    protected void configureLabelProvider(C column, V tableViewer) {
        column.setLabelProvider(this.config.createLabelProvider((AbstractTableViewer)tableViewer));
    }

    protected void configureImage(Item column) {
        if (this.config.getColumnImage().isPresent()) {
            column.setImage((Image)this.config.getColumnImage().get());
        }
    }

    protected void configureContextMap(Widget column) {
        for (Map.Entry<String, Object> entry : this.config.getData().entrySet()) {
            column.setData(entry.getKey(), entry.getValue());
        }
        column.setData("emfforms.column.configuration", (Object)this.config);
        column.setData("column_id", (Object)this.columnId++);
        column.setData("resizable", (Object)this.config.isResizeable());
        column.setData("weight", (Object)this.config.getWeight());
        column.setData("min_width", (Object)this.config.getMinWidth());
    }

    public ColumnConfiguration getConfig() {
        return this.config;
    }
}

