/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.actions;

import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfiguration;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.ui.IFileEditorInput;

public class MavenPropertyTester
extends PropertyTester {
    private static final String IS_DIRECT_DEPENDENCY_TREE_NODE = "isDirectDependencyTreeNode";
    private static final String IS_TRANSITIVE_DEPENDENCY_TREE_NODE = "isTransitiveDependencyTreeNode";
    private static final String HAS_PROJECT_ARTIFACT_KEY = "hasProjectArtifactKey";
    private static final String HAS_ARTIFACT_KEY = "hasArtifactKey";
    private static final String WORKSPACE_RESULUTION_ENABLE = "workspaceResulutionEnable";
    private static final String IS_BUILD_DIRECTORY = "isBuildDirectory";
    private static final String DEFAULT_BUILD_DIR = "target";
    private static final String HAS_MAVEN_NATURE = "hasMavenNature";

    /*
     * WARNING - void declaration
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IFileEditorInput folder;
        IProject project;
        DependencyNode nd;
        Object object;
        ArtifactKey key;
        if (WORKSPACE_RESULUTION_ENABLE.equals(property)) {
            IMavenProjectRegistry projectManager;
            IMavenProjectFacade projectFacade;
            boolean enableWorkspaceResolution = true;
            IAdaptable adaptable = (IAdaptable)receiver;
            IProject projectAdapter = (IProject)adaptable.getAdapter(IProject.class);
            if (projectAdapter != null && (projectFacade = (projectManager = MavenPlugin.getMavenProjectRegistry()).create(projectAdapter, (IProgressMonitor)new NullProgressMonitor())) != null) {
                IProjectConfiguration configuration = projectFacade.getConfiguration();
                return !configuration.isResolveWorkspaceProjects();
            }
            return enableWorkspaceResolution;
        }
        if (HAS_ARTIFACT_KEY.equals(property)) {
            ArtifactKey ak = SelectionUtil.getType(receiver, ArtifactKey.class);
            return ak != null;
        }
        if (HAS_PROJECT_ARTIFACT_KEY.equals(property) && (key = SelectionUtil.getType(receiver, ArtifactKey.class)) != null) {
            IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
            IMavenProjectFacade mavenProject = null;
            mavenProject = projectManager.getMavenProject(key.groupId(), key.artifactId(), key.version());
            return mavenProject != null;
        }
        if (IS_TRANSITIVE_DEPENDENCY_TREE_NODE.equals(property) && (object = receiver) instanceof DependencyNode && (key = (DependencyNode)object) == (DependencyNode)object) {
            return nd.getData().get("LEVEL") == null;
        }
        if (IS_DIRECT_DEPENDENCY_TREE_NODE.equals(property) && (object = receiver) instanceof DependencyNode && (nd = (DependencyNode)object) == (DependencyNode)object) {
            return "DIRECT".equals(nd.getData().get("LEVEL"));
        }
        if (IS_BUILD_DIRECTORY.equals(property) && (object = receiver) instanceof IFolder && (nd = (IFolder)object) == (IFolder)object && (project = folder.getProject()) != null) {
            Path outputLocation;
            IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
            IMavenProjectFacade projectFacade = projectManager.create(project, (IProgressMonitor)new NullProgressMonitor());
            if (projectFacade == null || projectFacade.getMavenProject() == null) {
                outputLocation = new Path(DEFAULT_BUILD_DIR);
            } else {
                String buildDir = projectFacade.getMavenProject().getBuild().getDirectory();
                outputLocation = MavenProjectUtils.getProjectRelativePath((IProject)project, (String)buildDir);
            }
            if (outputLocation != null) {
                return folder.equals((Object)project.getFolder((IPath)outputLocation));
            }
        }
        if (HAS_MAVEN_NATURE.equals(property)) {
            object = receiver;
            if (object instanceof IFileEditorInput && (folder = (IFileEditorInput)object) == (IFileEditorInput)object) {
                void editor;
                return this.checkProjectNature(editor.getFile().getProject(), expectedValue);
            }
             instanceOfPatternExpressionValue = receiver;
            if ( instanceOfPatternExpressionValue instanceof IResource && (project = (IResource) instanceOfPatternExpressionValue) == (IResource) instanceOfPatternExpressionValue) {
                void resource;
                IProject project2 = resource.getProject();
                return this.checkProjectNature(project2, expectedValue);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkProjectNature(IProject project, Object expectedValue) {
        void b;
        Boolean bl;
        Object object = expectedValue;
        boolean expectedBoolean = object instanceof Boolean && (bl = (Boolean)object) == (Boolean)object ? b.booleanValue() : true;
        try {
            return project.hasNature("org.eclipse.m2e.core.maven2Nature") == expectedBoolean;
        }
        catch (CoreException ex) {
            throw new RuntimeException("Unable to get project natures for " + project + ", error= " + ex.getMessage(), ex);
        }
    }
}

