/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.archetype;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.launch.IMavenLauncher;
import org.eclipse.m2e.core.project.IArchetype;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ArchetypeGenerator.class})
public class ArchetypeGenerator {
    @Reference
    IProjectConfigurationManager projectConfigurationManager;
    @Reference
    MavenModelManager mavenModelManager;
    @Reference
    IMavenLauncher mavenLauncher;

    public Collection<MavenProjectInfo> createArchetypeProjects(IPath location, IArchetype archetype, String groupId, String artifactId, String version, String javaPackage, Map<String, String> properties, IProgressMonitor monitor) throws CoreException {
        return this.createArchetypeProjects(location, archetype, groupId, artifactId, version, javaPackage, properties, false, monitor);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<MavenProjectInfo> createArchetypeProjects(IPath location, IArchetype archetype, String groupId, String artifactId, String version, String javaPackage, Map<String, String> properties, boolean interactive, IProgressMonitor monitor) throws CoreException {
        File basedir;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.ProjectConfigurationManager_task_creating_project1, (Object)artifactId), (int)3);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        subMonitor.subTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_executing_archetype, (Object)archetype.getGroupId(), (Object)archetype.getArtifactId()));
        if (location == null) {
            location = workspaceRoot.getLocation();
        }
        if ((basedir = location.toFile()) == null || !basedir.mkdirs() && !basedir.isDirectory()) {
            throw new CoreException(Status.error((String)Messages.ProjectConfigurationManager_error_failed));
        }
        LinkedHashMap<String, String> userProperties = new LinkedHashMap<String, String>(properties);
        userProperties.put("archetypeGroupId", archetype.getGroupId());
        userProperties.put("archetypeArtifactId", archetype.getArtifactId());
        userProperties.put("archetypeVersion", archetype.getVersion());
        userProperties.put("groupId", groupId);
        userProperties.put("artifactId", artifactId);
        userProperties.put("version", version);
        userProperties.put("package", javaPackage);
        userProperties.put("outputDirectory", basedir.getAbsolutePath());
        String projectFolder = location.append(artifactId).toFile().getAbsolutePath();
        CompletableFuture mavenRun = null;
        File[] workingDir = new File[1];
        try {
            Throwable throwable = null;
            Object var18_21 = null;
            try (Closeable workingDirCleaner = ArchetypeGenerator.createEmptyWorkingDirectory(workingDir);){
                String goals = "-U archetype:generate";
                mavenRun = this.mavenLauncher.runMaven(workingDir[0], goals, userProperties, interactive);
                subMonitor.worked(1);
                Display current = Display.getCurrent();
                while (!mavenRun.isDone()) {
                    if (current != null) {
                        while (!current.isDisposed() && current.readAndDispatch()) {
                        }
                    }
                    Thread.onSpinWait();
                    subMonitor.checkCanceled();
                }
                mavenRun.get();
                subMonitor.worked(1);
                LocalProjectScanner scanner = new LocalProjectScanner(List.of(projectFolder), true, this.mavenModelManager);
                try {
                    scanner.run((IProgressMonitor)subMonitor.split(1));
                }
                catch (InterruptedException e) {
                    List<MavenProjectInfo> list = List.of();
                    if (workingDirCleaner != null) {
                        workingDirCleaner.close();
                    }
                    return list;
                }
                return this.projectConfigurationManager.collectProjects((Collection)scanner.getProjects());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InterruptedException | CancellationException | OperationCanceledException ex) {
            if (mavenRun != null) {
                mavenRun.cancel(true);
            }
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (IOException | ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof CoreException var18_23) {
                void coreException;
                throw coreException;
            }
            throw new CoreException(Status.error((String)Messages.ProjectConfigurationManager_error_failed, (Throwable)ex));
        }
    }

    private static Closeable createEmptyWorkingDirectory(File[] workingDir) throws IOException {
        Path tempWorkingDir = Files.createTempDirectory("m2e-archetypeGenerator", new FileAttribute[0]);
        Files.createDirectories(tempWorkingDir.resolve(".mvn"), new FileAttribute[0]);
        workingDir[0] = tempWorkingDir.toFile();
        return () -> FileUtils.deleteDirectory((File)workingDir[0]);
    }
}

