/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.markers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.markers.IEditorMarkerService;
import org.eclipse.m2e.core.internal.markers.IMarkerLocationService;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.preferences.ProblemSeverity;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.util.XmlUtils;
import org.eclipse.m2e.model.edit.pom.util.NodeOperation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.TagNameRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MarkerLocationService
implements IMarkerLocationService,
IEditorMarkerService {
    private static final Logger log = LoggerFactory.getLogger(MarkerLocationService.class);
    private static final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    private static final String PROJECT_NODE = "project";
    private static final String OFFSET = "offset";
    public static final String ATTR_MANAGED_VERSION_LOCATION = "managedVersionLocation";

    public void findLocationForMarker(IMarker marker) {
        IDOMModel domModel = null;
        try {
            Integer lineNumber = (Integer)marker.getAttribute("lineNumber");
            if (lineNumber == null) {
                return;
            }
            Integer columnStart = (Integer)marker.getAttribute("columnStart");
            if (columnStart == null) {
                return;
            }
            Integer columnEnd = (Integer)marker.getAttribute("columnEnd");
            if (columnEnd == null) {
                return;
            }
            IFile resource = (IFile)marker.getResource();
            domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(resource);
            if (domModel == null) {
                log.debug("Document is not structured: " + resource);
                return;
            }
            try {
                int charEnd;
                IStructuredDocument document = domModel.getStructuredDocument();
                int charStart = document.getLineOffset(lineNumber - 1) + columnStart - 1;
                marker.setAttribute("charStart", charStart);
                if (columnEnd > columnStart) {
                    charEnd = document.getLineOffset(lineNumber - 1) + columnEnd;
                } else {
                    IRegion line = document.getLineInformation(lineNumber - 1);
                    charEnd = line.getOffset() + line.getLength();
                }
                marker.setAttribute("charEnd", charEnd);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (domModel != null) {
                domModel.releaseFromRead();
            }
        }
    }

    public void findLocationForMarker_(final IMarker marker) {
        String hint = marker.getAttribute("editor_hint", null);
        if ("not_covered_mojo_execution".equals(hint)) {
            try {
                boolean lookInPM = false;
                final String groupId = marker.getAttribute("groupId", "");
                final String artifactId = marker.getAttribute("artifactId", "");
                final String exec = marker.getAttribute("executionId", "");
                final String goal = marker.getAttribute("goal", "");
                XmlUtils.performOnRootElement((IFile)marker.getResource(), new NodeOperation<Element>(){

                    public void process(Element root, IStructuredDocument structuredDocument) {
                        Element build = PomEdits.findChild(root, "build");
                        ArrayList<Element> candidates = new ArrayList<Element>();
                        Element plugin = this.findPlugin(build, groupId, artifactId);
                        if (plugin != null) {
                            candidates.add(plugin);
                        }
                        List<Element> profiles = PomEdits.findChilds(PomEdits.findChild(root, "profiles"), "profile");
                        for (Element profile : profiles) {
                            Element profBuild = PomEdits.findChild(profile, "build");
                            plugin = this.findPlugin(profBuild, groupId, artifactId);
                            if (plugin == null) continue;
                            candidates.add(plugin);
                        }
                        Element ourMarkerPlacement = null;
                        for (Element candid : candidates) {
                            PomEdits.Matcher match = "default".equals(exec) ? PomEdits.childMissingOrEqual("id", "default") : PomEdits.childEquals("id", exec);
                            Element execution = PomEdits.findChild(PomEdits.findChild(candid, "executions"), "execution", match);
                            if (execution == null) continue;
                            Element goalEl = PomEdits.findChild(PomEdits.findChild(execution, "goals"), "goal", PomEdits.textEquals(goal));
                            if (goalEl != null) {
                                ourMarkerPlacement = goalEl;
                                break;
                            }
                            if (ourMarkerPlacement != null || (ourMarkerPlacement = PomEdits.findChild(execution, "id")) != null) continue;
                            ourMarkerPlacement = execution;
                        }
                        if (ourMarkerPlacement == null) {
                            plugin = candidates.size() > 0 ? (Element)candidates.get(0) : null;
                            ourMarkerPlacement = PomEdits.findChild(plugin, "artifactId");
                            ourMarkerPlacement = ourMarkerPlacement == null && plugin != null ? plugin : (build != null ? build : root);
                        }
                        MarkerLocationService.this.annotateMarker(marker, structuredDocument, ourMarkerPlacement);
                    }

                    private Element findPlugin(Element build, String groupId2, String artifactId2) {
                        PomEdits.Matcher grIdmatch = "org.apache.maven.plugins".equals(groupId2) ? PomEdits.childMissingOrEqual("groupId", groupId2) : PomEdits.childEquals("groupId", groupId2);
                        return PomEdits.findChild(PomEdits.findChild(build, "plugins"), "plugin", grIdmatch, PomEdits.childEquals("artifactId", artifactId2));
                    }
                });
            }
            catch (IOException e) {
                log.error("Error locating marker", (Throwable)e);
            }
            catch (CoreException e) {
                log.error("Error locating marker", (Throwable)e);
            }
        }
    }

    private void annotateMarker(IMarker marker, IStructuredDocument structuredDocument, Element ourMarkerPlacement) {
        if (ourMarkerPlacement instanceof IndexedRegion var4_5) {
            try {
                marker.setAttribute("charStart", region.getStartOffset());
                try {
                    IRegion line = structuredDocument.getLineInformationOfOffset(region.getStartOffset());
                    int end = Math.min(region.getEndOffset(), line.getOffset() + line.getLength());
                    marker.setAttribute("charEnd", end);
                }
                catch (BadLocationException e) {
                    marker.setAttribute("charEnd", region.getStartOffset() + region.getLength());
                }
                marker.setAttribute("lineNumber", structuredDocument.getLineOfOffset(region.getStartOffset()) + 1);
            }
            catch (CoreException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addEditorHintMarkers(IMavenMarkerManager markerManager, IFile pom, MavenProject mavenProject, String type) {
        MarkerLocationService.checkForSchema(markerManager, (IResource)pom, type);
        MarkerLocationService.checkVarious(markerManager, (IResource)pom, mavenProject, type);
    }

    static void checkForSchema(IMavenMarkerManager mavenMarkerManager, IResource pomFile, String type) {
        block15: {
            IDOMModel domModel = null;
            try {
                if (!(pomFile instanceof IFile)) {
                    return;
                }
                domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead((IFile)pomFile);
                if (domModel == null) {
                    return;
                }
                try {
                    IStructuredDocument document = domModel.getStructuredDocument();
                    IStructuredDocumentRegion[] iStructuredDocumentRegionArray = document.getStructuredDocumentRegions();
                    int n = iStructuredDocumentRegionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStructuredDocumentRegion documentRegion = iStructuredDocumentRegionArray[n2];
                        if ("XML_TAG_NAME".equals(documentRegion.getType())) {
                            ITextRegion[] iTextRegionArray = documentRegion.getRegions().toArray();
                            int n3 = iTextRegionArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ITextRegion textRegion = iTextRegionArray[n4];
                                if (textRegion instanceof TagNameRegion && PROJECT_NODE.equals(documentRegion.getText(textRegion))) {
                                    int offset;
                                    int lineNumber;
                                    IMarker marker;
                                    if (documentRegion.getText().lastIndexOf(XSI_SCHEMA_LOCATION) == -1 && (marker = mavenMarkerManager.addMarker(pomFile, type, Messages.MavenMarkerManager_error_noschema, lineNumber = document.getLineOfOffset(offset = documentRegion.getStartOffset()) + 1, 1)) != null) {
                                        marker.setAttribute(OFFSET, offset);
                                        marker.setAttribute("editor_hint", (Object)"missing_schema");
                                        marker.setAttribute("charStart", documentRegion.getStartOffset());
                                        marker.setAttribute("charEnd", documentRegion.getEndOffset());
                                        marker.setAttribute("problemType", (Object)"pomhint");
                                    }
                                    break block15;
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception ex) {
                    log.error("Error checking for schema", (Throwable)ex);
                }
            }
            finally {
                if (domModel != null) {
                    domModel.releaseFromRead();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkManagedDependencies(IMavenMarkerManager mavenMarkerManager, Element root, IResource pomFile, MavenProject mavenproject, String type, IStructuredDocument document) throws CoreException {
        List deps;
        ProblemSeverity overridingManagedVersionSeverity = MarkerLocationService.getOverridingManagedVersionSeverity();
        if (ProblemSeverity.ignore.equals((Object)overridingManagedVersionSeverity)) {
            return;
        }
        ArrayList<Element> candidates = new ArrayList<Element>();
        Element dependencies = PomEdits.findChild(root, "dependencies");
        if (dependencies != null) {
            for (Element el : PomEdits.findChilds(dependencies, "dependency")) {
                Element version = PomEdits.findChild(el, "version");
                if (version == null) continue;
                candidates.add(el);
            }
        }
        String currentProjectKey = String.valueOf(mavenproject.getGroupId()) + ":" + mavenproject.getArtifactId() + ":" + mavenproject.getVersion();
        List activeprofiles = (List)mavenproject.getInjectedProfileIds().get(currentProjectKey);
        HashMap<Element, String> candidateProfile = new HashMap<Element, String>();
        Element profiles = PomEdits.findChild(root, "profiles");
        if (profiles != null) {
            for (Element profile : PomEdits.findChilds(profiles, "profile")) {
                String idString = PomEdits.getTextValue(PomEdits.findChild(profile, "id"));
                if (idString == null || !activeprofiles.contains(idString) || (dependencies = PomEdits.findChild(profile, "dependencies")) == null) continue;
                for (Element el : PomEdits.findChilds(dependencies, "dependency")) {
                    Element version = PomEdits.findChild(el, "version");
                    if (version == null) continue;
                    candidates.add(el);
                    candidateProfile.put(el, idString);
                }
            }
        }
        HashMap<String, Dependency> managed = new HashMap<String, Dependency>();
        DependencyManagement dm = mavenproject.getDependencyManagement();
        if (dm != null && (deps = dm.getDependencies()) != null) {
            for (Dependency dep : deps) {
                if (dep.getVersion() == null) continue;
                managed.put(dep.getManagementKey(), dep);
            }
        }
        for (Element dep : candidates) {
            void off;
            IndexedRegion indexedRegion;
            String classifier;
            String typeString;
            String id;
            Element version = PomEdits.findChild(dep, "version");
            String grpString = PomEdits.getTextValue(PomEdits.findChild(dep, "groupId"));
            String artString = PomEdits.getTextValue(PomEdits.findChild(dep, "artifactId"));
            String versionString = PomEdits.getTextValue(version);
            if (grpString == null || artString == null || versionString == null || !managed.containsKey(id = MarkerLocationService.getDependencyKey(grpString, artString, typeString = PomEdits.getTextValue(PomEdits.findChild(dep, "type")), classifier = PomEdits.getTextValue(PomEdits.findChild(dep, "classifier"))))) continue;
            Dependency managedDep = (Dependency)managed.get(id);
            String managedVersion = managedDep == null ? null : managedDep.getVersion();
            Element element = version;
            if (!(element instanceof IndexedRegion) || (indexedRegion = (IndexedRegion)element) != (IndexedRegion)element || MarkerLocationService.lookForIgnoreMarker(document, version, (IndexedRegion)off, "$NO-MVN-MAN-VER$")) continue;
            String msg = versionString.equals(managedVersion) ? Messages.MavenMarkerManager_redundant_managed_title : Messages.MavenMarkerManager_managed_title;
            IMarker mark = mavenMarkerManager.addMarker(pomFile, type, NLS.bind((String)msg, (Object)managedVersion, (Object)artString), document.getLineOfOffset(off.getStartOffset()) + 1, overridingManagedVersionSeverity.getSeverity());
            mark.setAttribute("editor_hint", (Object)"managed_dependency_override");
            mark.setAttribute("charStart", off.getStartOffset());
            mark.setAttribute("charEnd", off.getEndOffset());
            mark.setAttribute("problemType", (Object)"pomhint");
            mark.setAttribute("groupId", (Object)grpString);
            mark.setAttribute("artifactId", (Object)artString);
            MarkerLocationService.setManagedVersionAttributes(mark, mavenproject, (InputLocationTracker)managedDep);
            String profile = (String)candidateProfile.get(dep);
            if (profile == null) continue;
            mark.setAttribute("profile", (Object)profile);
        }
    }

    private static void setManagedVersionAttributes(IMarker mark, MavenProject mavenproject, InputLocationTracker dependencyOrPlugin) throws CoreException {
        File file;
        InputLocation loc = dependencyOrPlugin == null ? null : dependencyOrPlugin.getLocation((Object)"version");
        File file2 = file = loc == null ? null : XmlUtils.fileForInputLocation(loc, mavenproject);
        if (file != null) {
            int columnNumber;
            int lineNumber;
            mark.setAttribute(ATTR_MANAGED_VERSION_LOCATION, (Object)file.toURI().toString());
            int n = lineNumber = loc != null ? loc.getLineNumber() : -1;
            if (lineNumber > 0) {
                mark.setAttribute("managedVersionLine", lineNumber);
            }
            int n2 = columnNumber = loc != null ? loc.getColumnNumber() : -1;
            if (columnNumber > 0) {
                mark.setAttribute("managedVersionColumn", columnNumber);
            }
        }
    }

    private static String getDependencyKey(String groupId, String artifactId, String type, String classifier) {
        StringBuilder key = new StringBuilder(groupId).append(":").append(artifactId).append(":").append(type == null ? "jar" : type);
        if (classifier != null) {
            key.append(":").append(classifier);
        }
        return key.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void checkManagedPlugins(IMavenMarkerManager mavenMarkerManager, Element root, IResource pomFile, MavenProject mavenproject, String type, IStructuredDocument document) throws CoreException {
        List plgs;
        ProblemSeverity overridingManagedVersionSeverity = MarkerLocationService.getOverridingManagedVersionSeverity();
        if (ProblemSeverity.ignore.equals((Object)overridingManagedVersionSeverity)) {
            return;
        }
        ArrayList<Element> candidates = new ArrayList<Element>();
        Element build = PomEdits.findChild(root, "build");
        if (build == null) {
            return;
        }
        Element plugins = PomEdits.findChild(build, "plugins");
        if (plugins != null) {
            for (Element el : PomEdits.findChilds(plugins, "plugin")) {
                Element version = PomEdits.findChild(el, "version");
                if (version == null) continue;
                candidates.add(el);
            }
        }
        String currentProjectKey = String.valueOf(mavenproject.getGroupId()) + ":" + mavenproject.getArtifactId() + ":" + mavenproject.getVersion();
        List activeprofiles = (List)mavenproject.getInjectedProfileIds().get(currentProjectKey);
        HashMap<Element, String> candidateProfile = new HashMap<Element, String>();
        Element profiles = PomEdits.findChild(root, "profiles");
        if (profiles != null) {
            for (Element profile : PomEdits.findChilds(profiles, "profile")) {
                String idString = PomEdits.getTextValue(PomEdits.findChild(profile, "id"));
                if (idString == null || !activeprofiles.contains(idString) || (build = PomEdits.findChild(profile, "build")) == null || (plugins = PomEdits.findChild(build, "plugins")) == null) continue;
                for (Element el : PomEdits.findChilds(plugins, "plugin")) {
                    Element version = PomEdits.findChild(el, "version");
                    if (version == null) continue;
                    candidates.add(el);
                    candidateProfile.put(el, idString);
                }
            }
        }
        HashMap<String, Plugin> managed = new HashMap<String, Plugin>();
        PluginManagement pm = mavenproject.getPluginManagement();
        if (pm != null && (plgs = pm.getPlugins()) != null) {
            for (Plugin plg : plgs) {
                String modelID;
                InputLocation loc = plg.getLocation((Object)"version");
                String string = loc == null ? null : (modelID = loc.getSource() == null ? null : loc.getSource().getModelId());
                if (loc == null || modelID != null && modelID.startsWith("org.apache.maven:maven-model-builder:") && modelID.endsWith(":super-pom")) continue;
                managed.put(plg.getKey(), plg);
            }
        }
        for (Element dep : candidates) {
            void off;
            IndexedRegion indexedRegion;
            String id;
            String grpString = PomEdits.getTextValue(PomEdits.findChild(dep, "groupId"));
            if (grpString == null) {
                grpString = "org.apache.maven.plugins";
            }
            String artString = PomEdits.getTextValue(PomEdits.findChild(dep, "artifactId"));
            Element version = PomEdits.findChild(dep, "version");
            String versionString = PomEdits.getTextValue(version);
            if (artString == null || versionString == null || !managed.containsKey(id = Plugin.constructKey((String)grpString, (String)artString))) continue;
            Plugin managedPlugin = (Plugin)managed.get(id);
            String managedVersion = managedPlugin == null ? null : managedPlugin.getVersion();
            Element element = version;
            if (!(element instanceof IndexedRegion) || (indexedRegion = (IndexedRegion)element) != (IndexedRegion)element || MarkerLocationService.lookForIgnoreMarker(document, version, (IndexedRegion)off, "$NO-MVN-MAN-VER$")) continue;
            String msg = versionString.equals(managedVersion) ? Messages.MavenMarkerManager_redundant_managed_title : Messages.MavenMarkerManager_managed_title;
            IMarker mark = mavenMarkerManager.addMarker(pomFile, type, NLS.bind((String)msg, (Object)managedVersion, (Object)artString), document.getLineOfOffset(off.getStartOffset()) + 1, overridingManagedVersionSeverity.getSeverity());
            mark.setAttribute("editor_hint", (Object)"managed_plugin_override");
            mark.setAttribute("charStart", off.getStartOffset());
            mark.setAttribute("charEnd", off.getEndOffset());
            mark.setAttribute("problemType", (Object)"pomhint");
            mark.setAttribute("groupId", (Object)grpString);
            mark.setAttribute("artifactId", (Object)artString);
            MarkerLocationService.setManagedVersionAttributes(mark, mavenproject, (InputLocationTracker)managedPlugin);
            String profile = (String)candidateProfile.get(dep);
            if (profile == null) continue;
            mark.setAttribute("profile", (Object)profile);
        }
    }

    private static void checkParentMatchingGroupIdVersion(IMavenMarkerManager mavenMarkerManager, Element root, IResource pomFile, String type, IStructuredDocument document) throws CoreException {
        Element parent = PomEdits.findChild(root, "parent");
        Element groupId = PomEdits.findChild(root, "groupId");
        ProblemSeverity matchingParentGroupIdSeverity = MarkerLocationService.getMatchingParentGroupIdSeverity();
        if (parent != null && groupId != null && !ProblemSeverity.ignore.equals((Object)matchingParentGroupIdSeverity)) {
            String parentString = PomEdits.getTextValue(PomEdits.findChild(parent, "groupId"));
            String childString = PomEdits.getTextValue(groupId);
            if (parentString != null && parentString.equals(childString) && groupId instanceof IndexedRegion var10_11) {
                mark = mavenMarkerManager.addMarker(pomFile, type, Messages.MavenMarkerManager_duplicate_groupid, document.getLineOfOffset(off.getStartOffset()) + 1, matchingParentGroupIdSeverity.getSeverity());
                mark.setAttribute("editor_hint", (Object)"parent_groupid");
                mark.setAttribute("charStart", off.getStartOffset());
                mark.setAttribute("charEnd", off.getEndOffset());
                mark.setAttribute("problemType", (Object)"pomhint");
            }
        }
        Element version = PomEdits.findChild(root, "version");
        ProblemSeverity matchingParentVersionSeverity = MarkerLocationService.getMatchingParentVersionSeverity();
        if (parent != null && version != null && !ProblemSeverity.ignore.equals((Object)matchingParentVersionSeverity)) {
            String parentString = PomEdits.getTextValue(PomEdits.findChild(parent, "version"));
            String childString = PomEdits.getTextValue(version);
            if (parentString != null && parentString.equals(childString) && ( instanceOfPatternExpressionValue = version) instanceof IndexedRegion && (mark = (IndexedRegion) instanceOfPatternExpressionValue) == (IndexedRegion) instanceOfPatternExpressionValue) {
                IMarker mark = mavenMarkerManager.addMarker(pomFile, type, Messages.MavenMarkerManager_duplicate_version, document.getLineOfOffset(off.getStartOffset()) + 1, matchingParentVersionSeverity.getSeverity());
                mark.setAttribute("editor_hint", (Object)"parent_version");
                mark.setAttribute("charStart", off.getStartOffset());
                mark.setAttribute("charEnd", off.getEndOffset());
                mark.setAttribute("problemType", (Object)"pomhint");
            }
        }
    }

    private static ProblemSeverity getMatchingParentGroupIdSeverity() {
        return ProblemSeverity.get((String)M2EUIPluginActivator.getDefault().getPreferenceStore().getString("eclipse.m2.problem.duplicateParentGroupId"));
    }

    private static ProblemSeverity getMatchingParentVersionSeverity() {
        return ProblemSeverity.get((String)M2EUIPluginActivator.getDefault().getPreferenceStore().getString("eclipse.m2.problem.duplicateParentVersion"));
    }

    private static ProblemSeverity getOverridingManagedVersionSeverity() {
        return ProblemSeverity.get((String)M2EUIPluginActivator.getDefault().getPreferenceStore().getString("eclipse.m2.problem.overridingManagedVersion"));
    }

    static void checkVarious(IMavenMarkerManager mavenMarkerManager, IResource pomFile, MavenProject mavenProject, String type) {
        IDOMModel domModel = null;
        try {
            if (!(pomFile instanceof IFile)) {
                return;
            }
            domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead((IFile)pomFile);
            if (domModel == null) {
                return;
            }
            try {
                IStructuredDocument document = domModel.getStructuredDocument();
                Element root = domModel.getDocument().getDocumentElement();
                if (root != null && PROJECT_NODE.equals(root.getNodeName())) {
                    MarkerLocationService.checkParentMatchingGroupIdVersion(mavenMarkerManager, root, pomFile, type, document);
                    if (mavenProject != null) {
                        MarkerLocationService.checkManagedDependencies(mavenMarkerManager, root, pomFile, mavenProject, type, document);
                        MarkerLocationService.checkManagedPlugins(mavenMarkerManager, root, pomFile, mavenProject, type, document);
                    }
                }
            }
            catch (Exception t) {
                log.error("Error checking for warnings", (Throwable)t);
            }
        }
        finally {
            if (domModel != null) {
                domModel.releaseFromRead();
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean lookForIgnoreMarker(IStructuredDocument document, Element version, IndexedRegion off, String ignoreString) {
        Node reg = version;
        int line = document.getLineOfOffset(off.getStartOffset());
        try {
            int lineend = document.getLineOffset(line) + document.getLineLength(line) - 1;
            int start = off.getStartOffset();
            while (reg != null) {
                void comm;
                String data;
                if (start >= lineend) {
                    return false;
                }
                Node node = reg = reg.getNextSibling();
                if (node instanceof Comment var8_9 && (data = comm.getData()) != null && data.contains(ignoreString)) {
                    return true;
                }
                if (reg == null) continue;
                start = ((IndexedRegion)reg).getStartOffset();
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }
}

