/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.List;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.m2e.core.internal.project.ProjectConfigurationManager;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.components.WorkingSetGroup;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenWizardPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;

public class MavenProjectWizardLocationPage
extends AbstractMavenWizardPage {
    Button useDefaultWorkspaceLocationButton;
    Label locationLabel;
    Combo locationCombo;
    boolean initialized = false;
    private WorkingSetGroup workingSetGroup;
    private IPath location;
    private final List<IWorkingSet> workingSets;

    public MavenProjectWizardLocationPage(ProjectImportConfiguration configuration, String title, String description, List<IWorkingSet> workingSets) {
        super("MavenProjectWizardLocationPage", configuration);
        this.workingSets = workingSets;
        this.setTitle(title);
        this.setDescription(description);
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        this.createAdditionalControls(container);
        this.useDefaultWorkspaceLocationButton = new Button(container, 32);
        GridData useDefaultWorkspaceLocationButtonData = new GridData(16384, 0x1000000, false, false, 3, 1);
        this.useDefaultWorkspaceLocationButton.setLayoutData((Object)useDefaultWorkspaceLocationButtonData);
        this.useDefaultWorkspaceLocationButton.setText(Messages.MavenProjectWizardLocationPage_btnUserDefault);
        this.useDefaultWorkspaceLocationButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean inWorkspace = this.isInWorkspace();
            this.locationLabel.setEnabled(!inWorkspace);
            this.locationCombo.setEnabled(!inWorkspace);
        }));
        this.useDefaultWorkspaceLocationButton.setSelection(true);
        this.locationLabel = new Label(container, 0);
        GridData locationLabelData = new GridData();
        locationLabelData.horizontalIndent = 10;
        this.locationLabel.setLayoutData((Object)locationLabelData);
        this.locationLabel.setText(Messages.MavenProjectWizardLocationPage_lblLocation);
        this.locationLabel.setEnabled(false);
        this.locationCombo = new Combo(container, 0);
        GridData locationComboData = new GridData(4, 0x1000000, true, false);
        this.locationCombo.setLayoutData((Object)locationComboData);
        this.locationCombo.addModifyListener(e -> this.validate());
        this.locationCombo.setEnabled(false);
        this.addFieldWithHistory("location", this.locationCombo);
        Button locationBrowseButton = new Button(container, 0);
        GridData locationBrowseButtonData = new GridData(4, 0x1000000, false, false);
        locationBrowseButton.setLayoutData((Object)locationBrowseButtonData);
        locationBrowseButton.setText(Messages.MavenProjectWizardLocationPage_btnLocation);
        locationBrowseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            dialog.setText(Messages.MavenProjectWizardLocationPage_dialog_location);
            String path = this.locationCombo.getText();
            if (path.length() == 0) {
                path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toPortableString();
            }
            dialog.setFilterPath(path);
            String selectedDir = dialog.open();
            if (selectedDir != null) {
                this.locationCombo.setText(selectedDir);
                this.useDefaultWorkspaceLocationButton.setSelection(false);
                this.validate();
            }
        }));
        this.workingSetGroup = new WorkingSetGroup(container, this.workingSets, this.getShell());
        if (this.location != null && !Platform.getLocation().equals((Object)this.location)) {
            this.locationCombo.setText(this.location.toOSString());
        }
        this.createAdvancedSettings(container, new GridData(4, 128, true, false, 3, 1));
        this.setControl((Control)container);
    }

    protected void createAdditionalControls(Composite container) {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.workingSetGroup.dispose();
    }

    public boolean isInWorkspace() {
        return this.useDefaultWorkspaceLocationButton.getSelection();
    }

    public IPath getLocationPath() {
        if (this.isInWorkspace()) {
            return ResourcesPlugin.getWorkspace().getRoot().getLocation();
        }
        return Path.fromOSString((String)this.locationCombo.getText().trim());
    }

    public void setLocationPath(IPath location) {
        this.location = location;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialized = true;
            this.validate();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void validate() {
        IStatus locationStatus;
        void mavenWizard;
        String projectName;
        MavenProjectWizard mavenProjectWizard;
        IWizard iWizard;
        if (!this.initialized) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath projectPath = this.getLocationPath();
        String location = projectPath.toOSString();
        if (location.length() == 0) {
            this.setErrorMessage(null);
            this.setMessage(Messages.wizardProjectPageProjectValidatorProjectLocation);
            this.setPageComplete(false);
            return;
        }
        if (!Path.ROOT.isValidPath(location)) {
            this.setErrorMessage(Messages.wizardProjectPageProjectValidatorInvalidLocation);
            this.setPageComplete(false);
            return;
        }
        if (!this.isInWorkspace() && (iWizard = this.getWizard()) instanceof MavenProjectWizard && (mavenProjectWizard = (MavenProjectWizard)iWizard) == (MavenProjectWizard)iWizard && (projectName = ProjectConfigurationManager.getProjectName((ProjectImportConfiguration)this.getImportConfiguration(), (Model)mavenWizard.getModel())).length() > 0 && !(locationStatus = workspace.validateProjectLocation(workspace.getRoot().getProject(projectName), projectPath)).isOK()) {
            this.setErrorMessage(locationStatus.getMessage());
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
        this.setMessage(null);
    }
}

