/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;

public class ClasspathEntryDescriptor
implements IClasspathEntryDescriptor {
    private int entryKind;
    private IPath path;
    private boolean exported;
    private IPath outputLocation;
    private List<IAccessRule> accessRules = new ArrayList<IAccessRule>();
    private LinkedHashMap<String, String> attributes = new LinkedHashMap();
    private IPath sourceAttachmentPath;
    private IPath sourceAttachmentRootPath;
    private LinkedHashSet<IPath> inclusionPatterns;
    private LinkedHashSet<IPath> exclusionPatterns;
    private boolean combineAccessRules;
    private ArtifactKey artifactKey;
    private String scope;
    private boolean optionalDependency;

    public ClasspathEntryDescriptor(int entryKind, IPath path) {
        this.entryKind = entryKind;
        this.path = path;
    }

    public ClasspathEntryDescriptor(IClasspathEntry entry) {
        this.setClasspathEntry(entry);
    }

    @Override
    public IClasspathEntry toClasspathEntry() {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>(this.attributes);
        if (this.artifactKey != null) {
            attributes.put("maven.groupId", this.artifactKey.groupId());
            attributes.put("maven.artifactId", this.artifactKey.artifactId());
            attributes.put("maven.version", this.artifactKey.version());
            if (this.artifactKey.classifier() != null) {
                attributes.put("maven.classifier", this.artifactKey.classifier());
            }
        }
        if (this.scope != null) {
            attributes.put("maven.scope", this.scope);
        }
        if (this.optionalDependency) {
            attributes.put("maven.optionaldependency", Boolean.toString(true));
        }
        IClasspathAttribute[] attributesArray = new IClasspathAttribute[attributes.size()];
        int attributeIndex = 0;
        for (Map.Entry attribute : attributes.entrySet()) {
            attributesArray[attributeIndex++] = JavaCore.newClasspathAttribute((String)((String)attribute.getKey()), (String)((String)attribute.getValue()));
        }
        IAccessRule[] accessRulesArray = this.accessRules.toArray(new IAccessRule[this.accessRules.size()]);
        return switch (this.entryKind) {
            case 5 -> JavaCore.newContainerEntry((IPath)this.path, (IAccessRule[])accessRulesArray, (IClasspathAttribute[])attributesArray, (boolean)this.exported);
            case 1 -> JavaCore.newLibraryEntry((IPath)this.path, (IPath)this.sourceAttachmentPath, (IPath)this.sourceAttachmentRootPath, (IAccessRule[])accessRulesArray, (IClasspathAttribute[])attributesArray, (boolean)this.exported);
            case 3 -> JavaCore.newSourceEntry((IPath)this.path, (IPath[])this.getInclusionPatterns(), (IPath[])this.getExclusionPatterns(), (IPath)this.outputLocation, (IClasspathAttribute[])attributesArray);
            case 2 -> JavaCore.newProjectEntry((IPath)this.path, (IAccessRule[])accessRulesArray, (boolean)this.combineAccessRules, (IClasspathAttribute[])attributesArray, (boolean)this.exported);
            case 4 -> JavaCore.newVariableEntry((IPath)this.path, (IPath)this.sourceAttachmentPath, (IPath)this.sourceAttachmentRootPath, (IAccessRule[])accessRulesArray, (IClasspathAttribute[])attributesArray, (boolean)this.exported);
            default -> throw new IllegalArgumentException("Unsupported IClasspathEntry kind=" + this.entryKind);
        };
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public boolean isOptionalDependency() {
        return this.optionalDependency;
    }

    @Override
    public void setClasspathAttribute(String name, String value) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    @Override
    public Map<String, String> getClasspathAttributes() {
        return this.attributes;
    }

    @Override
    public String getGroupId() {
        return this.artifactKey != null ? this.artifactKey.groupId() : null;
    }

    private void setClasspathEntry(IClasspathEntry entry) {
        this.entryKind = entry.getEntryKind();
        this.path = entry.getPath();
        this.exported = entry.isExported();
        this.outputLocation = entry.getOutputLocation();
        this.accessRules = new ArrayList<IAccessRule>();
        Collections.addAll(this.accessRules, entry.getAccessRules());
        this.attributes = new LinkedHashMap();
        IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            this.attributes.put(attribute.getName(), attribute.getValue());
            ++n2;
        }
        this.sourceAttachmentPath = entry.getSourceAttachmentPath();
        this.sourceAttachmentRootPath = entry.getSourceAttachmentRootPath();
        this.setInclusionPatterns(entry.getInclusionPatterns());
        this.setExclusionPatterns(entry.getExclusionPatterns());
        this.combineAccessRules = entry.combineAccessRules();
        String groupId = this.attributes.get("maven.groupId");
        String artifactId = this.attributes.get("maven.artifactId");
        String version = this.attributes.get("maven.version");
        String classifier = this.attributes.get("maven.classifier");
        if (groupId != null && artifactId != null && version != null) {
            this.artifactKey = new ArtifactKey(groupId, artifactId, version, classifier);
        }
    }

    @Override
    public String getArtifactId() {
        return this.artifactKey != null ? this.artifactKey.artifactId() : null;
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    @Override
    public void setPath(IPath path) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.path = path;
    }

    @Override
    public int getEntryKind() {
        return this.entryKind;
    }

    @Override
    public void setEntryKind(int entryKind) {
        this.entryKind = entryKind;
    }

    @Override
    public ArtifactKey getArtifactKey() {
        return this.artifactKey;
    }

    @Override
    public void setArtifactKey(ArtifactKey artifactKey) {
        this.artifactKey = artifactKey;
    }

    @Override
    public void setSourceAttachment(IPath srcPath, IPath srcRoot) {
        this.sourceAttachmentPath = srcPath;
        this.sourceAttachmentRootPath = srcRoot;
    }

    @Override
    public void setJavadocUrl(String javaDocUrl) {
        this.setClasspathAttribute("javadoc_location", javaDocUrl);
    }

    @Override
    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    @Override
    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    @Override
    public String getJavadocUrl() {
        return this.attributes.get("javadoc_location");
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public void setOptionalDependency(boolean optional) {
        this.optionalDependency = optional;
    }

    @Override
    public void addAccessRule(IAccessRule rule) {
        this.accessRules.add(rule);
    }

    @Override
    public List<IAccessRule> getAccessRules() {
        return this.accessRules;
    }

    @Override
    public void setOutputLocation(IPath outputLocation) {
        this.outputLocation = outputLocation;
    }

    @Override
    public IPath getOutputLocation() {
        return this.outputLocation;
    }

    @Override
    public void setInclusionPatterns(IPath[] inclusionPatterns) {
        this.inclusionPatterns = inclusionPatterns != null ? new LinkedHashSet<IPath>(Arrays.asList(inclusionPatterns)) : null;
    }

    @Override
    public void addInclusionPattern(IPath pattern) {
        if (this.inclusionPatterns == null) {
            this.inclusionPatterns = new LinkedHashSet();
        }
        this.inclusionPatterns.add(pattern);
    }

    @Override
    public void removeInclusionPattern(IPath pattern) {
        if (this.inclusionPatterns != null) {
            this.inclusionPatterns.remove(pattern);
        }
    }

    @Override
    public IPath[] getInclusionPatterns() {
        return this.inclusionPatterns != null ? this.inclusionPatterns.toArray(new IPath[this.inclusionPatterns.size()]) : null;
    }

    @Override
    public void setExclusionPatterns(IPath[] exclusionPatterns) {
        this.exclusionPatterns = exclusionPatterns != null ? new LinkedHashSet<IPath>(Arrays.asList(exclusionPatterns)) : null;
    }

    @Override
    public void addExclusionPattern(IPath pattern) {
        if (this.exclusionPatterns == null) {
            this.exclusionPatterns = new LinkedHashSet();
        }
        this.exclusionPatterns.add(pattern);
    }

    @Override
    public void removeExclusionPattern(IPath pattern) {
        if (this.exclusionPatterns != null) {
            this.exclusionPatterns.remove(pattern);
        }
    }

    @Override
    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns != null ? this.exclusionPatterns.toArray(new IPath[this.exclusionPatterns.size()]) : null;
    }

    @Override
    public void setExported(boolean exported) {
        this.exported = exported;
    }

    @Override
    public boolean isExported() {
        return this.exported;
    }

    @Override
    public void setCombineAccessRules(boolean combineAccessRules) {
        this.combineAccessRules = combineAccessRules;
    }

    @Override
    public boolean combineAccessRules() {
        return this.combineAccessRules;
    }

    @Override
    public boolean isPomDerived() {
        return Boolean.parseBoolean(this.attributes.get("maven.pomderived"));
    }

    @Override
    public void setPomDerived(boolean derived) {
        if (derived) {
            this.attributes.put("maven.pomderived", Boolean.toString(true));
        } else {
            this.attributes.remove("maven.pomderived");
        }
    }
}

