/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.sourcelookup.internal;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class MetaInfMavenScanner<T> {
    private static final String META_INF_MAVEN = "META-INF/maven";

    public List<T> scan(Path file, String filename) {
        ArrayList result;
        block13: {
            if (file == null) {
                return List.of();
            }
            result = new ArrayList();
            try {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    this.scanFilesystem(file.resolve(META_INF_MAVEN), filename, result);
                    break block13;
                }
                if (!Files.isRegularFile(file, new LinkOption[0])) break block13;
                Throwable throwable = null;
                Object var5_7 = null;
                try (JarFile jar = new JarFile(file.toFile());){
                    this.scanJar(jar, "/" + filename, result);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private void scanJar(JarFile jar, String filename, List<T> result) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).startsWith(META_INF_MAVEN) || !name.endsWith(filename)) continue;
            try {
                T t = this.visitJarEntry(jar, entry);
                if (t == null) continue;
                result.add(t);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void scanFilesystem(Path dir, final String filename, final List<T> result) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Object t;
                if (filename.equals(file.getFileName().toString()) && (t = MetaInfMavenScanner.this.visitFile(file)) != null) {
                    result.add(t);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected abstract T visitFile(Path var1) throws IOException;

    protected abstract T visitJarEntry(JarFile var1, JarEntry var2) throws IOException;
}

