/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaSourceLookupParticipant;
import org.eclipse.m2e.internal.launch.IMavenLaunchParticipant;
import org.eclipse.m2e.internal.launch.MavenBuildProjectDataConnection;
import org.eclipse.m2e.internal.launch.MavenLaunchParticipantInfo;
import org.eclipse.m2e.internal.launch.MavenRuntimeLaunchSupport;
import org.eclipse.m2e.internal.launch.MavenSourceLocator;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLaunchExtensionsSupport {
    private static final Logger log = LoggerFactory.getLogger(MavenLaunchExtensionsSupport.class);
    private final List<IMavenLaunchParticipant> participants;

    private MavenLaunchExtensionsSupport(List<IMavenLaunchParticipant> participants) {
        this.participants = participants;
    }

    /*
     * WARNING - void declaration
     */
    public void configureSourceLookup(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) {
        ISourceLocator iSourceLocator = launch.getSourceLocator();
        if (iSourceLocator instanceof MavenSourceLocator var4_5) {
            void sourceLocator;
            for (IMavenLaunchParticipant participant : this.participants) {
                List<ISourceLookupParticipant> sourceLookupParticipants = participant.getSourceLookupParticipants(configuration, launch, monitor);
                if (sourceLookupParticipants == null || sourceLookupParticipants.isEmpty()) continue;
                sourceLocator.addParticipants(sourceLookupParticipants.toArray(new ISourceLookupParticipant[sourceLookupParticipants.size()]));
            }
            sourceLocator.addParticipants(new ISourceLookupParticipant[]{new JavaSourceLookupParticipant()});
        } else {
            log.warn(NLS.bind((String)Messages.MavenLaynchDelegate_unsupported_source_locator, (Object)launch.getSourceLocator().getClass().getCanonicalName()));
        }
    }

    public static MavenLaunchExtensionsSupport create(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        Set disabledExtensions = configuration.getAttribute("M2_DISABLED_EXTENSIONS", Collections.emptySet());
        ArrayList<IMavenLaunchParticipant> participants = new ArrayList<IMavenLaunchParticipant>();
        for (MavenLaunchParticipantInfo info : MavenLaunchParticipantInfo.readParticipantsInfo()) {
            if (disabledExtensions.contains(info.getId()) || !info.getModes().contains(launch.getLaunchMode())) continue;
            try {
                participants.add(info.createParticipant());
            }
            catch (CoreException e) {
                log.debug("Problem with external extension point", (Throwable)e);
            }
        }
        return new MavenLaunchExtensionsSupport(participants);
    }

    public void appendProgramArguments(StringBuilder arguments, ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) {
        for (IMavenLaunchParticipant participant : this.participants) {
            String extensionArguments = participant.getProgramArguments(configuration, launch, monitor);
            if (extensionArguments == null) continue;
            arguments.append(" ").append(extensionArguments);
        }
    }

    public void appendVMArguments(MavenRuntimeLaunchSupport.VMArguments arguments, ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) {
        for (IMavenLaunchParticipant participant : this.participants) {
            arguments.append(participant.getVMArguments(configuration, launch, monitor));
        }
        MavenBuildProjectDataConnection.openListenerConnection(launch, arguments);
    }
}

