/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.sourcelookup.ui.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.launching.sourcelookup.advanced.AdvancedSourceLookup;
import org.eclipse.jdt.launching.sourcelookup.advanced.AdvancedSourceLookupParticipant;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.m2e.sourcelookup.internal.MavenArtifactIdentifier;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SourceLookupInfoDialog
extends Dialog {
    private final Object debugElement;
    private final AdvancedSourceLookupParticipant sourceLookup;
    private Text textLocation;
    private Text textGAV;
    private Text textJavaProject;
    private Text textSourceContainer;
    private final IProgressMonitor monitor = new NullProgressMonitor();

    public SourceLookupInfoDialog(Shell parentShell, Object debugElement, AdvancedSourceLookupParticipant sourceLookup) {
        super(parentShell);
        this.setShellStyle(48);
        this.debugElement = debugElement;
        this.sourceLookup = sourceLookup;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Source lookup properties");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblCodeLocation = new Label(container, 0);
        lblCodeLocation.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCodeLocation.setText("Code location:");
        this.textLocation = new Text(container, 2114);
        this.textLocation.setEditable(false);
        this.textLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblGav = new Label(container, 0);
        lblGav.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblGav.setText("GAV:");
        this.textGAV = new Text(container, 2112);
        this.textGAV.setEditable(false);
        this.textGAV.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblJavaProject = new Label(container, 0);
        lblJavaProject.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblJavaProject.setText("Java project:");
        this.textJavaProject = new Text(container, 2112);
        this.textJavaProject.setEditable(false);
        this.textJavaProject.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblSourceContainer = new Label(container, 0);
        lblSourceContainer.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSourceContainer.setText("Source container:");
        this.textSourceContainer = new Text(container, 2112);
        this.textSourceContainer.setEditable(false);
        this.textSourceContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite fillerComposite = new Composite(container, 0);
        fillerComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 2, 1));
        Composite actionsComposite = new Composite(container, 0);
        actionsComposite.setLayout((Layout)new RowLayout(256));
        actionsComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        Button btnCopy = new Button(actionsComposite, 0);
        btnCopy.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.copyToClipboard()));
        btnCopy.setToolTipText("Copy to clipboard");
        btnCopy.setText("Copy");
        Button btnRefresh = new Button(actionsComposite, 0);
        btnRefresh.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            try {
                this.sourceLookup.getSourceContainer(this.debugElement, true, this.monitor);
            }
            catch (CoreException e1) {
                this.showError(e1);
            }
        }));
        btnRefresh.setToolTipText("Force rediscovery of source lookup information for this code location.");
        btnRefresh.setText("Refresh");
        this.updateDisplay(this.monitor);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    private void updateDisplay(IProgressMonitor moninor) {
        try {
            File location = AdvancedSourceLookup.getClassesLocation((Object)this.debugElement);
            if (location == null) {
                return;
            }
            this.textLocation.setText(location.getAbsolutePath());
            ISourceContainer container = this.sourceLookup.getSourceContainer(this.debugElement, false, moninor);
            Collection artifacts = MavenArtifactIdentifier.identify((File)location);
            this.textGAV.setText(artifacts.toString());
            this.textJavaProject.setText("<not-implemented>");
            this.textSourceContainer.setText(this.toString(container));
        }
        catch (CoreException e) {
            this.showError(e);
        }
    }

    void showError(CoreException e) {
        ErrorDialog.openError((Shell)this.getParentShell(), (String)"Source lookup info", (String)"Could not determine code maven coordinates", (IStatus)e.getStatus());
    }

    private String toString(ISourceContainer container) {
        if (container == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(container.getClass().getSimpleName()).append(" ").append(container.getName());
        if (container instanceof PackageFragmentRootSourceContainer var3_4) {
            sb.append(" ").append(fragmentRoot.getPackageFragmentRoot().getJavaProject().getProject());
        }
        return sb.toString();
    }

    void copyToClipboard() {
        ArrayList<TextTransfer> dataTypes = new ArrayList<TextTransfer>();
        ArrayList<String> data = new ArrayList<String>();
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        StringBuilder sb = new StringBuilder();
        sb.append("Location: ").append(this.textLocation.getText()).append("\n");
        sb.append("GAV: ").append(this.textGAV.getText()).append("\n");
        sb.append("Java project: ").append(this.textJavaProject.getText()).append("\n");
        sb.append("Source container: ").append(this.textSourceContainer.getText()).append("\n");
        dataTypes.add(TextTransfer.getInstance());
        data.add(sb.toString());
        clipboard.setContents(data.toArray(), dataTypes.toArray(new Transfer[dataTypes.size()]));
        clipboard.dispose();
    }
}

