/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tuple {
    private final Map<String, ? extends Object> values;

    public static Tuple fromMap(Map<String, ? extends Object> map) {
        return new Tuple(map);
    }

    public static Tuple fromCalendar(Calendar cal) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("timezone", cal.getTimeZone().getID());
        values.put("year", cal.get(1));
        values.put("month", cal.get(2));
        values.put("day_of_month", cal.get(5));
        values.put("day_of_week", cal.get(7));
        values.put("day_of_week_in_month", cal.get(8));
        values.put("day_of_year", cal.get(6));
        values.put("era", cal.get(0));
        values.put("hour", cal.get(10));
        values.put("hour_of_day", cal.get(11));
        values.put("minute", cal.get(12));
        values.put("second", cal.get(13));
        values.put("millisecond", cal.get(14));
        values.put("am_pm", cal.get(9));
        values.put("week_of_month", cal.get(4));
        values.put("week_of_year", cal.get(3));
        return new Tuple(values);
    }

    public Tuple() {
        this.values = Collections.emptyMap();
    }

    public Tuple(Map<String, ? extends Object> map) {
        this.values = map;
    }

    public Object get(Object name) {
        return this.values.get(name);
    }

    public boolean equals(Object o) {
        return o instanceof Tuple ? this.values.equals(((Tuple)o).values) : false;
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public Map<String, ? extends Object> asMap() {
        return this.values;
    }

    public Date toDate() {
        TimeZone tz = null;
        if (this.values.containsKey("timezone")) {
            tz = TimeZone.getTimeZone((String)this.values.get("timezone"));
        }
        Locale locale = null;
        if (this.values.containsKey("locale")) {
            locale = EMFTVMUtil.getLocale((String)this.values.get("locale"));
        }
        Calendar cal = locale != null && tz != null ? Calendar.getInstance(tz, locale) : (locale != null ? Calendar.getInstance(locale) : (tz != null ? Calendar.getInstance(tz) : Calendar.getInstance()));
        cal.clear();
        if (this.values.containsKey("year")) {
            cal.set(1, (Integer)this.values.get("year"));
        }
        if (this.values.containsKey("month")) {
            cal.set(2, (Integer)this.values.get("month"));
        }
        if (this.values.containsKey("day_of_month")) {
            cal.set(5, (Integer)this.values.get("day_of_month"));
        }
        if (this.values.containsKey("day_of_week")) {
            cal.set(7, (Integer)this.values.get("day_of_week"));
        }
        if (this.values.containsKey("day_of_week_in_month")) {
            cal.set(8, (Integer)this.values.get("day_of_week_in_month"));
        }
        if (this.values.containsKey("day_of_year")) {
            cal.set(6, (Integer)this.values.get("day_of_year"));
        }
        if (this.values.containsKey("era")) {
            cal.set(0, (Integer)this.values.get("era"));
        }
        if (this.values.containsKey("hour")) {
            cal.set(10, (Integer)this.values.get("hour"));
        }
        if (this.values.containsKey("hour_of_day")) {
            cal.set(11, (Integer)this.values.get("hour_of_day"));
        }
        if (this.values.containsKey("minute")) {
            cal.set(12, (Integer)this.values.get("minute"));
        }
        if (this.values.containsKey("second")) {
            cal.set(13, (Integer)this.values.get("second"));
        }
        if (this.values.containsKey("millisecond")) {
            cal.set(14, (Integer)this.values.get("millisecond"));
        }
        if (this.values.containsKey("am_pm")) {
            cal.set(9, (Integer)this.values.get("am_pm"));
        }
        if (this.values.containsKey("week_of_month")) {
            cal.set(4, (Integer)this.values.get("week_of_month"));
        }
        if (this.values.containsKey("week_of_year")) {
            cal.set(3, (Integer)this.values.get("week_of_year"));
        }
        return cal.getTime();
    }
}

