/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.finalizer;

import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="finalizer_overview")
@Icon(value="/META-INF/icons/finalizer.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingfinalizer.html")
public class FinalizerQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;

    public IResult execute(IProgressListener listener) throws Exception {
        SectionSpec spec = new SectionSpec(Messages.FinalizerQuery_Finalizers);
        IResult result = SnapshotQuery.lookup("finalizer_in_processing", this.snapshot).execute(listener);
        QuerySpec inProcessing = new QuerySpec(Messages.FinalizerQuery_InProcessing, result);
        inProcessing.setCommand("finalizer_in_processing");
        spec.add((Spec)inProcessing);
        result = SnapshotQuery.lookup("finalizer_queue", this.snapshot).execute(listener);
        QuerySpec finalizerQueue = new QuerySpec(Messages.FinalizerQuery_ReadyForFinalizer, result);
        finalizerQueue.setCommand("finalizer_queue");
        spec.add((Spec)finalizerQueue);
        finalizerQueue.set("html.show_heading", Boolean.FALSE.toString());
        result = SnapshotQuery.lookup("finalizer_thread", this.snapshot).execute(listener);
        QuerySpec finalizerThread = new QuerySpec(Messages.FinalizerQuery_FinalizerThread, result);
        finalizerThread.setCommand("finalizer_thread");
        spec.add((Spec)finalizerThread);
        result = SnapshotQuery.lookup("finalizer_thread_locals", this.snapshot).execute(listener);
        QuerySpec finalizerLocals = new QuerySpec(Messages.FinalizerQuery_FinalizerThreadLocals, result);
        finalizerLocals.setCommand("finalizer_thread_locals");
        spec.add((Spec)finalizerLocals);
        return spec;
    }
}

